/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableReaderMetadataColumn;
import io.questdb.cairo.TableReaderMetadataTransitionIndex;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

public class TableReaderMetadata
extends AbstractRecordMetadata
implements TableMetadata,
Mutable {
    protected final CairoConfiguration configuration;
    private final IntList columnOrderList = new IntList();
    private final FilesFacade ff;
    private final LowerCaseCharSequenceIntHashMap tmpValidationMap = new LowerCaseCharSequenceIntHashMap();
    private boolean isCopy;
    private boolean isSoftLink;
    private int maxUncommittedRows;
    private MemoryCARW metaCopyMem;
    private MemoryMR metaMem;
    private long metadataVersion;
    private long o3MaxLag;
    private int partitionBy;
    private Path path;
    private int plen;
    private int tableId;
    private TableToken tableToken;
    private TableReaderMetadataTransitionIndex transitionIndex;
    private MemoryMR transitionMeta;
    private int ttlHoursOrMonths;
    private boolean walEnabled;

    public TableReaderMetadata(CairoConfiguration configuration, TableToken tableToken) {
        try {
            this.configuration = configuration;
            this.ff = configuration.getFilesFacade();
            this.tableToken = tableToken;
            this.path = new Path();
            this.path.of(configuration.getDbRoot()).concat(tableToken.getDirName());
            this.plen = this.path.size();
            this.isSoftLink = Files.isSoftLink(this.path.$());
            this.metaMem = Vm.getCMRInstance();
            this.metaCopyMem = Vm.getCARWInstance(this.ff.getPageSize(), Integer.MAX_VALUE, 63);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public TableReaderMetadata(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
        this.tableToken = null;
        this.metaMem = Vm.getCMRInstance();
    }

    public TableReaderMetadataTransitionIndex applyTransition() {
        MemoryMR temp = this.metaMem;
        this.metaMem = this.transitionMeta;
        this.transitionMeta = temp;
        this.isCopy = false;
        Misc.free(this.transitionMeta);
        Misc.free(this.metaCopyMem);
        return this.applyTransition0(this.metaMem, this.columnCount);
    }

    public TableReaderMetadataTransitionIndex applyTransitionFrom(TableReaderMetadata srcMeta) {
        this.copyMemFrom(srcMeta);
        this.isCopy = true;
        Misc.free(this.metaMem);
        Misc.free(this.transitionMeta);
        return this.applyTransition0(this.metaCopyMem, this.columnCount);
    }

    @Override
    public void clear() {
        super.clear();
        Misc.free(this.metaMem);
        Misc.free(this.metaCopyMem);
        Misc.free(this.transitionMeta);
        this.isCopy = false;
    }

    @Override
    public void close() {
        this.metaMem = Misc.free(this.metaMem);
        this.metaCopyMem = Misc.free(this.metaCopyMem);
        this.transitionMeta = Misc.free(this.transitionMeta);
        this.path = Misc.free(this.path);
        this.isCopy = false;
    }

    public void dumpTo(MemoryMA mem) {
        MemoryR metaMem = this.getMetaMem();
        long len = metaMem.size();
        for (long p = 0L; p < len; ++p) {
            mem.putByte(metaMem.getByte(p));
        }
    }

    public int getDenseSymbolIndex(int columnIndex) {
        return ((TableReaderMetadataColumn)this.columnMetadata.getQuick(columnIndex)).getDenseSymbolIndex();
    }

    @Override
    public int getIndexBlockCapacity(int columnIndex) {
        return this.getColumnMetadata(columnIndex).getIndexValueBlockCapacity();
    }

    @Override
    public int getMaxUncommittedRows() {
        return this.maxUncommittedRows;
    }

    @Override
    public long getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public long getO3MaxLag() {
        return this.o3MaxLag;
    }

    @Override
    public int getPartitionBy() {
        return this.partitionBy;
    }

    @Override
    public boolean getSymbolCacheFlag(int columnIndex) {
        return this.getColumnMetadata(columnIndex).isSymbolIndexFlag();
    }

    @Override
    public int getSymbolCapacity(int columnIndex) {
        return this.getColumnMetadata(columnIndex).getSymbolCapacity();
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public CharSequence getTableName() {
        return this.tableToken.getTableName();
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public int getTtlHoursOrMonths() {
        return this.ttlHoursOrMonths;
    }

    @Override
    public boolean isIndexed(int columnIndex) {
        return this.getColumnMetadata(columnIndex).isSymbolIndexFlag();
    }

    public boolean isSoftLink() {
        return this.isSoftLink;
    }

    @Override
    public boolean isWalEnabled() {
        return this.walEnabled;
    }

    public void load(LPSZ path) {
        try {
            this.isCopy = false;
            Misc.free(this.metaCopyMem);
            this.metaMem.smallFile(this.ff, path, 55);
            TableUtils.validateMeta(this.metaMem, null, 426);
            this.readFromMem(this.metaMem);
        }
        catch (Throwable e) {
            this.clear();
            throw e;
        }
    }

    public void load() {
        long spinLockTimeout = this.configuration.getSpinLockTimeout();
        MillisecondClock millisecondClock = this.configuration.getMillisecondClock();
        long deadline = this.configuration.getMillisecondClock().getTicks() + spinLockTimeout;
        this.path.trimTo(this.plen).concat("_meta");
        boolean existenceChecked = false;
        while (true) {
            try {
                this.load(this.path.$());
                return;
            }
            catch (CairoException ex) {
                if (!existenceChecked) {
                    this.path.trimTo(this.plen).slash();
                    if (!this.ff.exists(this.path.$())) {
                        throw CairoException.tableDoesNotExist(this.tableToken.getTableName());
                    }
                    this.path.trimTo(this.plen).concat("_meta").$();
                }
                existenceChecked = true;
                TableUtils.handleMetadataLoadException(this.tableToken.getTableName(), deadline, ex, millisecondClock, spinLockTimeout);
                continue;
            }
            break;
        }
    }

    public void loadFrom(TableReaderMetadata srcMeta) {
        assert (this.tableToken.equals(srcMeta.tableToken));
        this.copyMemFrom(srcMeta);
        try {
            this.isCopy = true;
            Misc.free(this.metaMem);
            this.readFromMem(this.metaCopyMem);
        }
        catch (Throwable e) {
            this.clear();
            throw e;
        }
    }

    public boolean prepareTransition(long txnMetadataVersion) {
        if (this.transitionMeta == null) {
            this.transitionMeta = Vm.getCMRInstance();
        }
        this.path.trimTo(this.plen).concat("_meta");
        this.transitionMeta.smallFile(this.ff, this.path.$(), 55);
        if (this.transitionMeta.size() >= 40L && txnMetadataVersion != this.transitionMeta.getLong(32L)) {
            return false;
        }
        this.tmpValidationMap.clear();
        TableUtils.validateMeta(this.transitionMeta, this.tmpValidationMap, 426);
        return true;
    }

    public void readFromMem(MemoryR mem) {
        int columnCount = mem.getInt(0L);
        int timestampIndex = mem.getInt(8L);
        this.partitionBy = mem.getInt(4L);
        this.tableId = mem.getInt(16L);
        this.maxUncommittedRows = mem.getInt(20L);
        this.o3MaxLag = mem.getLong(24L);
        this.metadataVersion = mem.getLong(32L);
        this.walEnabled = mem.getBool(40L);
        this.ttlHoursOrMonths = TableUtils.getTtlHoursOrMonths(mem);
        this.columnMetadata.clear();
        this.timestampIndex = -1;
        TableUtils.buildColumnListFromMetadataFile(mem, columnCount, this.columnOrderList);
        this.columnNameIndexMap.clear();
        int n = this.columnOrderList.size();
        for (int i = 0; i < n; i += 3) {
            int writerIndex = this.columnOrderList.get(i);
            if (writerIndex < 0) continue;
            int stableIndex = i / 3;
            CharSequence name = mem.getStrA(this.columnOrderList.get(i + 1));
            int denseSymbolIndex = this.columnOrderList.get(i + 2);
            assert (name != null);
            int columnType = TableUtils.getColumnType(mem, writerIndex);
            if (columnType <= -1) continue;
            String colName = Chars.toString(name);
            this.columnMetadata.add(new TableReaderMetadataColumn(colName, columnType, TableUtils.isColumnIndexed(mem, writerIndex), TableUtils.getIndexBlockCapacity(mem, writerIndex), true, null, writerIndex, TableUtils.isColumnDedupKey(mem, writerIndex), denseSymbolIndex, stableIndex, TableUtils.isSymbolCached(mem, writerIndex), TableUtils.getSymbolCapacity(mem, writerIndex)));
            int denseIndex = this.columnMetadata.size() - 1;
            if (!this.columnNameIndexMap.put(colName, denseIndex)) {
                throw TableUtils.validationException(mem).put("Duplicate column [name=").put(name).put("] at ").put(i);
            }
            if (writerIndex != timestampIndex) continue;
            this.timestampIndex = denseIndex;
        }
        this.columnCount = this.columnMetadata.size();
    }

    public void updateTableToken(TableToken tableToken) {
        this.tableToken = tableToken;
    }

    private TableReaderMetadataTransitionIndex applyTransition0(MemoryR newMetaMem, int existingColumnCount) {
        this.columnNameIndexMap.clear();
        int columnCount = newMetaMem.getInt(0L);
        assert (columnCount >= existingColumnCount);
        this.columnMetadata.setPos(columnCount);
        int timestampIndex = newMetaMem.getInt(8L);
        this.tableId = newMetaMem.getInt(16L);
        this.metadataVersion = newMetaMem.getLong(32L);
        this.maxUncommittedRows = newMetaMem.getInt(20L);
        this.o3MaxLag = newMetaMem.getLong(24L);
        this.walEnabled = newMetaMem.getBool(40L);
        this.ttlHoursOrMonths = TableUtils.getTtlHoursOrMonths(newMetaMem);
        int shiftLeft = 0;
        int existingIndex = 0;
        TableUtils.buildColumnListFromMetadataFile(newMetaMem, columnCount, this.columnOrderList);
        int newColumnCount = newMetaMem.getInt(0L);
        if (this.transitionIndex == null) {
            this.transitionIndex = new TableReaderMetadataTransitionIndex();
        } else {
            this.transitionIndex.clear();
        }
        TableUtils.buildColumnListFromMetadataFile(newMetaMem, newColumnCount, this.columnOrderList);
        int n = this.columnOrderList.size();
        for (int i = 0; i < n; i += 3) {
            int existingStableIndex;
            int stableIndex = i / 3;
            int writerIndex = this.columnOrderList.get(i);
            if (writerIndex < 0) continue;
            CharSequence name = newMetaMem.getStrA(this.columnOrderList.get(i + 1));
            assert (name != null);
            int denseSymbolIndex = this.columnOrderList.get(i + 2);
            int newColumnType = TableUtils.getColumnType(newMetaMem, writerIndex);
            int columnType = TableUtils.getColumnType(newMetaMem, writerIndex);
            boolean isIndexed = TableUtils.isColumnIndexed(newMetaMem, writerIndex);
            boolean isDedupKey = TableUtils.isColumnDedupKey(newMetaMem, writerIndex);
            int indexBlockCapacity = TableUtils.getIndexBlockCapacity(newMetaMem, writerIndex);
            boolean symbolIsCached = TableUtils.isSymbolCached(newMetaMem, writerIndex);
            int symbolCapacity = TableUtils.getSymbolCapacity(newMetaMem, writerIndex);
            TableReaderMetadataColumn existing = null;
            if (existingIndex < existingColumnCount && (existingStableIndex = (existing = (TableReaderMetadataColumn)this.columnMetadata.getQuick(existingIndex)).getStableIndex()) > stableIndex && columnType < 0) continue;
            int outIndex = existingIndex - shiftLeft;
            if (newColumnType < 0) {
                ++shiftLeft;
                if (existing != null) {
                    this.transitionIndex.markDeleted(existingIndex);
                }
            } else {
                String newName;
                boolean rename = existing != null && !Chars.equals((CharSequence)existing.getColumnName(), name);
                String string = newName = rename || existing == null ? Chars.toString(name) : existing.getColumnName();
                if (rename || existing == null || existing.getWriterIndex() != writerIndex || existing.isSymbolIndexFlag() != isIndexed || existing.getIndexValueBlockCapacity() != indexBlockCapacity || existing.isDedupKeyFlag() != isDedupKey || existing.getDenseSymbolIndex() != denseSymbolIndex || existing.getStableIndex() != stableIndex) {
                    this.columnMetadata.setQuick(outIndex, new TableReaderMetadataColumn(newName, columnType, isIndexed, indexBlockCapacity, true, null, writerIndex, isDedupKey, denseSymbolIndex, stableIndex, symbolIsCached, symbolCapacity));
                    if (existing != null) {
                        this.transitionIndex.markDeleted(existingIndex);
                    }
                    this.transitionIndex.markCopyFrom(outIndex, writerIndex);
                } else {
                    this.columnMetadata.setQuick(outIndex, existing);
                    this.transitionIndex.markReusedAction(outIndex, existingIndex);
                    if (existingIndex > outIndex) {
                        this.transitionIndex.markReplaced(existingIndex);
                    }
                }
                this.columnNameIndexMap.put(newName, outIndex);
                if (timestampIndex == writerIndex) {
                    this.timestampIndex = outIndex;
                }
            }
            ++existingIndex;
        }
        this.columnMetadata.setPos(existingIndex - shiftLeft);
        this.columnCount = this.columnMetadata.size();
        if (timestampIndex < 0) {
            this.timestampIndex = timestampIndex;
        }
        return this.transitionIndex;
    }

    private void copyMemFrom(TableReaderMetadata srcMeta) {
        MemoryR srcMetaMem = srcMeta.getMetaMem();
        long len = srcMetaMem.size();
        this.metaCopyMem.jumpTo(0L);
        for (long p = 0L; p < len; ++p) {
            this.metaCopyMem.putByte(srcMetaMem.getByte(p));
        }
    }

    private MemoryR getMetaMem() {
        return !this.isCopy ? this.metaMem : this.metaCopyMem;
    }
}

