/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.LogRecordSinkAdapter;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.NoopArrayWriteState;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.log.Log;
import io.questdb.log.LogRecord;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.Interval;
import io.questdb.std.Numbers;
import io.questdb.std.Uuid;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.MutableCharSink;
import io.questdb.std.str.Utf8Sequence;

public class CursorPrinter {
    private static final char COLUMN_DELIMITER = '\t';

    public static void printColumn(Record r, RecordMetadata m, int columnIndex, CharSink<?> sink, boolean printTypes) {
        CursorPrinter.printColumn(r, m, columnIndex, sink, false, printTypes);
    }

    public static void printColumn(Record record, RecordMetadata metadata, int columnIndex, CharSink<?> sink, boolean symbolAsString, boolean printTypes) {
        CursorPrinter.printColumn(record, metadata, columnIndex, sink, symbolAsString, printTypes, null);
    }

    public static void printColumn(Record record, RecordMetadata metadata, int columnIndex, CharSink<?> sink, boolean symbolAsString, boolean printTypes, String nullStringValue) {
        int columnType = metadata.getColumnType(columnIndex);
        switch (ColumnType.tagOf(columnType)) {
            case 7: {
                DateFormatUtils.appendDateTime(sink, record.getDate(columnIndex));
                break;
            }
            case 8: {
                TimestampFormatUtils.appendDateTimeUSec(sink, record.getTimestamp(columnIndex));
                break;
            }
            case 10: {
                double v = record.getDouble(columnIndex);
                if (Numbers.isFinite(v)) {
                    sink.put(v);
                    break;
                }
                sink.put("null");
                break;
            }
            case 9: {
                float f = record.getFloat(columnIndex);
                if (Numbers.isFinite(f)) {
                    sink.put(f);
                    break;
                }
                sink.put("null");
                break;
            }
            case 5: {
                sink.put(record.getInt(columnIndex));
                break;
            }
            case 33: {
                sink.put("null");
                break;
            }
            case 11: {
                if (!symbolAsString | metadata.getColumnType(columnIndex) != 12) {
                    CharSequence val = record.getStrA(columnIndex);
                    sink.put(val != null ? val : nullStringValue);
                    break;
                }
            }
            case 12: {
                CharSequence sym = record.getSymA(columnIndex);
                sink.put(sym != null ? sym : nullStringValue);
                break;
            }
            case 3: {
                sink.put(record.getShort(columnIndex));
                break;
            }
            case 4: {
                char c = record.getChar(columnIndex);
                if (c <= '\u0000') break;
                sink.put(c);
                break;
            }
            case 6: {
                sink.put(record.getLong(columnIndex));
                break;
            }
            case 14: {
                CursorPrinter.putGeoHash(record.getGeoByte(columnIndex), ColumnType.getGeoHashBits(columnType), sink);
                break;
            }
            case 15: {
                CursorPrinter.putGeoHash(record.getGeoShort(columnIndex), ColumnType.getGeoHashBits(columnType), sink);
                break;
            }
            case 16: {
                CursorPrinter.putGeoHash(record.getGeoInt(columnIndex), ColumnType.getGeoHashBits(columnType), sink);
                break;
            }
            case 17: {
                CursorPrinter.putGeoHash(record.getGeoLong(columnIndex), ColumnType.getGeoHashBits(columnType), sink);
                break;
            }
            case 2: {
                sink.put(record.getByte(columnIndex));
                break;
            }
            case 1: {
                sink.put(record.getBool(columnIndex));
                break;
            }
            case 18: {
                BinarySequence bin = record.getBin(columnIndex);
                if (bin != null) {
                    Chars.toSink(bin, sink);
                    break;
                }
                sink.put(nullStringValue);
                break;
            }
            case 13: {
                record.getLong256(columnIndex, sink);
                break;
            }
            case 19: 
            case 24: {
                long hi = record.getLong128Hi(columnIndex);
                long lo = record.getLong128Lo(columnIndex);
                if (Uuid.isNull(lo, hi)) break;
                Uuid uuid = new Uuid(lo, hi);
                uuid.toSink(sink);
                break;
            }
            case 25: {
                int val = record.getIPv4(columnIndex);
                if (val == 0) break;
                Numbers.intToIPv4Sink(sink, val);
                break;
            }
            case 26: {
                Utf8Sequence varchar = record.getVarcharA(columnIndex);
                if (varchar != null) {
                    sink.put(varchar);
                    break;
                }
                sink.put(nullStringValue);
                break;
            }
            case 32: {
                Interval interval = record.getInterval(columnIndex);
                if (Interval.NULL.equals(interval)) break;
                interval.toSink(sink);
                break;
            }
            case 27: {
                ArrayTypeDriver.arrayToJson(record.getArray(columnIndex, columnType), sink, NoopArrayWriteState.INSTANCE);
                break;
            }
            case 30: {
                sink.put(record.getStrA(columnIndex));
            }
        }
        if (printTypes) {
            int printColType = symbolAsString && ColumnType.isSymbol(columnType) ? 11 : columnType;
            sink.put(':').put(ColumnType.nameOf(printColType));
        }
    }

    public static void printColumn(Record record, RecordMetadata metadata, int columnIndex, CharSink<?> sink) {
        CursorPrinter.printColumn(record, metadata, columnIndex, sink, false, false);
    }

    public static void printHeader(RecordMetadata metadata, CharSink<?> sink) {
        int n = metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sink.put('\t');
            }
            sink.put(metadata.getColumnName(i));
        }
    }

    public static void println(RecordCursor cursor, RecordMetadata metadata, boolean printHeader, Log sink) {
        LogRecordSinkAdapter logRecSink = new LogRecordSinkAdapter();
        if (printHeader) {
            LogRecord line = sink.xDebugW();
            CursorPrinter.printHeader(metadata, logRecSink.of(line));
            line.$();
        }
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            LogRecord line = sink.xDebugW();
            CursorPrinter.print(record, metadata, logRecSink.of(line), false);
            line.$();
        }
    }

    public static void println(Record record, RecordMetadata metadata, CharSink<?> sink) {
        CursorPrinter.println(record, metadata, sink, false);
    }

    public static void println(Record r, RecordMetadata m, CharSink<?> sink, boolean printTypes) {
        CursorPrinter.print(r, m, sink, printTypes);
        sink.putAscii('\n');
    }

    public static void println(RecordMetadata metadata, CharSink<?> sink) {
        CursorPrinter.printHeader(metadata, sink);
        sink.putAscii('\n');
    }

    public static void println(RecordCursor cursor, RecordMetadata metadata, MutableCharSink<?> sink) {
        CursorPrinter.println(cursor, metadata, sink, true, false);
    }

    public static void println(RecordCursor cursor, RecordMetadata metadata, MutableCharSink<?> sink, boolean printHeader, boolean printTypes) {
        sink.clear();
        if (printHeader) {
            CursorPrinter.println(metadata, sink);
        }
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            CursorPrinter.println(record, metadata, sink, printTypes);
        }
    }

    private static void print(Record record, RecordMetadata metadata, CharSink<?> sink, boolean printTypes) {
        int sz = metadata.getColumnCount();
        for (int i = 0; i < sz; ++i) {
            if (i > 0) {
                sink.put('\t');
            }
            CursorPrinter.printColumn(record, metadata, i, sink, printTypes);
        }
    }

    private static void putGeoHash(long hash, int bits, CharSink<?> sink) {
        if (hash == -1L) {
            return;
        }
        if (bits % 5 == 0) {
            GeoHashes.appendCharsUnsafe(hash, bits / 5, sink);
        } else {
            GeoHashes.appendBinaryStringUnsafe(hash, bits, sink);
        }
    }
}

