/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnType;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import org.jetbrains.annotations.NotNull;

public class CairoColumn
implements Sinkable {
    public static final Log LOG = LogFactory.getLog(CairoEngine.class);
    private boolean dedupKey;
    private boolean designated;
    private int indexBlockCapacity;
    private boolean indexed;
    private long metadataVersion;
    private CharSequence name;
    private int position;
    private boolean symbolCached;
    private int symbolCapacity;
    private boolean symbolTableStatic;
    private int type;
    private int writerIndex;

    public void copyTo(@NotNull CairoColumn target) {
        target.designated = this.designated;
        target.indexBlockCapacity = this.indexBlockCapacity;
        target.dedupKey = this.dedupKey;
        target.indexed = this.indexed;
        target.symbolTableStatic = this.symbolTableStatic;
        target.name = this.name;
        target.position = this.position;
        target.symbolCached = this.symbolCached;
        target.symbolCapacity = this.symbolCapacity;
        target.type = this.type;
        target.writerIndex = this.writerIndex;
        target.metadataVersion = this.metadataVersion;
    }

    public int getIndexBlockCapacity() {
        return this.indexBlockCapacity;
    }

    public CharSequence getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public int getSymbolCapacity() {
        return this.symbolCapacity;
    }

    public int getType() {
        return this.type;
    }

    public int getWriterIndex() {
        return this.writerIndex;
    }

    public boolean isDedupKey() {
        return this.dedupKey;
    }

    public boolean isDesignated() {
        return this.designated;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isSymbolCached() {
        return this.symbolCached;
    }

    public boolean isSymbolTableStatic() {
        return this.symbolTableStatic;
    }

    public void setDedupKeyFlag(boolean dedupKey) {
        this.dedupKey = dedupKey;
    }

    public void setDesignatedFlag(boolean designated) {
        this.designated = designated;
    }

    public void setIndexBlockCapacity(int indexBlockCapacity) {
        this.indexBlockCapacity = indexBlockCapacity;
    }

    public void setIndexedFlag(boolean indexed) {
        this.indexed = indexed;
    }

    public void setName(CharSequence name) {
        this.name = name;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setSymbolCached(boolean symbolCached) {
        this.symbolCached = symbolCached;
    }

    public void setSymbolCapacity(int symbolCapacity) {
        this.symbolCapacity = symbolCapacity;
    }

    public void setSymbolTableStaticFlag(boolean symbolTableStatic) {
        this.symbolTableStatic = symbolTableStatic;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setWriterIndex(int writerIndex) {
        this.writerIndex = writerIndex;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.put("CairoColumn [");
        sink.put("name=").put(this.getName()).put(", ");
        sink.put("position=").put(this.getPosition()).put(", ");
        sink.put("type=").put(ColumnType.nameOf(this.getType())).put(", ");
        sink.put("isDedupKey=").put(this.isDedupKey()).put(", ");
        sink.put("isDesignated=").put(this.isDesignated()).put(", ");
        sink.put("isSymbolTableStatic=").put(this.isSymbolTableStatic()).put(", ");
        sink.put("symbolCached=").put(this.isSymbolCached()).put(", ");
        sink.put("symbolCapacity=").put(this.getSymbolCapacity()).put(", ");
        sink.put("isIndexed=").put(this.isIndexed()).put(", ");
        sink.put("indexBlockCapacity=").put(this.getIndexBlockCapacity()).put(", ");
        sink.put("writerIndex=").put(this.getWriterIndex()).put("]");
    }
}

