/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cache;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.cache.CachesEndpoint;
import org.springframework.boot.actuate.cache.CachesEndpointWebExtension;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={CacheAutoConfiguration.class})
@ConditionalOnClass(value={CacheManager.class})
@ConditionalOnAvailableEndpoint(value=CachesEndpoint.class)
public class CachesEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CachesEndpoint cachesEndpoint(Map<String, CacheManager> cacheManagers) {
        return new CachesEndpoint(cacheManagers);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={CachesEndpoint.class})
    @ConditionalOnAvailableEndpoint(exposure={EndpointExposure.WEB})
    public CachesEndpointWebExtension cachesEndpointWebExtension(CachesEndpoint cachesEndpoint) {
        return new CachesEndpointWebExtension(cachesEndpoint);
    }
}

