/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor.api;

import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.AdvisorUtils;
import org.springframework.ai.chat.client.advisor.api.AdvisorChain;
import org.springframework.ai.chat.client.advisor.api.CallAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisorChain;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public interface BaseAdvisor
extends CallAdvisor,
StreamAdvisor {
    public static final Scheduler DEFAULT_SCHEDULER = Schedulers.boundedElastic();

    @Override
    default public ChatClientResponse adviseCall(ChatClientRequest chatClientRequest, CallAdvisorChain callAdvisorChain) {
        Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
        Assert.notNull((Object)callAdvisorChain, (String)"callAdvisorChain cannot be null");
        ChatClientRequest processedChatClientRequest = this.before(chatClientRequest, callAdvisorChain);
        ChatClientResponse chatClientResponse = callAdvisorChain.nextCall(processedChatClientRequest);
        return this.after(chatClientResponse, callAdvisorChain);
    }

    @Override
    default public Flux<ChatClientResponse> adviseStream(ChatClientRequest chatClientRequest, StreamAdvisorChain streamAdvisorChain) {
        Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
        Assert.notNull((Object)streamAdvisorChain, (String)"streamAdvisorChain cannot be null");
        Assert.notNull((Object)this.getScheduler(), (String)"scheduler cannot be null");
        Flux chatClientResponseFlux = Mono.just((Object)chatClientRequest).publishOn(this.getScheduler()).map(request -> this.before((ChatClientRequest)request, streamAdvisorChain)).flatMapMany(streamAdvisorChain::nextStream);
        return chatClientResponseFlux.map(response -> {
            if (AdvisorUtils.onFinishReason().test((ChatClientResponse)response)) {
                response = this.after((ChatClientResponse)response, streamAdvisorChain);
            }
            return response;
        }).onErrorResume(error -> Flux.error((Throwable)new IllegalStateException("Stream processing failed", (Throwable)error)));
    }

    @Override
    default public String getName() {
        return this.getClass().getSimpleName();
    }

    public ChatClientRequest before(ChatClientRequest var1, AdvisorChain var2);

    public ChatClientResponse after(ChatClientResponse var1, AdvisorChain var2);

    default public Scheduler getScheduler() {
        return DEFAULT_SCHEDULER;
    }
}

