/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.tools.impl;

import com.usthe.sureness.subject.SubjectSum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.ai.config.McpContextHolder;
import org.apache.hertzbeat.ai.tools.MonitorTools;
import org.apache.hertzbeat.ai.utils.UtilityClass;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.manager.pojo.dto.MonitorDto;
import org.apache.hertzbeat.manager.service.AppService;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class MonitorToolsImpl
implements MonitorTools {
    private static final Logger log = LoggerFactory.getLogger(MonitorToolsImpl.class);
    @Autowired
    private MonitorService monitorService;
    @Autowired
    private AppService appService;

    @Override
    @Tool(name="query_monitors", description="HertzBeat: Query Existing/configured monitors in HertzBeat.\nThis tool retrieves monitors based on various filters and parameters.\nComprehensive monitor querying with flexible filtering, pagination, and specialized views.\n\nMONITOR STATUSES:\n- status=1: Online/Active monitors (healthy, responding normally)\n- status=2: Offline monitors (not responding, connection failed)\n- status=3: Unreachable monitors (network/connectivity issues)\n- status=0: Paused monitors (manually disabled/suspended)\n- status=9 or null: All monitors regardless of status (default)\n\nCOMMON USE CASES & PARAMETER COMBINATIONS:\n\n1. BASIC MONITOR LISTING:\n   - Default: No parameters (shows all monitors, 8 per page)\n   - By type: app='linux' (show only Linux monitors)\n   - Search: search='web' (find monitors with 'web' in name/host)\n\n2. STATUS-BASED QUERIES:\n   - Healthy monitors: status=1, pageSize=50\n   - Problem monitors: status=2 or status=3, pageSize=50\n   - Offline monitors only: status=2\n   - Unreachable monitors only: status=3\n   - Paused monitors: status=0\n\n3. MONITORING HEALTH OVERVIEW:\n   - All statuses with statistics: status=9, includeStats=true, pageSize=100\n   - Unhealthy monitors: Pass both status=2 AND status=3 (make 2 separate calls)\n\n4. ADVANCED FILTERING:\n   - Specific monitor types: app='mysql', status=1 (healthy MySQL monitors)\n   - Label-based: labels='env:prod,critical:true'\n   - Host search: search='192.168' (find by IP pattern)\n   - Monitor IDs: ids=[1,2,3] (specific monitors by ID)\n\n5. SORTING & PAGINATION:\n   - Recently updated: sort='gmtUpdate', order='desc'\n   - Alphabetical: sort='name', order='asc'\n   - By creation: sort='gmtCreate', order='desc' (newest first)\n   - Large datasets: pageSize=50-100 for bulk operations\n\nRESPONSE FORMAT:\n- includeStats=true: Adds status distribution summary at top\n- Default: Simple list with ID, name, type, host, status\n- Shows total count and pagination info\n")
    public String queryMonitors(@ToolParam(description="Specific monitor IDs to retrieve (optional)", required=false) List<Long> ids, @ToolParam(description="Monitor type filter: 'linux', 'mysql', 'http', 'redis', etc. (optional)", required=false) String app, @ToolParam(description="Monitor status: 1=online, 2=offline, 3=unreachable, 0=paused, 9=all (default: 9)", required=false) Byte status, @ToolParam(description="Search in monitor names or hosts (partial matching)", required=false) String search, @ToolParam(description="Label filters, format: 'key1:value1,key2:value2'", required=false) String labels, @ToolParam(description="Sort field: 'name', 'gmtCreate', 'gmtUpdate', 'status', 'app' (default: gmtCreate)", required=false) String sort, @ToolParam(description="Sort order: 'asc' (ascending) or 'desc' (descending, default)", required=false) String order, @ToolParam(description="Page number starting from 0 (default: 0)", required=false) Integer pageIndex, @ToolParam(description="Items per page: 1-100 recommended (default: 20)", required=false) Integer pageSize, @ToolParam(description="Include status statistics summary (default: false)", required=false) Boolean includeStats) {
        try {
            if (pageSize == null || pageSize <= 0) {
                pageSize = 20;
            }
            if (pageIndex == null) {
                pageIndex = 0;
            }
            if (includeStats == null) {
                includeStats = false;
            }
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current security subject: {}", (Object)subjectSum);
            Page result = this.monitorService.getMonitors(ids, app, search, status, sort, order, pageIndex.intValue(), pageSize.intValue(), labels);
            log.debug("MonitorService.getMonitors result: {}", (Object)result);
            StringBuilder response = new StringBuilder();
            response.append("MONITOR QUERY RESULTS\n");
            response.append("====================\n\n");
            if (includeStats.booleanValue()) {
                long onlineCount = this.monitorService.getMonitors(null, app, search, Byte.valueOf((byte)1), null, null, 0, 1000, labels).getTotalElements();
                long offlineCount = this.monitorService.getMonitors(null, app, search, Byte.valueOf((byte)2), null, null, 0, 1000, labels).getTotalElements();
                long unreachableCount = this.monitorService.getMonitors(null, app, search, Byte.valueOf((byte)3), null, null, 0, 1000, labels).getTotalElements();
                long pausedCount = this.monitorService.getMonitors(null, app, search, Byte.valueOf((byte)0), null, null, 0, 1000, labels).getTotalElements();
                response.append("STATUS OVERVIEW:\n");
                response.append("- Online: ").append(onlineCount).append("\n");
                response.append("- Offline: ").append(offlineCount).append("\n");
                response.append("- Unreachable: ").append(unreachableCount).append("\n");
                response.append("- Paused: ").append(pausedCount).append("\n");
                long total = onlineCount + offlineCount + unreachableCount + pausedCount;
                if (total > 0L) {
                    double healthPercentage = (double)onlineCount * 100.0 / (double)total;
                    response.append("- Health Rate: ").append(String.format("%.1f", healthPercentage)).append("%\n");
                }
                response.append("\n");
            }
            response.append("Query Results: ").append(result.getContent().size()).append(" monitors (Total: ").append(result.getTotalElements()).append(")\n");
            if (result.getTotalPages() > 1) {
                response.append("Page ").append(pageIndex + 1).append(" of ").append(result.getTotalPages()).append("\n");
            }
            response.append("\n");
            for (Monitor monitor : result.getContent()) {
                response.append("ID: ").append(monitor.getId()).append(" | Name: ").append(monitor.getName()).append(" | Type: ").append(monitor.getApp()).append(" | Instance: ").append(monitor.getInstance()).append(" | Status: ").append(UtilityClass.getStatusText(monitor.getStatus()));
                if (monitor.getGmtCreate() != null) {
                    response.append(" | Created: ").append(monitor.getGmtCreate().toString(), 0, 10);
                }
                response.append("\n");
            }
            if (result.getContent().isEmpty()) {
                response.append("No monitors found matching the specified criteria.\n");
                response.append("Try adjusting your filters or search terms.");
            }
            return response.toString();
        }
        catch (Exception e) {
            return "Error retrieving monitors: " + e.getMessage();
        }
    }

    @Override
    @Tool(name="add_monitor", description="HertzBeat: Add a new monitoring target to HertzBeat with comprehensive configuration.\nThis tool dynamically handles different parameter requirements for each monitor type.\n\nThis tool creates monitors with proper app-specific parameters.\n\n*********\nVERY IMPORTANT:\nALWAYS use get_monitor_additional_params to check the additional required parameters for the chosen type before adding a monitor or even mentioning it.\nUse list_monitor_types tool to see available monitor type names to use here in the app parameter.\nUse the information obtained from this to query user for parameters.\nIf the User has not given any parameters, ask them to provide the necessary parameters, until all the necessary parameters are provided.\n**********\n\nExamples of natural language requests this tool handles:\n- \"Monitor website example.com with HTTPS on port 443\"\n- \"Add MySQL monitoring for database server at 192.168.1.10 with user admin\"\n- \"Monitor Linux server health on host server.company.com via SSH\"\n- \"Set up Redis monitoring on localhost port 6379 with password\"\n\nPARAMETER MAPPING: Use the 'params' parameter to pass all monitor-specific configuration.\nThe params should be a JSON string containing key-value pairs for the monitor type.\nUse get_monitor_additional_params tool to see what parameters are required for each monitor type.\n\nPARAMS EXAMPLES:\n- Website: {\"host\":\"example.com\", \"port\":\"443\", \"uri\":\"/api/health\", \"ssl\":\"true\", \"method\":\"GET\"}\n- Linux: {\"host\":\"192.168.1.10\", \"port\":\"22\", \"username\":\"root\", \"password\":\"xxx\"}\n- MySQL: {\"host\":\"db.server.com\", \"port\":\"3306\", \"username\":\"admin\", \"password\":\"xxx\", \"database\":\"mydb\"}\n- Redis: {\"host\":\"redis.server.com\", \"port\":\"6379\", \"password\":\"xxx\"}\n")
    public String addMonitor(@ToolParam(description="Monitor name (required)", required=true) String name, @ToolParam(description="Monitor type: website, mysql, postgresql, redis, linux, windows, etc.", required=true) String app, @ToolParam(description="Collection interval in seconds (default: 600)", required=false) Integer intervals, @ToolParam(description="Monitor-specific parameters as JSON string. Use get_monitor_additional_params to see required fields. Example: {\"host\":\"192.168.1.1\", \"port\":\"22\", \"username\":\"root\"}", required=true) String params, @ToolParam(description="Monitor description (optional)", required=false) String description) {
        try {
            log.info("Adding monitor: name={}, app={}", (Object)name, (Object)app);
            if (name == null || name.trim().isEmpty()) {
                return "Error: Monitor name is required";
            }
            if (app == null || app.trim().isEmpty()) {
                return "Error: Monitor type/application is required";
            }
            if (params == null || params.trim().isEmpty()) {
                return "Error: Monitor params is required. Use get_monitor_additional_params to see required fields for this monitor type.";
            }
            if (intervals == null || intervals < 10) {
                intervals = 600;
            }
            List<Param> paramList = this.parseParams(params);
            String host = paramList.stream().filter(p -> "host".equals(p.getField())).map(Param::getParamValue).findFirst().orElse("");
            String port = paramList.stream().filter(p -> "port".equals(p.getField())).map(Param::getParamValue).findFirst().orElse(null);
            String instance = port != null && !port.isEmpty() ? host.trim() + ":" + port : host.trim();
            Monitor monitor = Monitor.builder().name(name.trim()).app(app.toLowerCase().trim()).instance(instance).intervals(intervals).status((byte)1).type((byte)0).description(description != null ? description.trim() : "").build();
            try {
                MonitorDto monitorDto = MonitorDto.builder().monitor(monitor).params(paramList).build();
                this.monitorService.validate(monitorDto, Boolean.valueOf(false));
            }
            catch (IllegalArgumentException argumentException) {
                if (argumentException.getMessage().contains("required")) {
                    return String.format("Error: %s. Or use get_monitor_additional_params tool to see all required parameters.", argumentException.getMessage());
                }
                return String.format("Error: %s. ", argumentException.getMessage());
            }
            this.monitorService.addMonitor(monitor, paramList, null, null);
            log.info("Successfully added monitor '{}' with ID: {}", (Object)monitor.getName(), (Object)monitor.getId());
            return String.format("Successfully added %s monitor '%s' with ID: %d (Instance: %s, Interval: %d seconds)", app.toUpperCase(), monitor.getName(), monitor.getId(), monitor.getInstance(), monitor.getIntervals());
        }
        catch (Exception e) {
            log.error("Failed to add monitor '{}': {}", new Object[]{name, e.getMessage(), e});
            return "Error adding monitor '" + name + "': " + e.getMessage();
        }
    }

    private List<Param> parseParams(String params) {
        ArrayList<Param> paramList = new ArrayList<Param>();
        if (params == null || params.trim().isEmpty()) {
            return paramList;
        }
        try {
            String cleaned = params.trim();
            if (cleaned.startsWith("{") && cleaned.endsWith("}")) {
                cleaned = cleaned.substring(1, cleaned.length() - 1);
            }
            List<String> pairs = this.splitJsonPairs(cleaned);
            for (String pair : pairs) {
                int colonIndex = pair.indexOf(58);
                if (colonIndex <= 0) continue;
                String key = pair.substring(0, colonIndex).trim().replaceAll("\"", "");
                String value = pair.substring(colonIndex + 1).trim().replaceAll("\"", "");
                byte paramType = this.determineParamType(key);
                paramList.add(Param.builder().field(key).paramValue(value).type(paramType).build());
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse params: {}", (Object)e.getMessage());
        }
        return paramList;
    }

    private List<String> splitJsonPairs(String json) {
        ArrayList<String> pairs = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        for (char c : json.toCharArray()) {
            if (c == '\"') {
                inQuotes = !inQuotes;
                current.append(c);
                continue;
            }
            if (c == ',' && !inQuotes) {
                if (current.length() <= 0) continue;
                pairs.add(current.toString().trim());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            pairs.add(current.toString().trim());
        }
        return pairs;
    }

    private byte determineParamType(String fieldName) {
        if ("password".equalsIgnoreCase(fieldName) || "privateKey".equalsIgnoreCase(fieldName)) {
            return 2;
        }
        if ("port".equalsIgnoreCase(fieldName) || "timeout".equalsIgnoreCase(fieldName)) {
            return 0;
        }
        return 1;
    }

    @Override
    @Tool(name="list_monitor_types", description="HertzBeat: List all available monitor types that can be added to HertzBeat.\nThis tool shows all supported monitor types with their display names.\nUse this to see what types of monitors you can create with the add_monitor tool.\n")
    public String listMonitorTypes(@ToolParam(description="Language code for localized names (en-US, zh-CN, etc.). Default: en-US", required=false) String language) {
        try {
            Map monitorTypes;
            log.info("Listing available monitor types for language: {}", (Object)language);
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current subject in list_monitor_types tool: {}", (Object)subjectSum);
            if (language == null || language.trim().isEmpty()) {
                language = "en-US";
            }
            if ((monitorTypes = this.appService.getI18nApps(language)) == null || monitorTypes.isEmpty()) {
                return "No monitor types are currently available.";
            }
            StringBuilder response = new StringBuilder();
            response.append("Available Monitor Types (Total: ").append(monitorTypes.size()).append("):\n\n");
            List sortedTypes = monitorTypes.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
            for (Map.Entry entry : sortedTypes) {
                String typeKey = (String)entry.getKey();
                String displayName = (String)entry.getValue();
                response.append("\u2022 ").append(typeKey).append(" - ").append(displayName).append("\n");
            }
            response.append("\nTo add a monitor, use the add_monitor tool with one of these types as the 'app' parameter.");
            log.info("Successfully listed {} monitor types", (Object)monitorTypes);
            return response.toString();
        }
        catch (Exception e) {
            log.error("Failed to list monitor types: {}", (Object)e.getMessage(), (Object)e);
            return "Error retrieving monitor types: " + e.getMessage();
        }
    }

    @Override
    @Tool(name="get_monitor_params", description="HertzBeat: Get the parameter definitions required for a specific monitor type.\nThis tool shows what parameters are needed when adding a monitor of the specified type,\nALWAYS use this before adding a monitor to understand what parameters the user needs to provide.\nUse the app parameter to specify the monitor type/application name (e.g., 'linux', 'mysql', 'redis') this can be obtained from the list_monitor_types tool.\n")
    public String getMonitorParams(@ToolParam(description="Monitor type/application name (e.g., 'linux', 'mysql', 'redis')", required=true) String app) {
        try {
            log.info("Getting parameter definitions for monitor type: {}", (Object)app);
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current subject in get_monitor_param_defines tool: {}", (Object)subjectSum);
            if (app == null || app.trim().isEmpty()) {
                return "Error: Monitor type/application parameter is required";
            }
            List paramDefines = this.appService.getAppParamDefines(app.toLowerCase().trim());
            if (paramDefines == null || paramDefines.isEmpty()) {
                return String.format("No parameter definitions found for monitor type '%s'. This monitor type may not exist or may not require additional parameters.", app);
            }
            StringBuilder response = new StringBuilder();
            response.append(String.format("Parameter Definitions for Monitor Type '%s' (Total: %d):\n\n", app, paramDefines.size()));
            for (ParamDefine paramDefine : paramDefines) {
                response.append("\u2022 Field: ").append(paramDefine.getField()).append("\n");
                if (paramDefine.getName() != null && !paramDefine.getName().toString().trim().isEmpty()) {
                    response.append("  Name: ").append(paramDefine.getName()).append("\n");
                }
                if (paramDefine.getType() != null && !paramDefine.getType().trim().isEmpty()) {
                    response.append("  Type: ").append(paramDefine.getType()).append("\n");
                }
                response.append("  Required: ").append(paramDefine.isRequired() ? "Yes" : "No").append("\n");
                if (paramDefine.getDefaultValue() != null && !paramDefine.getDefaultValue().trim().isEmpty()) {
                    response.append("  Default: ").append(paramDefine.getDefaultValue()).append("\n");
                }
                if (paramDefine.getRange() != null && !paramDefine.getRange().trim().isEmpty()) {
                    response.append("  Range: ").append(paramDefine.getRange()).append("\n");
                }
                if (paramDefine.getLimit() != null) {
                    response.append("  Limit: ").append(paramDefine.getLimit()).append("\n");
                }
                if (paramDefine.getPlaceholder() != null && !paramDefine.getPlaceholder().trim().isEmpty()) {
                    response.append("  Placeholder: ").append(paramDefine.getPlaceholder()).append("\n");
                }
                response.append("\n");
            }
            response.append("To add a monitor of this type, use the add_monitor tool with these parameters.\n");
            response.append(String.format("Example: add_monitor(name='my-monitor', app='%s', host='your-host', ...)", app));
            log.info("Successfully retrieved {} parameter definitions for monitor type: {}", (Object)paramDefines.size(), (Object)app);
            return response.toString();
        }
        catch (Exception e) {
            log.error("Failed to get parameter definitions for monitor type '{}': {}", new Object[]{app, e.getMessage(), e});
            return "Error retrieving parameter definitions for monitor type '" + app + "': " + e.getMessage();
        }
    }
}

