/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.code;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum IpmiSensorTypeCode implements IpmiCode.Code
{
    Reserved(0, "Reserved"),
    Temperature(1, "Temperature"),
    Voltage(2, "Voltage"),
    Current(3, "Current"),
    Fan(4, "Fan"),
    Physical_Security(5, "Physical Security"),
    Platform_Security(6, "Platform Security Violation Attempt"),
    Processor(7, "Processor"),
    Power_Supply(8, "Power Supply"),
    Power_Unit(9, "Power Unit"),
    Cooling_Device(10, "Cooling Device"),
    Other(11, "Other Units-based Sensor"),
    Memory(12, "Memory"),
    Drive_Slot_Bay(13, "Drive Slot"),
    POST_Memory_Resize(14, "POST Memory Resize"),
    System_Firmwares(15, "System Firmwares Progress"),
    Event_Logging_Disabled(16, "Event Logging Disabled"),
    Watchdog1(17, "Watchdog 1"),
    System_Event(18, "System Event"),
    Critical_Interrupt(19, "Critical Interrupt"),
    Button(20, "Button / Switch"),
    Module_Board(21, "Module / Board"),
    Microcontroller(22, "Microcontroller / Coprocessor"),
    Add_in_Card(23, "Add-in Card"),
    Chassis(24, "Chassis"),
    Chip_Set(25, "Chip Set"),
    Other_FRU(26, "Other FRU"),
    Cable_Interconnect(27, "Cable / Interconnect"),
    Terminator(28, "Terminator"),
    System_Boot_Initiated(29, "System Boot / Restart Initiated"),
    Boot_Error(30, "Boot Error"),
    OS_Boot(31, "Base OS Boot / Installation Status"),
    OS_Critical_Stop(32, "OS Stop / Shutdown"),
    Slot_Connector(33, "Slot / Connector"),
    System_ACPI_Power_State(34, "System ACPI Power State"),
    Watchdog2(35, "Watchdog 2"),
    Platform_Alert(36, "Platform Alert"),
    Entity_Presence(37, "Entity Presence"),
    Monitor_ASIC(38, "Monitor ASIC / IC"),
    LAN(39, "LAN"),
    Management_Subsystem_Health(40, "Management Subsystem Health"),
    Battery(41, "Battery"),
    Session_Audit(42, "Session Audit"),
    Version_Change(43, "Version Change"),
    FRU_State(44, "FRU State");

    private byte code;
    private String description;

    private IpmiSensorTypeCode(int code, String description) {
        this.code = ByteConvertUtils.checkCastByte(code);
        this.description = description;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

