/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.tsdb.questdb;

import com.google.common.collect.Maps;
import io.questdb.client.Sender;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.warehouse.store.history.tsdb.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.tsdb.questdb.QuestdbProperties;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="warehouse.store.questdb", name={"enabled"}, havingValue="true")
public class QuestdbDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(QuestdbDataStorage.class);
    private static final String QUERY_HISTORY_SQL = "SELECT timestamp AS ts, metric_labels, \"%s\" AS value FROM \"%s\" WHERE timestamp >= %s ORDER BY timestamp DESC";
    private static final String QUERY_HISTORY_SQL_WITH_INSTANCE = "SELECT timestamp AS ts, metric_labels, \"%s\" AS value FROM \"%s\" WHERE metric_labels = '%s' AND timestamp >= %s ORDER BY timestamp DESC";
    private static final String QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL = "SELECT timestamp AS ts, first(\"%s\") AS origin, avg(\"%s\") AS mean, max(\"%s\") AS max, min(\"%s\") AS min FROM \"%s\" WHERE metric_labels = '%s' AND timestamp >= %s SAMPLE BY 4h";
    private static final String QUERY_INSTANCE_SQL = "SELECT DISTINCT metric_labels FROM \"%s\"";
    private Sender sender;
    private OkHttpClient client;
    private String queryBaseUrl;
    private QuestdbProperties questdbProperties;

    public QuestdbDataStorage(QuestdbProperties questdbProperties) {
        this.questdbProperties = questdbProperties;
        this.initQuestDb(questdbProperties);
    }

    public void initQuestDb(QuestdbProperties questdbProperties) {
        String ilpAddress = questdbProperties.url();
        this.sender = Sender.builder((Sender.Transport)Sender.Transport.HTTP).address((CharSequence)ilpAddress).httpUsernamePassword(questdbProperties.username(), questdbProperties.password()).build();
        String[] parts = ilpAddress.split(":");
        String host = parts[0];
        String queryPort = "9000";
        this.queryBaseUrl = "http://" + host + ":" + queryPort + "/exec?query=";
        this.client = new OkHttpClient.Builder().readTimeout(6000L, TimeUnit.SECONDS).writeTimeout(6000L, TimeUnit.SECONDS).connectTimeout(6000L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(20, 30000L, TimeUnit.SECONDS)).sslSocketFactory(QuestdbDataStorage.defaultSslSocketFactory(), QuestdbDataStorage.defaultTrustManager()).hostnameVerifier(QuestdbDataStorage.noopHostnameVerifier()).retryOnConnectionFailure(true).build();
        this.serverAvailable = this.checkConnection();
    }

    private boolean checkConnection() {
        Map<String, Object> result = this.executeQuery("SELECT 1");
        return result != null && result.containsKey("dataset");
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        if (!this.isServerAvailable() || metricsData.getCode() != CollectRep.Code.SUCCESS || metricsData.getValues().isEmpty()) {
            return;
        }
        String table = this.generateTable(metricsData.getApp(), metricsData.getMetrics(), metricsData.getInstance());
        try {
            RowWrapper rowWrapper = metricsData.readRow();
            while (rowWrapper.hasNextRow()) {
                rowWrapper = rowWrapper.nextRow();
                try {
                    this.sender.table((CharSequence)table);
                    HashMap labels = Maps.newHashMapWithExpectedSize((int)8);
                    rowWrapper.cellStream().filter(cell -> cell.getMetadataAsBoolean("label")).forEach(cell -> labels.put(cell.getField().getName(), cell.getValue()));
                    if (!labels.isEmpty()) {
                        this.sender.symbol((CharSequence)"metric_labels", (CharSequence)JsonUtil.toJson((Object)labels));
                    } else {
                        this.sender.symbol((CharSequence)"metric_labels", (CharSequence)(metricsData.getApp() + "_" + metricsData.getMetrics()));
                    }
                    rowWrapper.cellStream().forEach(cell -> {
                        if ("&nbsp;".equals(cell.getValue())) {
                            return;
                        }
                        String fieldName = cell.getField().getName();
                        String fieldValue = cell.getValue();
                        Byte type = cell.getMetadataAsByte("type");
                        if (type == 0) {
                            this.sender.doubleColumn((CharSequence)fieldName, Double.parseDouble(fieldValue));
                        } else if (type == 1) {
                            this.sender.stringColumn((CharSequence)fieldName, (CharSequence)fieldValue);
                        }
                    });
                    this.sender.atNow();
                }
                catch (Exception e) {
                    log.error("[warehouse questdb]--Could not process a row, cancelling it. Error: {}", (Object)e.getMessage());
                    this.sender.cancelRow();
                }
            }
            this.sender.flush();
        }
        catch (Exception e) {
            log.error("[warehouse questdb]--Error during batch save: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public Map<String, List<Value>> getHistoryMetricData(String instance, String app, String metrics, String metric, String history) {
        String table = this.generateTable(app, metrics, instance);
        String dateAdd = this.getDateAdd(history);
        String selectSql = String.format(QUERY_HISTORY_SQL, metric, table, dateAdd);
        HashMap<String, List<Value>> instanceValueMap = new HashMap<String, List<Value>>(8);
        try {
            Map<String, Object> selectResult = this.executeQuery(selectSql);
            if (selectResult == null || !selectResult.containsKey("dataset")) {
                return instanceValueMap;
            }
            List columns = (List)selectResult.get("columns");
            List dataset = (List)selectResult.get("dataset");
            HashMap<String, Integer> colMap = new HashMap<String, Integer>();
            for (int i = 0; i < columns.size(); ++i) {
                colMap.put((String)((Map)columns.get(i)).get("name"), i);
            }
            int tsIdx = (Integer)colMap.get("ts");
            int metricLabelsIdx = (Integer)colMap.get("metric_labels");
            int valueIdx = (Integer)colMap.get("value");
            for (List row : dataset) {
                String strValue;
                String tsStr = (String)row.get(tsIdx);
                long time = Instant.parse(tsStr).toEpochMilli();
                String instanceValue = row.get(metricLabelsIdx) == null ? "" : (String)row.get(metricLabelsIdx);
                Object valObj = row.get(valueIdx);
                String string = strValue = valObj == null ? null : this.parseDoubleValue(valObj.toString());
                if (strValue == null) continue;
                List valueList = instanceValueMap.computeIfAbsent(instanceValue, k -> new LinkedList());
                valueList.add(new Value(strValue, time));
            }
        }
        catch (Exception e) {
            log.error("select history metric data in questdb error, sql:{}, msg: {}", (Object)selectSql, (Object)e.getMessage());
        }
        return instanceValueMap;
    }

    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(String instance, String app, String metrics, String metric, String history) {
        String table = this.generateTable(app, metrics, instance);
        String dateAdd = this.getDateAdd(history);
        HashMap<String, List<Value>> instanceValueMap = new HashMap<String, List<Value>>(8);
        HashSet<String> instances = new HashSet<String>(8);
        String queryInstanceSql = String.format(QUERY_INSTANCE_SQL, table);
        Map<String, Object> instanceQueryResult = this.executeQuery(queryInstanceSql);
        if (instanceQueryResult != null && instanceQueryResult.containsKey("dataset")) {
            List dataset = (List)instanceQueryResult.get("dataset");
            Iterator iterator = dataset.iterator();
            while (iterator.hasNext()) {
                List row = (List)iterator.next();
                if (row.isEmpty() || row.get(0) == null) continue;
                instances.add(row.get(0).toString());
            }
        }
        try {
            if (instances.isEmpty()) {
                instances.add("");
            }
            for (String instanceValue : instances) {
                String selectSql = String.format(QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL, metric, metric, metric, metric, table, instanceValue.replace("'", "\\'"), dateAdd);
                Map<String, Object> selectResult = this.executeQuery(selectSql);
                if (selectResult == null || !selectResult.containsKey("dataset")) continue;
                List columns = (List)selectResult.get("columns");
                List dataset = (List)selectResult.get("dataset");
                HashMap<String, Integer> colMap = new HashMap<String, Integer>();
                for (int i = 0; i < columns.size(); ++i) {
                    colMap.put((String)((Map)columns.get(i)).get("name"), i);
                }
                int tsIdx = (Integer)colMap.get("ts");
                int originIdx = (Integer)colMap.get("origin");
                int meanIdx = (Integer)colMap.get("mean");
                int maxIdx = (Integer)colMap.get("max");
                int minIdx = (Integer)colMap.get("min");
                for (List row : dataset) {
                    String tsStr = (String)row.get(tsIdx);
                    long time = Instant.parse(tsStr).toEpochMilli();
                    Value.ValueBuilder valueBuilder = Value.builder();
                    valueBuilder.time(Long.valueOf(time));
                    Object originObj = row.get(originIdx);
                    if (originObj == null) continue;
                    valueBuilder.origin(this.parseDoubleValue(originObj.toString()));
                    Object meanObj = row.get(meanIdx);
                    if (meanObj == null) continue;
                    valueBuilder.mean(this.parseDoubleValue(meanObj.toString()));
                    Object maxObj = row.get(maxIdx);
                    if (maxObj == null) continue;
                    valueBuilder.max(this.parseDoubleValue(maxObj.toString()));
                    Object minObj = row.get(minIdx);
                    if (minObj == null) continue;
                    valueBuilder.min(this.parseDoubleValue(minObj.toString()));
                    List valueList = instanceValueMap.computeIfAbsent(instanceValue, k -> new LinkedList());
                    valueList.add(valueBuilder.build());
                }
            }
        }
        catch (Exception e) {
            log.error("select history interval metric data in questdb error, msg: {}", (Object)e.getMessage());
        }
        return instanceValueMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> executeQuery(String sql) {
        try {
            String encodedSql = URLEncoder.encode(sql, StandardCharsets.UTF_8);
            String url = this.queryBaseUrl + encodedSql + "&timestamptype=rfc3339";
            String authHeader = "Basic " + Base64.getEncoder().encodeToString((this.questdbProperties.username() + ":" + this.questdbProperties.password()).getBytes(StandardCharsets.UTF_8));
            Request request = new Request.Builder().url(url).addHeader("Authorization", authHeader).get().build();
            try (Response response = this.client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    log.error("QuestDB query failed: {} - {}", (Object)response.code(), (Object)response.message());
                    Map<String, Object> map2 = null;
                    return map2;
                }
                String body = response.body().string();
                Map map = (Map)JsonUtil.fromJson((String)body, Map.class);
                return map;
            }
        }
        catch (Exception e) {
            log.error("Error executing QuestDB query: {} - {}", (Object)sql, (Object)e.getMessage());
            return null;
        }
    }

    private String getDateAdd(String history) {
        history = history.toLowerCase();
        char unitChar = history.charAt(history.length() - 1);
        int count = Integer.parseInt(history.substring(0, history.length() - 1));
        return String.format("dateadd('%s', %d, now())", switch (unitChar) {
            case 'd' -> "d";
            case 'h' -> "h";
            case 'm' -> "m";
            case 's' -> "s";
            default -> throw new IllegalArgumentException("Invalid history unit: " + unitChar);
        }, -count);
    }

    private String generateTable(String app, String metrics, String instance) {
        if (instance.contains(".") || instance.contains(":") || instance.contains("[")) {
            instance = instance.replace(".", "_").replace(":", "_").replace("[", "_").replace("]", "_");
        }
        return app + "_" + metrics + "_" + instance;
    }

    private String parseDoubleValue(String value) {
        return new BigDecimal(value).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }

    private static X509TrustManager defaultTrustManager() {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
    }

    private static SSLSocketFactory defaultSslSocketFactory() {
        try {
            SSLContext sslContext = SSLContexts.createDefault();
            sslContext.init(null, new TrustManager[]{QuestdbDataStorage.defaultTrustManager()}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static HostnameVerifier noopHostnameVerifier() {
        return (s, sslSession) -> true;
    }

    public void destroy() throws Exception {
        if (this.sender != null) {
            this.sender.close();
        }
        if (this.client != null) {
            this.client.dispatcher().executorService().shutdown();
        }
    }
}

