/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.pool;

import com.xugu.common.ReplaceEnum;
import com.xugu.pool.XgDataSource;
import com.xugu.pool.XgPooledConnection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class DBConnectionPoolDataSource
extends XgDataSource
implements ConnectionPoolDataSource,
Serializable {
    private boolean defaultAutoCommit = true;

    public String getDescription() {
        return "ConnectionPoolDataSource from " + ReplaceEnum.driverName.getReplaceStr() + " " + ReplaceEnum.driverVersion.getReplaceStr();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new XgPooledConnection(this.getConnection(), this.defaultAutoCommit);
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new XgPooledConnection(this.getConnection(user, password), this.defaultAutoCommit);
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeBaseObject(out);
        out.writeBoolean(this.defaultAutoCommit);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readBaseObject(in);
        this.defaultAutoCommit = in.readBoolean();
    }
}

