/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.geometric;

import com.xugu.cloudjdbc.Error;
import com.xugu.common.ReplaceEnum;
import com.xugu.geometric.DBpoint;
import com.xugu.util.DBBinaryObject;
import com.xugu.util.DBobject;
import com.xugu.util.DBtokenizer;
import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.NullnessUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DBbox
extends DBobject
implements DBBinaryObject,
Serializable,
Cloneable {
    public DBpoint @Nullable [] point;

    public DBbox(double x1, double y1, double x2, double y2) {
        this(new DBpoint(x1, y1), new DBpoint(x2, y2));
    }

    public DBbox(DBpoint p1, DBpoint p2) {
        this();
        this.point = new DBpoint[]{p1, p2};
    }

    public DBbox(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public DBbox() {
        this.type = "box";
    }

    @Override
    public void setValue(@Nullable String value) throws SQLException {
        if (value == null) {
            this.point = null;
            return;
        }
        DBtokenizer t = new DBtokenizer(value, ',');
        if (t.getSize() != 2) {
            throw Error.createSQLException("[E50044]Callable: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
        }
        DBpoint[] point = this.point;
        if (point == null) {
            this.point = point = new DBpoint[2];
        }
        point[0] = new DBpoint(t.getToken(0));
        point[1] = new DBpoint(t.getToken(1));
    }

    @Override
    public void setByteValue(byte[] b, int offset) {
        DBpoint[] point = this.point;
        if (point == null) {
            this.point = point = new DBpoint[2];
        }
        point[0] = new DBpoint();
        point[0].setByteValue(b, offset);
        point[1] = new DBpoint();
        point[1].setByteValue(b, offset + point[0].lengthInBytes());
        this.point = point;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof DBbox) {
            DBbox p = (DBbox)obj;
            DBpoint[] point = this.point;
            DBpoint[] pPoint = p.point;
            if (point == null) {
                return pPoint == null;
            }
            if (pPoint == null) {
                return false;
            }
            if (pPoint[0].equals(point[0]) && pPoint[1].equals(point[1])) {
                return true;
            }
            if (pPoint[0].equals(point[1]) && pPoint[1].equals(point[0])) {
                return true;
            }
            if (pPoint[0].x == point[0].x && pPoint[0].y == point[1].y && pPoint[1].x == point[1].x && pPoint[1].y == point[0].y) {
                return true;
            }
            if (pPoint[0].x == point[1].x && pPoint[0].y == point[0].y && pPoint[1].x == point[0].x && pPoint[1].y == point[1].y) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        DBpoint[] point = this.point;
        return point == null ? 0 : point[0].hashCode() ^ point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DBbox newDBbox = (DBbox)super.clone();
        if (newDBbox.point != null) {
            newDBbox.point = (DBpoint[])newDBbox.point.clone();
            for (int i = 0; i < newDBbox.point.length; ++i) {
                if (newDBbox.point[i] == null) continue;
                newDBbox.point[i] = (DBpoint)newDBbox.point[i].clone();
            }
        }
        return newDBbox;
    }

    @Override
    public @Nullable String getValue() {
        DBpoint[] point = this.point;
        return point == null ? null : point[0].toString() + "," + point[1].toString();
    }

    @Override
    public int lengthInBytes() {
        DBpoint[] point = this.point;
        if (point == null) {
            return 0;
        }
        return point[0].lengthInBytes() + point[1].lengthInBytes();
    }

    @Override
    public void toBytes(byte[] bytes, int offset) {
        DBpoint[] point = (DBpoint[])NullnessUtil.castNonNull((Object)this.point);
        point[0].toBytes(bytes, offset);
        point[1].toBytes(bytes, offset + point[0].lengthInBytes());
    }
}

