/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hertzbeat.alert.expr.AlertExpressionBaseVisitor;
import org.apache.hertzbeat.alert.expr.AlertExpressionParser;
import org.apache.hertzbeat.common.support.exception.ExpressionVisitorException;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;

public class AlertExpressionEvalVisitor
extends AlertExpressionBaseVisitor<List<Map<String, Object>>> {
    private static final String SCALAR = "__scalar__";
    private static final String NAME = "__name__";
    private static final String VALUE = "__value__";
    private static final String TIMESTAMP = "__timestamp__";
    private final QueryExecutor executor;
    private final CommonTokenStream tokens;

    public AlertExpressionEvalVisitor(QueryExecutor executor, CommonTokenStream tokens) {
        this.executor = executor;
        this.tokens = tokens;
    }

    @Override
    public List<Map<String, Object>> visitExpression(AlertExpressionParser.ExpressionContext ctx) {
        return (List)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public List<Map<String, Object>> visitParenExpr(AlertExpressionParser.ParenExprContext ctx) {
        return (List)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public List<Map<String, Object>> visitComparisonExpr(AlertExpressionParser.ComparisonExprContext ctx) {
        List leftResult = (List)this.visit((ParseTree)ctx.left);
        List rightResult = (List)this.visit((ParseTree)ctx.right);
        int type = ctx.op.getType();
        boolean boolModifier = ctx.BOOL() != null;
        boolean leftIsScalar = this.isScalar(leftResult);
        boolean rightIsScalar = this.isScalar(rightResult);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (leftIsScalar && rightIsScalar) {
            if (!boolModifier) {
                return results;
            }
            Object leftVal = ((Map)leftResult.get(0)).get(SCALAR);
            Object rightVal = ((Map)rightResult.get(0)).get(SCALAR);
            Boolean match = this.compareOp(leftVal, type, rightVal);
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put(VALUE, match != false ? 1 : 0);
            results.add(result);
            return results;
        }
        if (leftIsScalar) {
            Object leftVal = ((Map)leftResult.get(0)).get(SCALAR);
            for (Map rightItem : rightResult) {
                Object rightVal = rightItem.getOrDefault(VALUE, null);
                if (this.isValidValue(rightVal)) continue;
                Boolean match = this.compareOp(leftVal, type, rightVal);
                HashMap<String, Integer> result = new HashMap<String, Integer>(rightItem);
                if (boolModifier) {
                    result.put(VALUE, match != false ? 1 : 0);
                    results.add(result);
                    continue;
                }
                result.put(VALUE, (Integer)(match != false ? rightVal : null));
                results.add(result);
            }
            return results;
        }
        if (rightIsScalar) {
            Object rightVal = ((Map)rightResult.get(0)).get(SCALAR);
            for (Map leftItem : leftResult) {
                Object leftVal = leftItem.getOrDefault(VALUE, null);
                if (this.isValidValue(leftVal)) continue;
                Boolean match = this.compareOp(leftVal, type, rightVal);
                HashMap<String, Integer> result = new HashMap<String, Integer>(leftItem);
                if (boolModifier) {
                    result.put(VALUE, match != false ? 1 : 0);
                    results.add(result);
                    continue;
                }
                result.put(VALUE, (Integer)(match != false ? leftVal : null));
                results.add(result);
            }
            return results;
        }
        Map<String, Map> rightMap = rightResult.stream().filter(item -> item.get(VALUE) != null).collect(Collectors.toMap(this::labelKey, item -> item, (existing, replacement) -> existing));
        for (Map leftItem : leftResult) {
            Object rightVal;
            Map rightItem;
            Object leftVal = leftItem.getOrDefault(VALUE, null);
            if (this.isValidValue(leftVal) || (rightItem = rightMap.get(this.labelKey(leftItem))) == null || this.isValidValue(rightVal = rightItem.get(VALUE))) continue;
            Boolean match = this.compareOp(leftVal, type, rightVal);
            HashMap<String, Integer> result = new HashMap<String, Integer>(leftItem);
            if (boolModifier) {
                result.put(VALUE, match != false ? 1 : 0);
                results.add(result);
                continue;
            }
            result.put(VALUE, (Integer)(match != false ? leftVal : null));
            results.add(result);
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> visitAndExpr(AlertExpressionParser.AndExprContext ctx) {
        List leftOperand = (List)this.visit((ParseTree)ctx.left);
        List rightOperand = (List)this.visit((ParseTree)ctx.right);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Set rightLabelsSet = rightOperand.stream().filter(item -> item.get(VALUE) != null).map(this::labelKey).collect(Collectors.toSet());
        for (Map leftItem : leftOperand) {
            String labelKey;
            Object leftVal = leftItem.get(VALUE);
            if (leftVal == null || !rightLabelsSet.contains(labelKey = this.labelKey(leftItem))) continue;
            results.add(new HashMap(leftItem));
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> visitOrExpr(AlertExpressionParser.OrExprContext ctx) {
        List leftOperand = (List)this.visit((ParseTree)ctx.left);
        List rightOperand = (List)this.visit((ParseTree)ctx.right);
        Map<String, Map> leftLabelMap = leftOperand.stream().filter(item -> item.get(VALUE) != null).collect(Collectors.toMap(this::labelKey, HashMap::new, (k1, k2) -> k1));
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(leftLabelMap.values());
        for (Map rightItem : rightOperand) {
            String key;
            Object rightVal = rightItem.get(VALUE);
            if (rightVal == null || leftLabelMap.containsKey(key = this.labelKey(rightItem))) continue;
            results.add(new HashMap(rightItem));
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> visitUnlessExpr(AlertExpressionParser.UnlessExprContext ctx) {
        List leftOperand = (List)this.visit((ParseTree)ctx.left);
        List rightOperand = (List)this.visit((ParseTree)ctx.right);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Set rightLabelSet = rightOperand.stream().filter(item -> item.get(VALUE) != null).map(this::labelKey).collect(Collectors.toSet());
        for (Map leftItem : leftOperand) {
            Object leftVal = leftItem.get(VALUE);
            if (leftVal == null || rightLabelSet.contains(this.labelKey(leftItem))) continue;
            results.add(new HashMap(leftItem));
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> visitLiteralExpr(AlertExpressionParser.LiteralExprContext ctx) {
        double value = Double.parseDouble(ctx.number().getText());
        ArrayList<Map<String, Object>> numAsList = new ArrayList<Map<String, Object>>();
        HashMap<String, Double> valueMap = new HashMap<String, Double>();
        valueMap.put(SCALAR, value);
        numAsList.add(valueMap);
        return numAsList;
    }

    @Override
    public List<Map<String, Object>> visitPromqlExpr(AlertExpressionParser.PromqlExprContext ctx) {
        String rawPromql = this.tokens.getText((RuleContext)ctx.promql());
        return this.executor.execute(rawPromql);
    }

    @Override
    public List<Map<String, Object>> visitSqlExpr(AlertExpressionParser.SqlExprContext ctx) {
        String rawSql = this.tokens.getText((RuleContext)ctx.selectSql());
        return this.executor.execute(rawSql);
    }

    @Override
    public List<Map<String, Object>> visitSqlCallExpr(AlertExpressionParser.SqlCallExprContext ctx) {
        return this.callSqlOrPromql(this.tokens.getText((RuleContext)ctx.string()));
    }

    @Override
    public List<Map<String, Object>> visitPromqlCallExpr(AlertExpressionParser.PromqlCallExprContext ctx) {
        return this.callSqlOrPromql(this.tokens.getText((RuleContext)ctx.string()));
    }

    private List<Map<String, Object>> callSqlOrPromql(String text) {
        String script = text.substring(1, text.length() - 1);
        return this.executor.execute(script);
    }

    private String labelKey(Map<String, Object> labelsMap) {
        if (null == labelsMap || labelsMap.isEmpty()) {
            return "-";
        }
        String key = labelsMap.entrySet().stream().filter(e -> !((String)e.getKey()).equals(VALUE) && !((String)e.getKey()).equals(NAME) && !((String)e.getKey()).equals(TIMESTAMP)).sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + (e.getValue() == null ? "" : e.getValue())).collect(Collectors.joining(","));
        return key.isEmpty() ? "-" : key;
    }

    private boolean isScalar(List<Map<String, Object>> context) {
        return CollectionUtils.isNotEmpty(context) && context.size() == 1 && context.get(0).containsKey(SCALAR) && null != context.get(0).get(SCALAR);
    }

    private double parseStrToDouble(String text) {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            throw new ExpressionVisitorException("number format exception", (Throwable)e);
        }
    }

    private boolean isValidValue(Object val) {
        return val == null || val instanceof List;
    }

    private Boolean compareOp(Object leftVal, int opType, Object rightVal) {
        double left = this.parseStrToDouble(leftVal.toString());
        double right = this.parseStrToDouble(rightVal.toString());
        return switch (opType) {
            case 45 -> left > right;
            case 46 -> left >= right;
            case 47 -> left < right;
            case 48 -> left <= right;
            case 49 -> left == right;
            case 50 -> left != right;
            default -> false;
        };
    }
}

