/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagBuilder;

class TagBuilderImpl
implements TagBuilder {
    private byte tagType = (byte)-1;
    private byte[] tagBytes = null;
    public static final String TAG_TYPE_NOT_SET_EXCEPTION = "Need to set type of the tag.";
    public static final String TAG_VALUE_NULL_EXCEPTION = "TagBytes can't be null";

    TagBuilderImpl() {
    }

    @Override
    public TagBuilder setTagType(byte tagType) {
        this.tagType = tagType;
        return this;
    }

    @Override
    public TagBuilder setTagValue(byte[] tagBytes) {
        this.tagBytes = tagBytes;
        return this;
    }

    private void validate() {
        if (this.tagType == -1) {
            throw new IllegalArgumentException(TAG_TYPE_NOT_SET_EXCEPTION);
        }
        if (this.tagBytes == null) {
            throw new IllegalArgumentException(TAG_VALUE_NULL_EXCEPTION);
        }
    }

    @Override
    public Tag build() {
        this.validate();
        return new ArrayBackedTag(this.tagType, this.tagBytes);
    }
}

