/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.addRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.codec.decorators.AddRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AddResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAddRequestAttributeType
extends GrammarAction<LdapMessageContainer<AddRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddAddRequestAttributeType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddAddRequestAttributeType() {
        super("Store attribute type");
    }

    public void action(LdapMessageContainer<AddRequestDecorator> container) throws DecoderException {
        AddRequestDecorator addRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04086, (Object[])new Object[0]);
            LOG.error(msg);
            AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, addRequest.getEntry().getDn(), null);
        }
        String type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        try {
            addRequest.addAttributeType(type);
        }
        catch (LdapException ne) {
            String msg = I18n.err((I18n)I18n.ERR_04087, (Object[])new Object[0]);
            LOG.error(msg);
            AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, addRequest.getEntry().getDn(), ne);
        }
        if (IS_DEBUG) {
            LOG.debug("Adding type {}", (Object)type);
        }
    }
}

