/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.DumpClusterStatusAction;
import org.apache.hadoop.hbase.chaos.actions.DumpHdfsClusterStatusAction;
import org.apache.hadoop.hbase.chaos.actions.ForceBalancerAction;
import org.apache.hadoop.hbase.chaos.actions.GracefulRollingRestartRsAction;
import org.apache.hadoop.hbase.chaos.actions.RestartActiveMasterAction;
import org.apache.hadoop.hbase.chaos.actions.RestartActiveNameNodeAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomDataNodeAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomJournalNodeAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomRsExceptMetaAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomZKNodeAction;
import org.apache.hadoop.hbase.chaos.actions.RollingBatchRestartRsAction;
import org.apache.hadoop.hbase.chaos.actions.RollingBatchSuspendResumeRsAction;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.CompositeSequentialPolicy;
import org.apache.hadoop.hbase.chaos.policies.DoActionsOncePolicy;
import org.apache.hadoop.hbase.chaos.policies.PeriodicRandomActionPolicy;

public class ServerAndDependenciesKillingMonkeyFactory
extends MonkeyFactory {
    private long gracefulRollingRestartTSSLeepTime;
    private long rollingBatchSuspendRSSleepTime;
    private float rollingBatchSuspendtRSRatio;

    @Override
    public ChaosMonkey build() {
        this.loadProperties();
        Action[] actions1 = new Action[]{new RestartRandomRsExceptMetaAction(60000L), new RestartActiveMasterAction(5000L), new RollingBatchRestartRsAction(5000L, 1.0f, 2, true), new ForceBalancerAction(), new RestartActiveNameNodeAction(60000L), new RestartRandomDataNodeAction(60000L), new RestartRandomJournalNodeAction(60000L), new RestartRandomZKNodeAction(60000L), new GracefulRollingRestartRsAction(this.gracefulRollingRestartTSSLeepTime), new RollingBatchSuspendResumeRsAction(this.rollingBatchSuspendRSSleepTime, this.rollingBatchSuspendtRSRatio)};
        Action[] actions2 = new Action[]{new DumpClusterStatusAction(), new DumpHdfsClusterStatusAction()};
        return new PolicyBasedChaosMonkey(this.properties, this.util, new CompositeSequentialPolicy(new DoActionsOncePolicy(60000L, actions1), new PeriodicRandomActionPolicy(60000L, actions1)), new PeriodicRandomActionPolicy(60000L, actions2));
    }

    private void loadProperties() {
        this.gracefulRollingRestartTSSLeepTime = Long.parseLong(this.properties.getProperty("graceful.restart.rs.sleep.time", "5000"));
        this.rollingBatchSuspendRSSleepTime = Long.parseLong(this.properties.getProperty("rolling.batch.suspend.rs.sleep.time", "30000"));
        this.rollingBatchSuspendtRSRatio = Float.parseFloat(this.properties.getProperty("rolling.batch.suspend.rs.ratio", "1.0"));
    }
}

