/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.multiverse.api.BackoffPolicy;
import org.multiverse.api.IsolationLevel;
import org.multiverse.api.LockMode;
import org.multiverse.api.PropagationLevel;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.TxnConfig;
import org.multiverse.api.exceptions.IllegalTxnFactoryException;
import org.multiverse.api.lifecycle.TxnListener;
import org.multiverse.stms.gamma.GammaConstants;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.GammaStmConfig;
import org.multiverse.stms.gamma.GlobalConflictCounter;
import org.multiverse.stms.gamma.transactions.SpeculativeGammaConfiguration;

public final class GammaTxnConfig
implements TxnConfig,
GammaConstants {
    public static final AtomicLong idGenerator = new AtomicLong();
    public final AtomicReference<SpeculativeGammaConfiguration> speculativeConfiguration = new AtomicReference();
    public final GammaStm stm;
    public final GlobalConflictCounter globalConflictCounter;
    public PropagationLevel propagationLevel;
    public IsolationLevel isolationLevel;
    public boolean writeSkewAllowed;
    public boolean inconsistentReadAllowed;
    public LockMode readLockMode;
    public LockMode writeLockMode;
    public int readLockModeAsInt;
    public int writeLockModeAsInt;
    public String familyName;
    public boolean isAnonymous;
    public boolean interruptible;
    public boolean readonly;
    public int spinCount;
    public boolean dirtyCheck;
    public int minimalArrayTreeSize;
    public boolean trackReads;
    public boolean blockingAllowed;
    public int maxRetries;
    public boolean speculative;
    public int maxFixedLengthTransactionSize;
    public BackoffPolicy backoffPolicy;
    public long timeoutNs;
    public TraceLevel traceLevel;
    public boolean controlFlowErrorsReused;
    public boolean isFat;
    public int maximumPoorMansConflictScanLength;
    public ArrayList<TxnListener> permanentListeners;
    public boolean unrepeatableReadAllowed;

    public GammaTxnConfig(GammaStm stm) {
        this(stm, new GammaStmConfig());
    }

    public GammaTxnConfig(GammaStm stm, GammaStmConfig config) {
        this.stm = stm;
        this.globalConflictCounter = stm.getGlobalConflictCounter();
        this.interruptible = config.interruptible;
        this.readonly = config.readonly;
        this.spinCount = config.spinCount;
        this.readLockMode = config.readLockMode;
        this.readLockModeAsInt = config.readLockMode.asInt();
        this.writeLockMode = config.writeLockMode;
        this.writeLockModeAsInt = config.writeLockMode.asInt();
        this.dirtyCheck = config.dirtyCheck;
        this.minimalArrayTreeSize = config.minimalVariableLengthTransactionSize;
        this.trackReads = config.trackReads;
        this.blockingAllowed = config.blockingAllowed;
        this.maxRetries = config.maxRetries;
        this.speculative = config.speculativeConfigEnabled;
        this.maxFixedLengthTransactionSize = config.maxFixedLengthTransactionSize;
        this.backoffPolicy = config.backoffPolicy;
        this.timeoutNs = config.timeoutNs;
        this.traceLevel = config.traceLevel;
        this.isolationLevel = config.isolationLevel;
        this.writeSkewAllowed = this.isolationLevel.doesAllowWriteSkew();
        this.inconsistentReadAllowed = this.isolationLevel.doesAllowInconsistentRead();
        this.unrepeatableReadAllowed = this.isolationLevel.doesAllowUnrepeatableRead();
        this.propagationLevel = config.propagationLevel;
        this.controlFlowErrorsReused = config.controlFlowErrorsReused;
        this.familyName = "anonymoustransaction-" + idGenerator.incrementAndGet();
        this.isAnonymous = true;
        this.maximumPoorMansConflictScanLength = config.maximumPoorMansConflictScanLength;
        this.isFat = config.isFat;
        this.permanentListeners = config.permanentListeners.isEmpty() ? null : new ArrayList<TxnListener>(config.permanentListeners);
    }

    private GammaTxnConfig(GammaTxnConfig config) {
        this.stm = config.stm;
        this.globalConflictCounter = config.globalConflictCounter;
        this.propagationLevel = config.propagationLevel;
        this.isolationLevel = config.isolationLevel;
        this.writeSkewAllowed = config.writeSkewAllowed;
        this.inconsistentReadAllowed = config.inconsistentReadAllowed;
        this.readLockMode = config.readLockMode;
        this.readLockModeAsInt = config.readLockModeAsInt;
        this.writeLockMode = config.writeLockMode;
        this.writeLockModeAsInt = config.writeLockModeAsInt;
        this.familyName = config.familyName;
        this.isAnonymous = config.isAnonymous;
        this.interruptible = config.interruptible;
        this.readonly = config.readonly;
        this.spinCount = config.spinCount;
        this.dirtyCheck = config.dirtyCheck;
        this.minimalArrayTreeSize = config.minimalArrayTreeSize;
        this.trackReads = config.trackReads;
        this.blockingAllowed = config.blockingAllowed;
        this.maxRetries = config.maxRetries;
        this.speculative = config.speculative;
        this.maxFixedLengthTransactionSize = config.maxFixedLengthTransactionSize;
        this.backoffPolicy = config.backoffPolicy;
        this.timeoutNs = config.timeoutNs;
        this.traceLevel = config.traceLevel;
        this.controlFlowErrorsReused = config.controlFlowErrorsReused;
        this.isFat = config.isFat;
        this.maximumPoorMansConflictScanLength = config.maximumPoorMansConflictScanLength;
        this.permanentListeners = config.permanentListeners;
    }

    public GammaTxnConfig(GammaStm stm, int maxFixedLengthTransactionSize) {
        this(stm);
        this.maxFixedLengthTransactionSize = maxFixedLengthTransactionSize;
    }

    @Override
    public LockMode getReadLockMode() {
        return this.readLockMode;
    }

    @Override
    public LockMode getWriteLockMode() {
        return this.writeLockMode;
    }

    @Override
    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public boolean isControlFlowErrorsReused() {
        return this.controlFlowErrorsReused;
    }

    public SpeculativeGammaConfiguration getSpeculativeConfiguration() {
        return this.speculativeConfiguration.get();
    }

    @Override
    public long getTimeoutNs() {
        return this.timeoutNs;
    }

    @Override
    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public boolean isInterruptible() {
        return this.interruptible;
    }

    @Override
    public BackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    @Override
    public boolean isSpeculative() {
        return this.speculative;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public int getSpinCount() {
        return this.spinCount;
    }

    @Override
    public boolean isDirtyCheckEnabled() {
        return this.dirtyCheck;
    }

    @Override
    public GammaStm getStm() {
        return this.stm;
    }

    public GlobalConflictCounter getGlobalConflictCounter() {
        return this.globalConflictCounter;
    }

    @Override
    public boolean isReadTrackingEnabled() {
        return this.trackReads;
    }

    @Override
    public boolean isBlockingAllowed() {
        return this.blockingAllowed;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public PropagationLevel getPropagationLevel() {
        return this.propagationLevel;
    }

    @Override
    public List<TxnListener> getPermanentListeners() {
        if (this.permanentListeners == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.permanentListeners);
    }

    public void updateSpeculativeConfigurationToUseNonRefType() {
        SpeculativeGammaConfiguration update;
        SpeculativeGammaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), update = current.newWithNonRefType())) {
        }
    }

    public void updateSpeculativeConfigurationToUseListeners() {
        SpeculativeGammaConfiguration update;
        SpeculativeGammaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), update = current.newWithListeners())) {
        }
    }

    public void updateSpeculativeConfigureToUseAbortOnly() {
        SpeculativeGammaConfiguration update;
        SpeculativeGammaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), update = current.newWithAbortOnly())) {
        }
    }

    public void updateSpeculativeConfigurationToUseCommute() {
        SpeculativeGammaConfiguration update;
        SpeculativeGammaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), update = current.newWithCommute())) {
        }
    }

    public void updateSpeculativeConfigurationToUseExplicitLocking() {
        SpeculativeGammaConfiguration update;
        SpeculativeGammaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), update = current.newWithLocks())) {
        }
    }

    public void updateSpeculativeConfigurationToUseConstructedObjects() {
        SpeculativeGammaConfiguration next;
        SpeculativeGammaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), next = current.newWithConstructedObjects())) {
        }
    }

    public void updateSpeculativeConfigurationToUseRichMansConflictScan() {
        SpeculativeGammaConfiguration next;
        SpeculativeGammaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), next = current.newWithRichMansConflictScan())) {
        }
    }

    public void updateSpeculativeConfigurationToUseMinimalTransactionLength(int newLength) {
        SpeculativeGammaConfiguration next;
        SpeculativeGammaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), next = current.newWithMinimalLength(newLength))) {
        }
    }

    public void updateSpeculativeConfigurationToUseEnsure() {
        SpeculativeGammaConfiguration next;
        SpeculativeGammaConfiguration current;
        while (!this.speculativeConfiguration.compareAndSet(current = this.speculativeConfiguration.get(), next = current.newWithEnsure())) {
        }
    }

    public GammaTxnConfig init() {
        if (!(this.writeSkewAllowed || this.trackReads || this.readonly)) {
            String msg = String.format("'[%s] If no writeskew is allowed, read tracking should be enabled", this.familyName);
            throw new IllegalTxnFactoryException(msg);
        }
        if (this.blockingAllowed && !this.trackReads) {
            String msg = String.format("[%s] If blocking is allowed, read tracking should be enabled", this.familyName);
            throw new IllegalTxnFactoryException(msg);
        }
        if (this.readLockModeAsInt > this.writeLockModeAsInt) {
            String msg = String.format("[%s] The used write LockMode [%s] should be equal or higher than the read LockMode [%s]", this.familyName, this.readLockMode, this.writeLockMode);
            throw new IllegalTxnFactoryException(msg);
        }
        if (this.readLockMode != LockMode.None && !this.trackReads) {
            String msg = String.format("[%s] If readLockMode is [%s] , read tracking should be enabled", this.familyName, this.readLockMode);
            throw new IllegalTxnFactoryException(msg);
        }
        if (this.speculativeConfiguration.get() == null) {
            SpeculativeGammaConfiguration newSpeculativeConfiguration = this.speculative ? new SpeculativeGammaConfiguration(this.isFat(), false, false, false, false, false, false, false, false, false, 1) : new SpeculativeGammaConfiguration(true, true, true, true, true, true, true, true, true, true, Integer.MAX_VALUE);
            if (this.maximumPoorMansConflictScanLength == 0) {
                newSpeculativeConfiguration = newSpeculativeConfiguration.newWithRichMansConflictScan();
            }
            this.speculativeConfiguration.compareAndSet(null, newSpeculativeConfiguration);
        }
        return this;
    }

    private boolean isFat() {
        if (this.isFat) {
            return true;
        }
        if (this.isolationLevel != IsolationLevel.Snapshot) {
            return true;
        }
        if (this.permanentListeners != null) {
            return true;
        }
        if (this.readLockMode != LockMode.None) {
            return true;
        }
        if (this.writeLockMode != LockMode.None) {
            return true;
        }
        if (this.dirtyCheck) {
            return true;
        }
        return this.readonly;
    }

    public GammaTxnConfig setTimeoutNs(long timeoutNs) {
        if (timeoutNs < 0L) {
            throw new IllegalArgumentException("timeoutNs can't be smaller than 0");
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.timeoutNs = timeoutNs;
        return config;
    }

    public GammaTxnConfig setFamilyName(String familyName) {
        if (familyName == null) {
            throw new NullPointerException("familyName can't be null");
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.isAnonymous = false;
        config.familyName = familyName;
        return config;
    }

    public GammaTxnConfig setMaxRetries(int maxRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries can't be smaller than 0");
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.maxRetries = maxRetries;
        return config;
    }

    public GammaTxnConfig setMaximumPoorMansConflictScanLength(int maximumPoorMansConflictScanLength) {
        if (maximumPoorMansConflictScanLength < 0) {
            throw new IllegalStateException();
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.maximumPoorMansConflictScanLength = maximumPoorMansConflictScanLength;
        return config;
    }

    public GammaTxnConfig setReadTrackingEnabled(boolean trackReads) {
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.trackReads = trackReads;
        return config;
    }

    public GammaTxnConfig setSpeculative(boolean speculativeConfigEnabled) {
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.speculative = speculativeConfigEnabled;
        return config;
    }

    public GammaTxnConfig setReadonly(boolean readonly) {
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.readonly = readonly;
        return config;
    }

    public GammaTxnConfig setDirtyCheckEnabled(boolean dirtyCheck) {
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.dirtyCheck = dirtyCheck;
        return config;
    }

    public GammaTxnConfig setBlockingAllowed(boolean blockingAllowed) {
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.blockingAllowed = blockingAllowed;
        return config;
    }

    public GammaTxnConfig setInterruptible(boolean interruptible) {
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.interruptible = interruptible;
        return config;
    }

    public GammaTxnConfig setControlFlowErrorsReused(boolean controlFlowErrorsReused) {
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.controlFlowErrorsReused = controlFlowErrorsReused;
        return config;
    }

    public GammaTxnConfig setSpinCount(int spinCount) {
        if (spinCount < 0) {
            throw new IllegalArgumentException("spinCount can't be smaller than 0");
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.spinCount = spinCount;
        return config;
    }

    public GammaTxnConfig setBackoffPolicy(BackoffPolicy backoffPolicy) {
        if (backoffPolicy == null) {
            throw new NullPointerException("backoffPolicy can't be null");
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.backoffPolicy = backoffPolicy;
        return config;
    }

    public GammaTxnConfig setTraceLevel(TraceLevel traceLevel) {
        if (traceLevel == null) {
            throw new NullPointerException("traceLevel can't be null");
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.traceLevel = traceLevel;
        return config;
    }

    public GammaTxnConfig setPropagationLevel(PropagationLevel propagationLevel) {
        if (propagationLevel == null) {
            throw new NullPointerException();
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.propagationLevel = propagationLevel;
        return config;
    }

    public GammaTxnConfig setIsolationLevel(IsolationLevel isolationLevel) {
        if (isolationLevel == null) {
            throw new NullPointerException();
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.isolationLevel = isolationLevel;
        config.writeSkewAllowed = isolationLevel.doesAllowWriteSkew();
        config.inconsistentReadAllowed = isolationLevel.doesAllowInconsistentRead();
        config.unrepeatableReadAllowed = isolationLevel.doesAllowUnrepeatableRead();
        return config;
    }

    public GammaTxnConfig setWriteLockMode(LockMode writeLockMode) {
        if (writeLockMode == null) {
            throw new NullPointerException();
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.writeLockMode = writeLockMode;
        config.writeLockModeAsInt = writeLockMode.asInt();
        return config;
    }

    public GammaTxnConfig setReadLockMode(LockMode readLockMode) {
        if (readLockMode == null) {
            throw new NullPointerException();
        }
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.readLockMode = readLockMode;
        config.readLockModeAsInt = readLockMode.asInt();
        if (config.readLockModeAsInt > config.writeLockModeAsInt) {
            config.writeLockMode = config.readLockMode;
            config.writeLockModeAsInt = config.readLockModeAsInt;
        }
        return config;
    }

    public GammaTxnConfig setFat() {
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.isFat = true;
        return config;
    }

    public GammaTxnConfig addPermanentListener(TxnListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ArrayList<TxnListener> newPermanentListeners = new ArrayList<TxnListener>();
        if (this.permanentListeners != null) {
            newPermanentListeners.addAll(this.permanentListeners);
        }
        newPermanentListeners.add(listener);
        GammaTxnConfig config = new GammaTxnConfig(this);
        config.permanentListeners = newPermanentListeners;
        return config;
    }

    public String toString() {
        return "GammaTxnConfig{speculativeConfiguration=" + this.speculativeConfiguration + ", globalConflictCounter=" + this.globalConflictCounter + ", propagationLevel=" + (Object)((Object)this.propagationLevel) + ", isolationLevel=" + (Object)((Object)this.isolationLevel) + ", writeSkewAllowed=" + this.writeSkewAllowed + ", inconsistentReadAllowed=" + this.inconsistentReadAllowed + ", readLockMode=" + this.readLockMode + ", writeLockMode=" + this.writeLockMode + ", readLockModeAsInt=" + this.readLockModeAsInt + ", writeLockModeAsInt=" + this.writeLockModeAsInt + ", familyName='" + this.familyName + '\'' + ", isAnonymous=" + this.isAnonymous + ", interruptible=" + this.interruptible + ", readonly=" + this.readonly + ", spinCount=" + this.spinCount + ", dirtyCheck=" + this.dirtyCheck + ", minimalArrayTreeSize=" + this.minimalArrayTreeSize + ", trackReads=" + this.trackReads + ", blockingAllowed=" + this.blockingAllowed + ", maxRetries=" + this.maxRetries + ", speculativeConfigEnabled=" + this.speculative + ", maxFixedLengthTransactionSize=" + this.maxFixedLengthTransactionSize + ", backoffPolicy=" + this.backoffPolicy + ", timeoutNs=" + this.timeoutNs + ", traceLevel=" + (Object)((Object)this.traceLevel) + ", controlFlowErrorsReused=" + this.controlFlowErrorsReused + ", isFat=" + this.isFat + ", maximumPoorMansConflictScanLength=" + this.maximumPoorMansConflictScanLength + ", permanentListeners=" + this.permanentListeners + '}';
    }
}

