/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.meta.NamespacedEntityId;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.meta.TopicEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.helper.SchemaIds;
import org.apache.gravitino.storage.relational.mapper.FilesetMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetVersionMapper;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionAliasRelMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionMetaMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.SchemaMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.StatisticMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TableColumnMapper;
import org.apache.gravitino.storage.relational.mapper.TableMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.TopicMetaMapper;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.service.FilesetMetaService;
import org.apache.gravitino.storage.relational.service.ModelMetaService;
import org.apache.gravitino.storage.relational.service.TableMetaService;
import org.apache.gravitino.storage.relational.service.TopicMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class SchemaMetaService {
    private static final SchemaMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;

    public static SchemaMetaService getInstance() {
        return INSTANCE;
    }

    private SchemaMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getSchemaPOByCatalogIdAndName")
    public SchemaPO getSchemaPOByCatalogIdAndName(Long catalogId, String schemaName) {
        Long l = catalogId;
        String string = schemaName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = SchemaMetaService.class.getDeclaredMethod("getSchemaPOByCatalogIdAndName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (SchemaPO)SchemaMetaService.getSchemaPOByCatalogIdAndName_aroundBody1$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName")
    public SchemaIds getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName(String metalakeName, String catalogName, String schemaName) {
        String string = metalakeName;
        String string2 = catalogName;
        String string3 = schemaName;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = SchemaMetaService.class.getDeclaredMethod("getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName", String.class, String.class, String.class).getAnnotation(Monitored.class);
        }
        return (SchemaIds)SchemaMetaService.getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName_aroundBody3$advice(this, string, string2, string3, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getSchemaIdByCatalogIdAndName")
    public Long getSchemaIdByCatalogIdAndName(Long catalogId, String schemaName) {
        Long l = catalogId;
        String string = schemaName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = SchemaMetaService.class.getDeclaredMethod("getSchemaIdByCatalogIdAndName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (Long)SchemaMetaService.getSchemaIdByCatalogIdAndName_aroundBody5$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getSchemaByIdentifier")
    public SchemaEntity getSchemaByIdentifier(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = SchemaMetaService.class.getDeclaredMethod("getSchemaByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (SchemaEntity)SchemaMetaService.getSchemaByIdentifier_aroundBody7$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listSchemasByNamespace")
    public List<SchemaEntity> listSchemasByNamespace(Namespace namespace) {
        Namespace namespace2 = namespace;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)namespace2);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = SchemaMetaService.class.getDeclaredMethod("listSchemasByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)SchemaMetaService.listSchemasByNamespace_aroundBody9$advice(this, namespace2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertSchema")
    public void insertSchema(SchemaEntity schemaEntity, boolean overwrite) throws IOException {
        SchemaEntity schemaEntity2 = schemaEntity;
        boolean bl = overwrite;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)schemaEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = SchemaMetaService.class.getDeclaredMethod("insertSchema", SchemaEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        SchemaMetaService.insertSchema_aroundBody11$advice(this, schemaEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateSchema")
    public <E extends Entity & HasIdentifier> SchemaEntity updateSchema(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = identifier;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = SchemaMetaService.class.getDeclaredMethod("updateSchema", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (SchemaEntity)SchemaMetaService.updateSchema_aroundBody13$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteSchema")
    public boolean deleteSchema(NameIdentifier identifier, boolean cascade) {
        NameIdentifier nameIdentifier = identifier;
        boolean bl = cascade;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)nameIdentifier, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = SchemaMetaService.class.getDeclaredMethod("deleteSchema", NameIdentifier.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)SchemaMetaService.deleteSchema_aroundBody15$advice(this, nameIdentifier, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteSchemaMetasByLegacyTimeline")
    public int deleteSchemaMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        Long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = SchemaMetaService.class.getDeclaredMethod("deleteSchemaMetasByLegacyTimeline", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)SchemaMetaService.deleteSchemaMetasByLegacyTimeline_aroundBody17$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    private void fillSchemaPOBuilderParentEntityId(SchemaPO.Builder builder, Namespace namespace) {
        NamespaceUtil.checkSchema(namespace);
        NamespacedEntityId namespacedEntityId = EntityIdService.getEntityIds(NameIdentifier.of((String[])namespace.levels()), Entity.EntityType.CATALOG);
        builder.withMetalakeId(namespacedEntityId.namespaceIds()[0]);
        builder.withCatalogId(namespacedEntityId.entityId());
    }

    static {
        SchemaMetaService.ajc$preClinit();
        INSTANCE = new SchemaMetaService();
    }

    private static final /* synthetic */ SchemaPO getSchemaPOByCatalogIdAndName_aroundBody0(SchemaMetaService ajc$this, Long catalogId, String schemaName, JoinPoint joinPoint) {
        SchemaPO schemaPO = SessionUtils.getWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.selectSchemaMetaByCatalogIdAndName(catalogId, schemaName));
        if (schemaPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.SCHEMA.name().toLowerCase(), schemaName});
        }
        return schemaPO;
    }

    private static final /* synthetic */ Object getSchemaPOByCatalogIdAndName_aroundBody1$advice(SchemaMetaService ajc$this, Long catalogId, String schemaName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        SchemaPO schemaPO;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.getSchemaPOByCatalogIdAndName_aroundBody0(ajc$this, catalogId, schemaName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.getSchemaPOByCatalogIdAndName_aroundBody0(ajc$this, catalogId, schemaName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                SchemaPO result = SchemaMetaService.getSchemaPOByCatalogIdAndName_aroundBody0(ajc$this, catalogId, schemaName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                schemaPO = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return schemaPO;
    }

    private static final /* synthetic */ SchemaIds getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName_aroundBody2(SchemaMetaService ajc$this, String metalakeName, String catalogName, String schemaName, JoinPoint joinPoint) {
        SchemaIds schemaIds = SessionUtils.getWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.selectSchemaIdByMetalakeNameAndCatalogNameAndSchemaName(metalakeName, catalogName, schemaName));
        if (schemaIds == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.SCHEMA.name().toLowerCase(), schemaName});
        }
        return schemaIds;
    }

    private static final /* synthetic */ Object getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName_aroundBody3$advice(SchemaMetaService ajc$this, String metalakeName, String catalogName, String schemaName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        SchemaIds schemaIds;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName_aroundBody2(ajc$this, metalakeName, catalogName, schemaName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName_aroundBody2(ajc$this, metalakeName, catalogName, schemaName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                SchemaIds result = SchemaMetaService.getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName_aroundBody2(ajc$this, metalakeName, catalogName, schemaName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                schemaIds = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return schemaIds;
    }

    private static final /* synthetic */ Long getSchemaIdByCatalogIdAndName_aroundBody4(SchemaMetaService ajc$this, Long catalogId, String schemaName, JoinPoint joinPoint) {
        Long schemaId = SessionUtils.getWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.selectSchemaIdByCatalogIdAndName(catalogId, schemaName));
        if (schemaId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.SCHEMA.name().toLowerCase(), schemaName});
        }
        return schemaId;
    }

    private static final /* synthetic */ Object getSchemaIdByCatalogIdAndName_aroundBody5$advice(SchemaMetaService ajc$this, Long catalogId, String schemaName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Long l;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.getSchemaIdByCatalogIdAndName_aroundBody4(ajc$this, catalogId, schemaName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.getSchemaIdByCatalogIdAndName_aroundBody4(ajc$this, catalogId, schemaName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Long result = SchemaMetaService.getSchemaIdByCatalogIdAndName_aroundBody4(ajc$this, catalogId, schemaName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                l = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return l;
    }

    private static final /* synthetic */ SchemaEntity getSchemaByIdentifier_aroundBody6(SchemaMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        NameIdentifierUtil.checkSchema(identifier);
        String schemaName = identifier.name();
        Long catalogId = EntityIdService.getEntityId(NameIdentifier.of((String[])identifier.namespace().levels()), Entity.EntityType.CATALOG);
        SchemaPO schemaPO = ajc$this.getSchemaPOByCatalogIdAndName(catalogId, schemaName);
        return POConverters.fromSchemaPO(schemaPO, identifier.namespace());
    }

    private static final /* synthetic */ Object getSchemaByIdentifier_aroundBody7$advice(SchemaMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        SchemaEntity schemaEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.getSchemaByIdentifier_aroundBody6(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.getSchemaByIdentifier_aroundBody6(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                SchemaEntity result = SchemaMetaService.getSchemaByIdentifier_aroundBody6(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                schemaEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return schemaEntity;
    }

    private static final /* synthetic */ List listSchemasByNamespace_aroundBody8(SchemaMetaService ajc$this, Namespace namespace, JoinPoint joinPoint) {
        NamespaceUtil.checkSchema(namespace);
        Long catalogId = EntityIdService.getEntityId(NameIdentifier.of((String[])namespace.levels()), Entity.EntityType.CATALOG);
        List schemaPOs = SessionUtils.getWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.listSchemaPOsByCatalogId(catalogId));
        return POConverters.fromSchemaPOs(schemaPOs, namespace);
    }

    private static final /* synthetic */ Object listSchemasByNamespace_aroundBody9$advice(SchemaMetaService ajc$this, Namespace namespace, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.listSchemasByNamespace_aroundBody8(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.listSchemasByNamespace_aroundBody8(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = SchemaMetaService.listSchemasByNamespace_aroundBody8(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ void insertSchema_aroundBody10(SchemaMetaService ajc$this, SchemaEntity schemaEntity, boolean overwrite, JoinPoint joinPoint) {
        try {
            NameIdentifierUtil.checkSchema(schemaEntity.nameIdentifier());
            SchemaPO.Builder builder = SchemaPO.builder();
            ajc$this.fillSchemaPOBuilderParentEntityId(builder, schemaEntity.namespace());
            SessionUtils.doWithCommit(SchemaMetaMapper.class, mapper -> {
                SchemaPO po = POConverters.initializeSchemaPOWithVersion(schemaEntity, builder);
                if (overwrite) {
                    mapper.insertSchemaMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertSchemaMeta(po);
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.SCHEMA, schemaEntity.nameIdentifier().toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object insertSchema_aroundBody11$advice(SchemaMetaService ajc$this, SchemaEntity schemaEntity, boolean overwrite, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                SchemaMetaService.insertSchema_aroundBody10(ajc$this, schemaEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                SchemaMetaService.insertSchema_aroundBody10(ajc$this, schemaEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                SchemaMetaService.insertSchema_aroundBody10(ajc$this, schemaEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ SchemaEntity updateSchema_aroundBody12(SchemaMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint joinPoint) {
        Integer updateResult;
        NameIdentifierUtil.checkSchema(identifier);
        String schemaName = identifier.name();
        Long catalogId = EntityIdService.getEntityId(NameIdentifier.of((String[])identifier.namespace().levels()), Entity.EntityType.CATALOG);
        SchemaPO oldSchemaPO = ajc$this.getSchemaPOByCatalogIdAndName(catalogId, schemaName);
        SchemaEntity oldSchemaEntity = POConverters.fromSchemaPO(oldSchemaPO, identifier.namespace());
        SchemaEntity newEntity = (SchemaEntity)updater.apply(oldSchemaEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldSchemaEntity.id(), newEntity.id()), (String)"The updated schema entity id: %s should be same with the schema entity id before: %s", (Object)newEntity.id(), (Object)oldSchemaEntity.id());
        try {
            updateResult = SessionUtils.doWithCommitAndFetchResult(SchemaMetaMapper.class, mapper -> mapper.updateSchemaMeta(POConverters.updateSchemaPOWithVersion(oldSchemaPO, newEntity), oldSchemaPO));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.SCHEMA, newEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newEntity;
        }
        throw new IOException("Failed to update the entity: " + String.valueOf(identifier));
    }

    private static final /* synthetic */ Object updateSchema_aroundBody13$advice(SchemaMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        SchemaEntity schemaEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.updateSchema_aroundBody12(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return SchemaMetaService.updateSchema_aroundBody12(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                SchemaEntity result = SchemaMetaService.updateSchema_aroundBody12(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                schemaEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return schemaEntity;
    }

    private static final /* synthetic */ boolean deleteSchema_aroundBody14(SchemaMetaService ajc$this, NameIdentifier identifier, boolean cascade, JoinPoint joinPoint) {
        NameIdentifierUtil.checkSchema(identifier);
        String schemaName = identifier.name();
        Long schemaId = EntityIdService.getEntityId(identifier, Entity.EntityType.SCHEMA);
        if (cascade) {
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.softDeleteSchemaMetasBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(TableMetaMapper.class, mapper -> mapper.softDeleteTableMetasBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(TableColumnMapper.class, mapper -> mapper.softDeleteColumnsBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.softDeleteFilesetMetasBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.softDeleteFilesetVersionsBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(TopicMetaMapper.class, mapper -> mapper.softDeleteTopicMetasBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteObjectRelsBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.softDeletePolicyMetadataObjectRelsBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.softDeleteModelVersionAliasRelsBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.softDeleteModelVersionMetasBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(ModelMetaMapper.class, mapper -> mapper.softDeleteModelMetasBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(StatisticMetaMapper.class, mapper -> mapper.softDeleteStatisticsBySchemaId(schemaId)));
        } else {
            List<TableEntity> tableEntities = TableMetaService.getInstance().listTablesByNamespace(NamespaceUtil.ofTable(identifier.namespace().level(0), identifier.namespace().level(1), schemaName));
            if (!tableEntities.isEmpty()) {
                throw new NonEmptyEntityException("Entity %s has sub-entities, you should remove sub-entities first", new Object[]{identifier});
            }
            List<FilesetEntity> filesetEntities = FilesetMetaService.getInstance().listFilesetsByNamespace(NamespaceUtil.ofFileset(identifier.namespace().level(0), identifier.namespace().level(1), schemaName));
            if (!filesetEntities.isEmpty()) {
                throw new NonEmptyEntityException("Entity %s has sub-entities, you should remove sub-entities first", new Object[]{identifier});
            }
            List<ModelEntity> modelEntities = ModelMetaService.getInstance().listModelsByNamespace(NamespaceUtil.ofModel(identifier.namespace().level(0), identifier.namespace().level(1), schemaName));
            if (!modelEntities.isEmpty()) {
                throw new NonEmptyEntityException("Entity %s has sub-entities, you should remove sub-entities first", new Object[]{identifier});
            }
            List<TopicEntity> topicEntities = TopicMetaService.getInstance().listTopicsByNamespace(NamespaceUtil.ofTopic(identifier.namespace().level(0), identifier.namespace().level(1), schemaName));
            if (!topicEntities.isEmpty()) {
                throw new NonEmptyEntityException("Entity %s has sub-entities, you should remove sub-entities first", new Object[]{identifier});
            }
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.softDeleteSchemaMetasBySchemaId(schemaId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(schemaId, MetadataObject.Type.SCHEMA.name())), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteObjectRelsByMetadataObject(schemaId, MetadataObject.Type.SCHEMA.name())), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetadataObject(schemaId, MetadataObject.Type.SCHEMA.name())), () -> SessionUtils.doWithoutCommit(StatisticMetaMapper.class, mapper -> mapper.softDeleteStatisticsByEntityId(schemaId)), () -> SessionUtils.doWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.softDeletePolicyMetadataObjectRelsByMetadataObject(schemaId, MetadataObject.Type.SCHEMA.name())));
        }
        return true;
    }

    private static final /* synthetic */ Object deleteSchema_aroundBody15$advice(SchemaMetaService ajc$this, NameIdentifier identifier, boolean cascade, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)SchemaMetaService.deleteSchema_aroundBody14(ajc$this, identifier, cascade, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)SchemaMetaService.deleteSchema_aroundBody14(ajc$this, identifier, cascade, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)SchemaMetaService.deleteSchema_aroundBody14(ajc$this, identifier, cascade, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteSchemaMetasByLegacyTimeline_aroundBody16(SchemaMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint joinPoint) {
        return SessionUtils.doWithCommitAndFetchResult(SchemaMetaMapper.class, mapper -> mapper.deleteSchemaMetasByLegacyTimeline(legacyTimeline, limit));
    }

    private static final /* synthetic */ Object deleteSchemaMetasByLegacyTimeline_aroundBody17$advice(SchemaMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)SchemaMetaService.deleteSchemaMetasByLegacyTimeline_aroundBody16(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)SchemaMetaService.deleteSchemaMetasByLegacyTimeline_aroundBody16(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)SchemaMetaService.deleteSchemaMetasByLegacyTimeline_aroundBody16(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SchemaMetaService.java", SchemaMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaPOByCatalogIdAndName", "org.apache.gravitino.storage.relational.service.SchemaMetaService", "java.lang.Long:java.lang.String", "catalogId:schemaName", "", "org.apache.gravitino.storage.relational.po.SchemaPO"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName", "org.apache.gravitino.storage.relational.service.SchemaMetaService", "java.lang.String:java.lang.String:java.lang.String", "metalakeName:catalogName:schemaName", "", "org.apache.gravitino.storage.relational.helper.SchemaIds"), 97);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaIdByCatalogIdAndName", "org.apache.gravitino.storage.relational.service.SchemaMetaService", "java.lang.Long:java.lang.String", "catalogId:schemaName", "", "java.lang.Long"), 118);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaByIdentifier", "org.apache.gravitino.storage.relational.service.SchemaMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "org.apache.gravitino.meta.SchemaEntity"), 136);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listSchemasByNamespace", "org.apache.gravitino.storage.relational.service.SchemaMetaService", "org.apache.gravitino.Namespace", "namespace", "", "java.util.List"), 152);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertSchema", "org.apache.gravitino.storage.relational.service.SchemaMetaService", "org.apache.gravitino.meta.SchemaEntity:boolean", "schemaEntity:overwrite", "java.io.IOException", "void"), 169);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateSchema", "org.apache.gravitino.storage.relational.service.SchemaMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "identifier:updater", "java.io.IOException", "org.apache.gravitino.meta.SchemaEntity"), 196);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteSchema", "org.apache.gravitino.storage.relational.service.SchemaMetaService", "org.apache.gravitino.NameIdentifier:boolean", "identifier:cascade", "", "boolean"), 238);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteSchemaMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.SchemaMetaService", "java.lang.Long:int", "legacyTimeline:limit", "", "int"), 384);
    }
}

