/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.wsdl.WSDLBuilder;
import org.apache.cxf.wsdl.WSDLExtensibilityPlugin;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLRuntimeException;

public class WSDLDefinitionBuilder
implements WSDLBuilder<Definition> {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLDefinitionBuilder.class);
    private static final String WSDL_PLUGIN_RESOURCE = "META-INF/wsdl.plugin.xml";
    protected Definition wsdlDefinition;
    private List<Definition> importedDefinitions = new ArrayList<Definition>();
    private final Map<String, WSDLExtensibilityPlugin> wsdlPlugins = new HashMap<String, WSDLExtensibilityPlugin>();
    private Bus bus;

    public WSDLDefinitionBuilder(Bus b) {
        this.bus = b;
    }

    public void setBus(Bus b) {
        this.bus = b;
    }

    public Definition build(String wsdlURL) {
        this.parseWSDL(wsdlURL);
        return this.wsdlDefinition;
    }

    protected void parseWSDL(String wsdlURL) {
        try {
            WSDLManager mgr = (WSDLManager)this.bus.getExtension(WSDLManager.class);
            this.registerWSDLExtensibilityPlugins(mgr.getExtensionRegistry());
            this.wsdlDefinition = mgr.getDefinition(wsdlURL);
            this.parseImports(this.wsdlDefinition);
            if (this.wsdlDefinition.getServices().isEmpty()) {
                for (Definition def : this.importedDefinitions) {
                    Set services = def.getServices().keySet();
                    for (QName sName : services) {
                        if (this.wsdlDefinition.getServices().keySet().contains(sName)) continue;
                        this.wsdlDefinition.getServices().put(sName, def.getService(sName));
                    }
                }
            }
        }
        catch (Exception we) {
            Message msg = new Message("FAIL_TO_CREATE_WSDL_DEFINITION", LOG, new Object[]{wsdlURL, we.getMessage()});
            throw new WSDLRuntimeException(msg, (Throwable)we);
        }
    }

    public static Collection<Import> getImports(Definition wsdlDef) {
        ArrayList<Import> importList = new ArrayList<Import>();
        Map imports = wsdlDef.getImports();
        for (Map.Entry entry : imports.entrySet()) {
            List lst = CastUtils.cast((List)((List)entry.getValue()));
            importList.addAll(lst);
        }
        return importList;
    }

    private void parseImports(Definition def) {
        for (Import impt : WSDLDefinitionBuilder.getImports(def)) {
            if (this.importedDefinitions.contains(impt.getDefinition())) continue;
            this.importedDefinitions.add(impt.getDefinition());
            this.parseImports(impt.getDefinition());
        }
    }

    public List<Definition> getImportedDefinitions() {
        return this.importedDefinitions;
    }

    public Map<String, WSDLExtensibilityPlugin> getWSDLPlugins() {
        return this.wsdlPlugins;
    }

    private void registerWSDLExtensibilityPlugins(ExtensionRegistry registry) {
        Properties initialExtensions;
        try {
            initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)WSDL_PLUGIN_RESOURCE, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (String string : initialExtensions.keySet()) {
            String pluginClz = initialExtensions.getProperty(string);
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Registering : " + pluginClz + " for type: " + string);
                }
                WSDLExtensibilityPlugin plugin = (WSDLExtensibilityPlugin)ClassLoaderUtils.loadClass((String)pluginClz, this.getClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.setExtensionRegistry(registry);
                this.wsdlPlugins.put(string, plugin);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
    }
}

