/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.reader;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.reader.MessageUtil;

public class BytesMessageUtil
extends MessageUtil {
    public static boolean bytesReadBoolean(ActiveMQBuffer message) {
        return message.readBoolean();
    }

    public static byte bytesReadByte(ActiveMQBuffer message) {
        return message.readByte();
    }

    public static int bytesReadUnsignedByte(ActiveMQBuffer message) {
        return message.readUnsignedByte();
    }

    public static short bytesReadShort(ActiveMQBuffer message) {
        return message.readShort();
    }

    public static int bytesReadUnsignedShort(ActiveMQBuffer message) {
        return message.readUnsignedShort();
    }

    public static char bytesReadChar(ActiveMQBuffer message) {
        return (char)message.readShort();
    }

    public static int bytesReadInt(ActiveMQBuffer message) {
        return message.readInt();
    }

    public static long bytesReadLong(ActiveMQBuffer message) {
        return message.readLong();
    }

    public static float bytesReadFloat(ActiveMQBuffer message) {
        return Float.intBitsToFloat(message.readInt());
    }

    public static double bytesReadDouble(ActiveMQBuffer message) {
        return Double.longBitsToDouble(message.readLong());
    }

    public static String bytesReadUTF(ActiveMQBuffer message) {
        return message.readUTF();
    }

    public static int bytesReadBytes(ActiveMQBuffer message, byte[] value) {
        return BytesMessageUtil.bytesReadBytes(message, value, value.length);
    }

    public static int bytesReadBytes(ActiveMQBuffer message, byte[] value, int length) {
        if (!message.readable()) {
            return -1;
        }
        int read = Math.min(length, message.readableBytes());
        if (read != 0) {
            message.readBytes(value, 0, read);
        }
        return read;
    }

    public static void bytesWriteBoolean(ActiveMQBuffer message, boolean value) {
        message.writeBoolean(value);
    }

    public static void bytesWriteByte(ActiveMQBuffer message, byte value) {
        message.writeByte(value);
    }

    public static void bytesWriteShort(ActiveMQBuffer message, short value) {
        message.writeShort(value);
    }

    public static void bytesWriteChar(ActiveMQBuffer message, char value) {
        message.writeShort((short)value);
    }

    public static void bytesWriteInt(ActiveMQBuffer message, int value) {
        message.writeInt(value);
    }

    public static void bytesWriteLong(ActiveMQBuffer message, long value) {
        message.writeLong(value);
    }

    public static void bytesWriteFloat(ActiveMQBuffer message, float value) {
        message.writeInt(Float.floatToIntBits(value));
    }

    public static void bytesWriteDouble(ActiveMQBuffer message, double value) {
        message.writeLong(Double.doubleToLongBits(value));
    }

    public static void bytesWriteUTF(ActiveMQBuffer message, String value) {
        message.writeUTF(value);
    }

    public static void bytesWriteBytes(ActiveMQBuffer message, byte[] value) {
        message.writeBytes(value);
    }

    public static void bytesWriteBytes(ActiveMQBuffer message, byte[] value, int offset, int length) {
        message.writeBytes(value, offset, length);
    }

    public static boolean bytesWriteObject(ActiveMQBuffer message, Object value) {
        Objects.requireNonNull(value, "Attempt to write a null value");
        if (value instanceof String) {
            String string = (String)value;
            BytesMessageUtil.bytesWriteUTF(message, string);
        } else if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            BytesMessageUtil.bytesWriteBoolean(message, booleanValue);
        } else if (value instanceof Character) {
            Character character = (Character)value;
            BytesMessageUtil.bytesWriteChar(message, character.charValue());
        } else if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            BytesMessageUtil.bytesWriteByte(message, byteValue);
        } else if (value instanceof Short) {
            Short shortValue = (Short)value;
            BytesMessageUtil.bytesWriteShort(message, shortValue);
        } else if (value instanceof Integer) {
            Integer integer = (Integer)value;
            BytesMessageUtil.bytesWriteInt(message, integer);
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            BytesMessageUtil.bytesWriteLong(message, longValue);
        } else if (value instanceof Float) {
            Float floatValue = (Float)value;
            BytesMessageUtil.bytesWriteFloat(message, floatValue.floatValue());
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            BytesMessageUtil.bytesWriteDouble(message, doubleValue);
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            BytesMessageUtil.bytesWriteBytes(message, bytes);
        } else {
            return false;
        }
        return true;
    }

    public static void bytesMessageReset(ActiveMQBuffer message) {
        message.resetReaderIndex();
    }
}

