/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.release.plugin.velocity;

import static org.junit.jupiter.api.Assertions.assertTrue;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

import org.junit.jupiter.api.Test;

/**
 * Unit tests for {@link HeaderHtmlVelocityDelegate}.
 */
class HeaderHtmlVelocityDelegateTest {

    @Test
    void testSuccess() throws IOException {
        final HeaderHtmlVelocityDelegate subject = HeaderHtmlVelocityDelegate.builder().build();
        try (Writer writer = subject.render(new StringWriter())) {
            assertTrue(writer.toString().contains("<h2>Apache Commons Project Distributions</h2>"));
        }
    }

}
