/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.internal.LexicalScope;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.TemplateEngine;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.parser.ASTAmbiguous;
import org.apache.commons.jexl3.parser.ASTAssignment;
import org.apache.commons.jexl3.parser.ASTDecrementGetNode;
import org.apache.commons.jexl3.parser.ASTGetDecrementNode;
import org.apache.commons.jexl3.parser.ASTGetIncrementNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIncrementGetNode;
import org.apache.commons.jexl3.parser.ASTJexlLambda;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTSetAddNode;
import org.apache.commons.jexl3.parser.ASTSetAndNode;
import org.apache.commons.jexl3.parser.ASTSetDivNode;
import org.apache.commons.jexl3.parser.ASTSetModNode;
import org.apache.commons.jexl3.parser.ASTSetMultNode;
import org.apache.commons.jexl3.parser.ASTSetOrNode;
import org.apache.commons.jexl3.parser.ASTSetShiftLeftNode;
import org.apache.commons.jexl3.parser.ASTSetShiftRightNode;
import org.apache.commons.jexl3.parser.ASTSetShiftRightUnsignedNode;
import org.apache.commons.jexl3.parser.ASTSetSubNode;
import org.apache.commons.jexl3.parser.ASTSetXorNode;
import org.apache.commons.jexl3.parser.ASTVar;
import org.apache.commons.jexl3.parser.FeatureController;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.JexlScriptParser;
import org.apache.commons.jexl3.parser.ParseException;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.StringParser;
import org.apache.commons.jexl3.parser.Token;

public abstract class JexlParser
extends StringParser
implements JexlScriptParser {
    public static final String PRAGMA_OPTIONS = "jexl.options";
    public static final String PRAGMA_JEXLNS = "jexl.namespace.";
    public static final String PRAGMA_MODULE = "jexl.module.";
    public static final String PRAGMA_IMPORT = "jexl.import";
    private static final Set<Class<? extends JexlNode>> ASSIGN_NODES = new HashSet<Class>(Arrays.asList(ASTAssignment.class, ASTSetAddNode.class, ASTSetSubNode.class, ASTSetMultNode.class, ASTSetDivNode.class, ASTSetModNode.class, ASTSetAndNode.class, ASTSetOrNode.class, ASTSetXorNode.class, ASTSetShiftLeftNode.class, ASTSetShiftRightNode.class, ASTSetShiftRightUnsignedNode.class, ASTIncrementGetNode.class, ASTDecrementGetNode.class, ASTGetDecrementNode.class, ASTGetIncrementNode.class));
    protected final FeatureController featureController;
    protected JexlInfo info = null;
    protected String source = null;
    protected final AtomicReference<Scope> scopeReference;
    protected final Deque<Scope> scopes;
    protected Map<String, Object> pragmas;
    protected final AtomicReference<JexlUberspect.ClassConstantResolver> fqcnResolver;
    protected final List<String> imports;
    protected boolean autoSemicolon = true;
    protected Set<String> namespaces;
    protected AtomicInteger loopCount;
    protected final Deque<Integer> loopCounts;
    protected final AtomicReference<LexicalUnit> blockReference;
    protected final Deque<LexicalUnit> blocks;
    protected final Map<LexicalUnit, Scope> blockScopes;
    protected final JexlParser parent;
    public static final Object NIL = new Object(){

        public String toString() {
            return "null";
        }
    };
    public static final Object DFLT = new Object(){

        public String toString() {
            return "default";
        }
    };
    public static final Object NAN = new Object(){

        public String toString() {
            return "NaN";
        }
    };

    protected static Token errorToken(Token ... tokens) {
        for (Token token : tokens) {
            if (token == null || token.image == null || token.image.isEmpty()) continue;
            return token;
        }
        return null;
    }

    protected static String readSourceLine(String src, int lineno) {
        String msg = "";
        if (src != null && lineno >= 0) {
            try {
                BufferedReader reader = new BufferedReader(new StringReader(src));
                for (int l = 0; l < lineno; ++l) {
                    msg = reader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return msg;
    }

    protected static String stringify(Iterable<String> lstr) {
        return String.join((CharSequence)".", lstr);
    }

    void addImport(String importName) {
        if (importName != null && !importName.isEmpty() && !this.imports.contains(importName)) {
            this.imports.add(importName);
        }
    }

    Object resolveConstant(String name) {
        JexlEngine engine;
        JexlUberspect.ClassConstantResolver resolver = this.fqcnResolver.get();
        if (resolver == null && (engine = JexlEngine.getThreadEngine()) instanceof JexlUberspect.ConstantResolverFactory) {
            resolver = ((JexlUberspect.ConstantResolverFactory)((Object)engine)).createConstantResolver(this.imports);
            this.fqcnResolver.set(resolver);
        }
        return resolver != null ? resolver.resolveConstant(name) : JexlEngine.TRY_FAILED;
    }

    protected JexlParser() {
        this(null);
    }

    protected JexlParser(JexlParser parser) {
        if (parser != null) {
            this.parent = parser;
            this.featureController = parser.featureController;
            this.scopeReference = parser.scopeReference;
            this.scopes = parser.scopes;
            this.pragmas = parser.pragmas;
            this.namespaces = parser.namespaces;
            this.loopCount = parser.loopCount;
            this.loopCounts = parser.loopCounts;
            this.blockReference = parser.blockReference;
            this.blocks = parser.blocks;
            this.blockScopes = parser.blockScopes;
            this.fqcnResolver = parser.fqcnResolver;
            this.imports = parser.imports;
            this.autoSemicolon = parser.autoSemicolon;
        } else {
            this.parent = null;
            this.featureController = new FeatureController(JexlEngine.DEFAULT_FEATURES);
            this.scopeReference = new AtomicReference();
            this.blockReference = new AtomicReference();
            this.fqcnResolver = new AtomicReference();
            this.loopCount = new AtomicInteger();
            this.scopes = new ArrayDeque<Scope>();
            this.loopCounts = new ArrayDeque<Integer>();
            this.blocks = new ArrayDeque<LexicalUnit>();
            this.blockScopes = new IdentityHashMap<LexicalUnit, Scope>();
            this.imports = new ArrayList<String>();
        }
    }

    static Object switchCode(Object value) {
        if (value == null) {
            return NIL;
        }
        if (value instanceof Double && ((Double)value).isNaN()) {
            return NAN;
        }
        return value;
    }

    static Object switchDecode(Object value) {
        if (value == NIL) {
            return null;
        }
        if (value == NAN) {
            return Double.NaN;
        }
        return value;
    }

    protected SwitchSet switchSet() {
        return new SwitchSet();
    }

    public void allowRegisters(boolean registers) {
        this.featureController.setFeatures(new JexlFeatures(this.featureController.getFeatures()).register(registers));
    }

    protected boolean allowVariable(String image) {
        JexlFeatures features = this.getFeatures();
        if (!features.supportsLocalVar()) {
            return false;
        }
        return !features.isReservedName(image);
    }

    protected void checkLambda(Token token) {
        String arrow = token.image;
        if ("->".equals(arrow)) {
            if (!this.getFeatures().supportsThinArrow()) {
                this.throwFeatureException(16, token);
            }
            return;
        }
        if ("=>".equals(arrow) && !this.getFeatures().supportsFatArrow()) {
            this.throwFeatureException(17, token);
        }
    }

    protected String checkVariable(ASTIdentifier identifier, String name) {
        Integer symbol;
        Scope scope = this.scopeReference.get();
        if (scope != null && (symbol = scope.getSymbol(name)) != null) {
            identifier.setLexical(scope.isLexical(symbol));
            boolean declared = true;
            if (scope.isCapturedSymbol(symbol)) {
                identifier.setCaptured(true);
            } else {
                LexicalUnit unit = this.getUnit();
                declared = unit.hasSymbol(symbol);
                if (!declared) {
                    for (LexicalUnit u : this.blocks) {
                        if (!u.hasSymbol(symbol)) continue;
                        unit = u;
                        declared = true;
                        break;
                    }
                }
                if (declared) {
                    if (unit.isConstant(symbol)) {
                        identifier.setConstant(true);
                    }
                } else if (this.info instanceof JexlNode.Info) {
                    declared = this.isSymbolDeclared((JexlNode.Info)this.info, symbol);
                }
            }
            identifier.setSymbol(symbol, name);
            if (!declared) {
                if (this.getFeatures().isLexicalShade()) {
                    throw new JexlException.Parsing(this.info, name + ": variable is not declared").clean();
                }
                identifier.setShaded(true);
            }
        }
        return name;
    }

    protected void cleanup(JexlFeatures features) {
        this.info = null;
        this.source = null;
        if (this.parent == null) {
            this.scopeReference.set(null);
            this.scopes.clear();
            this.pragmas = null;
            this.namespaces = null;
            this.fqcnResolver.set(null);
            this.imports.clear();
            this.loopCounts.clear();
            this.loopCount.set(0);
            this.blocks.clear();
            this.blockReference.set(null);
            this.blockScopes.clear();
            this.setFeatures(features);
        }
    }

    protected void controlPragmaAnywhere() {
        JexlFeatures features = this.getFeatures();
        if (features.supportsPragma() && !features.supportsPragmaAnywhere()) {
            this.featureController.setFeatures(new JexlFeatures(this.featureController.getFeatures()).pragma(false));
        }
    }

    protected void declareFunction(ASTVar variable, Token token) {
        String name = token.image;
        Scope scope = this.scopeReference.get();
        if (scope == null) {
            scope = new Scope(null, new String[0]);
            this.scopeReference.set(scope);
        }
        int symbol = scope.declareVariable(name);
        variable.setSymbol(symbol, name);
        variable.setLexical(true);
        if (scope.isCapturedSymbol(symbol)) {
            variable.setCaptured(true);
        }
        if (this.declareSymbol(symbol)) {
            scope.addLexical(symbol);
            LexicalUnit block = this.getUnit();
            block.setConstant(symbol);
        } else {
            if (this.getFeatures().isLexical()) {
                throw new JexlException(variable, name + ": variable is already declared");
            }
            variable.setRedefined(true);
        }
    }

    protected void declareParameter(Token token, boolean lexical, boolean constant) {
        Scope scope;
        String identifier = token.image;
        if (!this.allowVariable(identifier)) {
            this.throwFeatureException(2, token);
        }
        if ((scope = this.scopeReference.get()) == null) {
            scope = new Scope(null, null);
            this.scopeReference.set(scope);
        }
        int symbol = scope.declareParameter(identifier);
        LexicalUnit block = this.getUnit();
        if (!block.declareSymbol(symbol)) {
            if (lexical || this.getFeatures().isLexical()) {
                JexlInfo xinfo = this.info.at(token.beginLine, token.beginColumn);
                throw new JexlException.Parsing(xinfo, identifier + ": parameter is already declared").clean();
            }
        } else if (lexical) {
            scope.addLexical(symbol);
            if (constant) {
                block.setConstant(symbol);
            }
        }
    }

    protected void declarePragma(String key, Object value) {
        String[] nsprefixes;
        JexlFeatures features = this.getFeatures();
        if (!features.supportsPragma()) {
            this.throwFeatureException(11, this.getToken(0));
        }
        if (PRAGMA_IMPORT.equals(key) && !features.supportsImportPragma()) {
            this.throwFeatureException(20, this.getToken(0));
        }
        if (this.pragmas == null) {
            this.pragmas = new TreeMap<String, Object>();
        }
        for (String nsprefix : nsprefixes = new String[]{PRAGMA_JEXLNS, PRAGMA_MODULE}) {
            String nsname;
            if (!key.startsWith(nsprefix)) continue;
            if (!features.supportsNamespacePragma()) {
                this.throwFeatureException(18, this.getToken(0));
            }
            if ((nsname = key.substring(nsprefix.length())).isEmpty()) break;
            if (this.namespaces == null) {
                this.namespaces = new HashSet<String>();
            }
            this.namespaces.add(nsname);
            break;
        }
        if (value == null) {
            this.pragmas.putIfAbsent(key, null);
        } else {
            this.pragmas.merge(key, value, (previous, newValue) -> {
                if (previous instanceof Set) {
                    ((Set)previous).add(newValue);
                    return previous;
                }
                LinkedHashSet<Object> values = new LinkedHashSet<Object>();
                values.add(previous);
                values.add(newValue);
                return values;
            });
        }
    }

    private boolean declareSymbol(int symbol) {
        LexicalUnit block;
        for (LexicalUnit lu : this.blocks) {
            if (lu.hasSymbol(symbol)) {
                return false;
            }
            if (!(lu instanceof ASTJexlLambda)) continue;
            break;
        }
        return (block = this.getUnit()) == null || block.declareSymbol(symbol);
    }

    protected void declareVariable(ASTVar variable, Token token, boolean lexical, boolean constant) {
        Scope scope;
        String name = token.image;
        if (!this.allowVariable(name)) {
            this.throwFeatureException(2, token);
        }
        if ((scope = this.scopeReference.get()) == null) {
            scope = new Scope(null, new String[0]);
            this.scopeReference.set(scope);
        }
        int symbol = scope.declareVariable(name);
        variable.setSymbol(symbol, name);
        variable.setLexical(lexical);
        variable.setConstant(constant);
        if (scope.isCapturedSymbol(symbol)) {
            variable.setCaptured(true);
        }
        if (!this.declareSymbol(symbol)) {
            if (lexical || scope.isLexical(symbol) || this.getFeatures().isLexical()) {
                JexlInfo location = this.info.at(token.beginLine, token.beginColumn);
                throw new JexlException.Parsing(location, name + ": variable is already declared").clean();
            }
            variable.setRedefined(true);
        } else if (lexical) {
            scope.addLexical(symbol);
            if (constant) {
                this.getUnit().setConstant(symbol);
            }
        }
    }

    protected JexlFeatures getFeatures() {
        return this.featureController.getFeatures();
    }

    protected Scope getScope() {
        return this.scopeReference.get();
    }

    protected abstract Token getToken(int var1);

    protected LexicalUnit getUnit() {
        return this.blockReference.get();
    }

    protected void Identifier(boolean top) throws ParseException {
    }

    private boolean isConstant(int symbol) {
        if (symbol >= 0) {
            LexicalUnit block = this.getUnit();
            if (block != null && block.hasSymbol(symbol)) {
                return block.isConstant(symbol);
            }
            Scope blockScope = this.blockScopes.get(block);
            int lexical = symbol;
            for (LexicalUnit unit : this.blocks) {
                Scope unitScope = this.blockScopes.get(unit);
                if (blockScope != unitScope) {
                    int declared = blockScope.getCaptureDeclaration(lexical);
                    if (declared >= 0) {
                        lexical = declared;
                    }
                    if (unitScope != null) {
                        blockScope = unitScope;
                    }
                }
                if (!unit.hasSymbol(lexical)) continue;
                return unit.isConstant(lexical);
            }
        }
        return false;
    }

    private boolean isNamespace(String name) {
        if ("jexl".equals(name) || "$jexl".equals(name)) {
            return true;
        }
        Set<String> ns = this.namespaces;
        if (ns != null && ns.contains(name)) {
            return true;
        }
        return this.getFeatures().namespaceTest().test(name);
    }

    protected boolean isNamespaceFuncall(Token ns, Token colon, Token fun, Token paren) {
        if (!":".equals(colon.image)) {
            return false;
        }
        if (!"(".equals(paren.image)) {
            return false;
        }
        if (this.featureController.getFeatures().supportsNamespaceIdentifier()) {
            return colon.beginColumn - 1 == ns.endColumn && colon.endColumn == fun.beginColumn - 1;
        }
        if (this.isVariable(ns.image) || this.isVariable(fun.image)) {
            return colon.beginColumn - 1 == ns.endColumn && (colon.endColumn == fun.beginColumn - 1 || this.isNamespace(ns.image));
        }
        return true;
    }

    private boolean isSymbolDeclared(JexlNode.Info info, int symbol) {
        for (JexlNode walk = info.getNode(); walk != null; walk = walk.jjtGetParent()) {
            if (!(walk instanceof LexicalUnit)) continue;
            LexicalScope scope = ((LexicalUnit)((Object)walk)).getLexicalScope();
            if (scope != null && scope.hasSymbol(symbol)) {
                return true;
            }
            if (walk instanceof ASTJexlLambda) break;
        }
        return false;
    }

    protected boolean isVariable(String name) {
        Scope scope = this.scopeReference.get();
        return scope != null && scope.getSymbol(name) != null;
    }

    protected boolean isAmbiguousStatement(int semicolon) {
        if (this.autoSemicolon) {
            Token current = this.getToken(0);
            Token next = this.getToken(1);
            if (current != null && next != null && current.endLine != next.beginLine) {
                return false;
            }
        }
        return !this.getFeatures().supportsAmbiguousStatement();
    }

    protected void jjtreeCloseNodeScope(JexlNode node) {
        if (node instanceof ASTAmbiguous) {
            this.throwAmbiguousException(node);
        }
        if (node instanceof ASTJexlScript) {
            if (node instanceof ASTJexlLambda && !this.getFeatures().supportsLambda()) {
                this.throwFeatureException(8, node.jexlInfo());
            }
            ASTJexlScript script = (ASTJexlScript)node;
            Scope scope = this.scopeReference.get();
            if (script.getScope() != scope) {
                script.setScope(scope);
            }
        } else if (ASSIGN_NODES.contains(node.getClass())) {
            ASTIdentifier varName;
            JexlNode lv = node.jjtGetChild(0);
            if (!lv.isLeftValue()) {
                JexlInfo xinfo = lv.jexlInfo();
                xinfo = this.info.at(xinfo.getLine(), xinfo.getColumn());
                String msg = JexlParser.readSourceLine(this.source, xinfo.getLine());
                throw new JexlException.Assignment(xinfo, msg).clean();
            }
            if (lv instanceof ASTIdentifier && !(lv instanceof ASTVar) && this.isConstant((varName = (ASTIdentifier)lv).getSymbol())) {
                JexlInfo xinfo = lv.jexlInfo();
                xinfo = this.info.at(xinfo.getLine(), xinfo.getColumn());
                throw new JexlException.Assignment(xinfo, varName.getName()).clean();
            }
        }
        this.featureController.controlNode(node);
    }

    @Override
    public ASTJexlScript jxltParse(JexlInfo info, JexlFeatures features, String src, Scope scope) {
        return new Parser(this).parse(info, features, src, scope);
    }

    static JxltEngine.Expression parseInterpolation(JexlInfo info, String src, Scope scope) {
        JxltEngine jxlt;
        JexlEngine jexl = JexlEngine.getThreadEngine();
        if (jexl != null && (jxlt = jexl.createJxltEngine(true, -1, '$', '#')) instanceof TemplateEngine) {
            return ((TemplateEngine)jxlt).createExpression(info, src, scope);
        }
        throw new IllegalStateException("engine is not a accessible");
    }

    protected void jjtreeOpenNodeScope(JexlNode node) {
    }

    protected void beginLambda(ASTJexlScript jjtThis) {
        jjtThis.setFeatures(this.getFeatures());
        this.pushScope();
        this.pushUnit(jjtThis);
    }

    protected void endLambda(ASTJexlScript jjtThis) {
        this.popUnit(jjtThis);
        this.popScope();
    }

    protected void popScope() {
        Scope scope = this.scopes.isEmpty() ? null : this.scopes.pop();
        this.scopeReference.set(scope);
        if (!this.loopCounts.isEmpty()) {
            this.loopCount.set(this.loopCounts.pop());
        }
    }

    protected void popUnit(LexicalUnit unit) {
        LexicalUnit block = this.blockReference.get();
        if (block == unit) {
            this.blockScopes.remove(unit);
            this.blockReference.set(this.blocks.isEmpty() ? null : this.blocks.pop());
        }
    }

    protected void pushScope() {
        Scope scope = this.scopeReference.get();
        if (scope != null) {
            this.scopes.push(scope);
        }
        scope = new Scope(scope, null);
        this.scopeReference.set(scope);
        this.loopCounts.push(this.loopCount.getAndSet(0));
    }

    protected void pushUnit(LexicalUnit unit) {
        Scope scope = this.scopeReference.get();
        this.blockScopes.put(unit, scope);
        LexicalUnit block = this.blockReference.get();
        if (block != null) {
            this.blocks.push(block);
        }
        this.blockReference.set(unit);
    }

    protected void pushLoop() {
        this.loopCounts.push(this.loopCount.getAndSet(0));
    }

    protected void popLoop() {
        if (!this.loopCounts.isEmpty()) {
            this.loopCount.set(this.loopCounts.pop());
        }
    }

    protected void setFeatures(JexlFeatures features) {
        this.featureController.setFeatures(features);
    }

    protected void throwAmbiguousException(JexlNode node) {
        JexlInfo begin = node.jexlInfo(this.info.getName());
        Token t = this.getToken(0);
        JexlInfo end = this.info.at(t.beginLine, t.endColumn);
        String msg = JexlParser.readSourceLine(this.source, end.getLine());
        throw new JexlException.Ambiguous(begin, end, msg).clean();
    }

    protected void throwFeatureException(int feature, JexlInfo info) {
        String msg = info != null ? JexlParser.readSourceLine(this.source, info.getLine()) : null;
        throw new JexlException.Feature(info, feature, msg).clean();
    }

    protected void throwFeatureException(int feature, Token trigger) {
        Token token = trigger;
        if (token == null && (token = this.getToken(0)) == null) {
            throw new JexlException.Parsing(null, JexlFeatures.stringify(feature)).clean();
        }
        JexlInfo xinfo = this.info.at(token.beginLine, token.beginColumn);
        this.throwFeatureException(feature, xinfo);
    }

    protected void throwParsingException(Token parsed) {
        JexlInfo xinfo = null;
        String msg = "unrecoverable state";
        Token token = parsed;
        if (token == null) {
            token = this.getToken(0);
        }
        if (token != null) {
            xinfo = this.info.at(token.beginLine, token.beginColumn);
            msg = token.image;
        }
        throw new JexlException.Parsing(xinfo, msg).clean();
    }

    protected class SwitchSet
    implements Iterable<Object> {
        private final Set<Object> values = new LinkedHashSet<Object>();

        protected SwitchSet() {
        }

        void addAll(Collection<Object> values) {
            values.forEach(this::add);
        }

        void add(Object value) {
            Object code = JexlParser.switchCode(value);
            if (!this.values.add(code)) {
                throw new JexlException.Parsing(JexlParser.this.info, "duplicate constant value: " + value);
            }
        }

        void clear() {
            this.values.clear();
        }

        boolean isEmpty() {
            return this.values.isEmpty();
        }

        int size() {
            return this.values.size();
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private final Iterator<Object> iter;
                {
                    this.iter = SwitchSet.this.values.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Object next() {
                    return JexlParser.switchDecode(this.iter.next());
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    public static interface LexicalUnit {
        public boolean declareSymbol(int var1);

        public LexicalScope getLexicalScope();

        public int getSymbolCount();

        public boolean hasSymbol(int var1);

        public boolean isConstant(int var1);

        public void setConstant(int var1);
    }
}

