/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.xml.sax.EntityResolver;

public class TestXMLBuilderParametersImpl {
    private XMLBuilderParametersImpl params;

    @BeforeEach
    public void setUp() throws Exception {
        this.params = new XMLBuilderParametersImpl();
    }

    @Test
    void testBeanPropertiesAccess() throws Exception {
        EntityResolver resolver = (EntityResolver)Mockito.mock(EntityResolver.class);
        DocumentBuilder builder = (DocumentBuilder)Mockito.mock(DocumentBuilder.class);
        BeanHelper.setProperty((Object)this.params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        BeanHelper.setProperty((Object)this.params, (String)"fileName", (Object)"test.xml");
        BeanHelper.setProperty((Object)this.params, (String)"entityResolver", (Object)resolver);
        BeanHelper.setProperty((Object)this.params, (String)"documentBuilder", (Object)builder);
        Assertions.assertEquals((Object)"test.xml", (Object)this.params.getFileHandler().getFileName());
        Map paramsMap = this.params.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, paramsMap.get("throwExceptionOnMissing"));
        Assertions.assertSame((Object)resolver, paramsMap.get("entityResolver"));
        Assertions.assertSame((Object)builder, paramsMap.get("documentBuilder"));
    }

    @Test
    void testInheritFrom() {
        EntityResolver resolver = (EntityResolver)Mockito.mock(EntityResolver.class);
        DocumentBuilder builder = (DocumentBuilder)Mockito.mock(DocumentBuilder.class);
        this.params.setDocumentBuilder(builder).setEntityResolver(resolver).setSchemaValidation(true).setValidating(true);
        this.params.setThrowExceptionOnMissing(true);
        XMLBuilderParametersImpl params2 = new XMLBuilderParametersImpl();
        params2.inheritFrom(this.params.getParameters());
        Map parameters = params2.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
        Assertions.assertEquals((Object)resolver, parameters.get("entityResolver"));
        Assertions.assertEquals((Object)builder, parameters.get("documentBuilder"));
        Assertions.assertEquals((Object)Boolean.TRUE, parameters.get("validating"));
        Assertions.assertEquals((Object)Boolean.TRUE, parameters.get("schemaValidation"));
    }

    @Test
    void testSetDocumentBuilder() {
        DocumentBuilder builder = (DocumentBuilder)Mockito.mock(DocumentBuilder.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setDocumentBuilder(builder));
        Assertions.assertSame((Object)builder, this.params.getParameters().get("documentBuilder"));
    }

    @Test
    void testSetEntityResolver() {
        EntityResolver resolver = (EntityResolver)Mockito.mock(EntityResolver.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setEntityResolver(resolver));
        Assertions.assertSame((Object)resolver, (Object)this.params.getEntityResolver());
        Assertions.assertSame((Object)resolver, this.params.getParameters().get("entityResolver"));
    }

    @Test
    void testSetPublicID() {
        String pubID = "testPublicID";
        Assertions.assertSame((Object)this.params, (Object)this.params.setPublicID("testPublicID"));
        Assertions.assertEquals((Object)"testPublicID", this.params.getParameters().get("publicID"));
    }

    @Test
    void testSetSchemaValidation() {
        Assertions.assertSame((Object)this.params, (Object)this.params.setSchemaValidation(false));
        Assertions.assertEquals((Object)Boolean.FALSE, this.params.getParameters().get("schemaValidation"));
    }

    @Test
    void testSetSystemID() {
        String sysID = "testSystemID";
        Assertions.assertSame((Object)this.params, (Object)this.params.setSystemID("testSystemID"));
        Assertions.assertEquals((Object)"testSystemID", this.params.getParameters().get("systemID"));
    }

    @Test
    void testSetValidating() {
        Assertions.assertSame((Object)this.params, (Object)this.params.setValidating(true));
        Assertions.assertEquals((Object)Boolean.TRUE, this.params.getParameters().get("validating"));
    }
}

