/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.ComparableProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.ColumnSelectMetadata;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SortOrder;

public class ColumnSelect<T>
extends FluentSelect<T> {
    private Collection<Property<?>> columns;
    boolean singleColumn = true;
    ColumnSelectMetadata metaData = new ColumnSelectMetadata();

    protected ColumnSelect() {
    }

    protected ColumnSelect(ObjectSelect<T> select) {
        this.entityType = select.entityType;
        this.entityName = select.entityName;
        this.dbEntityName = select.dbEntityName;
        this.where = select.where;
        this.having = select.having;
        this.orderings = select.orderings;
        this.metaData.copyFromInfo(select.metaData);
    }

    public ColumnSelect<T> entityType(Class<?> entityType) {
        return this.resetEntity(entityType, null, null);
    }

    public ColumnSelect<T> entityName(String entityName) {
        return this.resetEntity(null, entityName, null);
    }

    public ColumnSelect<T> dbEntityName(String dbEntityName) {
        return this.resetEntity(null, null, dbEntityName);
    }

    private ColumnSelect<T> resetEntity(Class<?> entityType, String entityName, String dbEntityName) {
        this.entityType = entityType;
        this.entityName = entityName;
        this.dbEntityName = dbEntityName;
        return this;
    }

    public ColumnSelect<T> where(Expression expression) {
        return this.and(expression);
    }

    public ColumnSelect<T> where(String expressionString, Object ... parameters) {
        return this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public ColumnSelect<T> and(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.and(Arrays.asList(expressions));
    }

    public ColumnSelect<T> or(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.or(Arrays.asList(expressions));
    }

    public ColumnSelect<T> orderBy(String property) {
        return this.orderBy(new Ordering(property));
    }

    public ColumnSelect<T> orderBy(String property, SortOrder sortOrder) {
        return this.orderBy(new Ordering(property, sortOrder));
    }

    public ColumnSelect<T> orderBy(Ordering ... orderings) {
        if (orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList(orderings.length);
        }
        Collections.addAll(this.orderings, orderings);
        return this;
    }

    public ColumnSelect<T> orderBy(Collection<Ordering> orderings) {
        if (orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList(orderings.size());
        }
        this.orderings.addAll(orderings);
        return this;
    }

    public ColumnSelect<T> prefetch(PrefetchTreeNode prefetch) {
        this.metaData.mergePrefetch(prefetch);
        return this;
    }

    public ColumnSelect<T> prefetch(String path, int semantics) {
        if (path == null) {
            return this;
        }
        this.metaData.addPrefetch(path, semantics);
        return this;
    }

    public ColumnSelect<T> limit(int fetchLimit) {
        this.metaData.setFetchLimit(fetchLimit);
        return this;
    }

    public ColumnSelect<T> offset(int fetchOffset) {
        this.metaData.setFetchOffset(fetchOffset);
        return this;
    }

    public ColumnSelect<T> pageSize(int pageSize) {
        this.metaData.setPageSize(pageSize);
        return this;
    }

    public ColumnSelect<T> statementFetchSize(int size) {
        this.metaData.setStatementFetchSize(size);
        return this;
    }

    public ColumnSelect<T> queryTimeout(int timeout) {
        this.metaData.setQueryTimeout(timeout);
        return this;
    }

    public ColumnSelect<T> cacheStrategy(QueryCacheStrategy strategy) {
        this.setCacheStrategy(strategy);
        this.setCacheGroup(null);
        return this;
    }

    public ColumnSelect<T> cacheStrategy(QueryCacheStrategy strategy, String cacheGroup) {
        return this.cacheStrategy(strategy).cacheGroup(cacheGroup);
    }

    public ColumnSelect<T> cacheGroup(String cacheGroup) {
        this.setCacheGroup(cacheGroup);
        return this;
    }

    public ColumnSelect<T> localCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroup);
    }

    public ColumnSelect<T> localCache() {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
    }

    public ColumnSelect<T> sharedCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroup);
    }

    public ColumnSelect<T> sharedCache() {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE);
    }

    public ColumnSelect<Object[]> columns(Property<?> ... properties) {
        if (properties.length == 0) {
            throw new IllegalArgumentException("properties must contain at least one element");
        }
        if (this.columns == null) {
            this.columns = new ArrayList(properties.length);
        }
        Collections.addAll(this.columns, properties);
        this.singleColumn = false;
        return this;
    }

    public ColumnSelect<Object[]> columns(Collection<Property<?>> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("properties must contain at least one element");
        }
        if (this.columns == null) {
            this.columns = new ArrayList(properties.size());
        }
        this.columns.addAll(properties);
        this.singleColumn = false;
        return this;
    }

    protected <E> ColumnSelect<E> column(Property<E> property) {
        if (this.columns == null) {
            this.columns = new ArrayList(1);
        } else {
            this.columns.clear();
        }
        this.columns.add(property);
        return this;
    }

    public ColumnSelect<Object[]> count() {
        return this.columns(PropertyFactory.COUNT);
    }

    public ColumnSelect<Object[]> count(BaseProperty<?> property) {
        return this.columns(property.count());
    }

    public ColumnSelect<Object[]> min(ComparableProperty<?> property) {
        return this.columns(property.min());
    }

    public ColumnSelect<Object[]> max(ComparableProperty<?> property) {
        return this.columns(property.max());
    }

    @Deprecated
    public ColumnSelect<Object[]> avg(org.apache.cayenne.exp.Property<?> property) {
        return this.columns(property.avg());
    }

    public ColumnSelect<Object[]> avg(NumericProperty<?> property) {
        return this.columns(property.avg());
    }

    @Deprecated
    public <E extends Number> ColumnSelect<Object[]> sum(org.apache.cayenne.exp.Property<E> property) {
        return this.columns(property.sum());
    }

    public <E extends Number> ColumnSelect<Object[]> sum(NumericProperty<E> property) {
        return this.columns(property.sum());
    }

    public ColumnSelect<T> having(Expression expression) {
        this.havingExpressionIsActive = true;
        return this.and(expression);
    }

    public ColumnSelect<T> having(String expressionString, Object ... parameters) {
        this.havingExpressionIsActive = true;
        return this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public ColumnSelect<T> and(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        Expression activeExpression = this.getActiveExpression();
        if (activeExpression != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(activeExpression);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.setActiveExpression(ExpressionFactory.and(all));
        return this;
    }

    public ColumnSelect<T> or(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        Expression activeExpression = this.getActiveExpression();
        if (activeExpression != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(activeExpression);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.setActiveExpression(ExpressionFactory.or(all));
        return this;
    }

    public ColumnSelect<T> distinct() {
        this.metaData.setSuppressingDistinct(false);
        this.distinct = true;
        return this;
    }

    public ColumnSelect<T> suppressDistinct() {
        this.metaData.setSuppressingDistinct(true);
        this.distinct = false;
        return this;
    }

    @Override
    public Collection<Property<?>> getColumns() {
        return this.columns;
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }

    boolean isSingleColumn() {
        return this.singleColumn;
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        Object root = this.resolveRoot(resolver);
        this.metaData.resolve(root, resolver, this);
        return this.metaData;
    }

    @Override
    protected BaseQueryMetadata getBaseMetaData() {
        return this.metaData;
    }

    public <E> ColumnSelect<E> map(Function<T, E> mapper) {
        this.metaData.setResultMapper(mapper);
        return this;
    }
}

