/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.ByteBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;

public class UnsafeBufferPosition
extends Position {
    private boolean isClosed = false;
    private final int counterId;
    private final long addressOffset;
    private final byte[] byteArray;
    private final CountersManager countersManager;
    private final ByteBuffer byteBuffer;

    public UnsafeBufferPosition(UnsafeBuffer buffer, int counterId) {
        this(buffer, counterId, null);
    }

    public UnsafeBufferPosition(UnsafeBuffer buffer, int counterId, CountersManager countersManager) {
        this.counterId = counterId;
        this.countersManager = countersManager;
        this.byteArray = buffer.byteArray();
        this.byteBuffer = buffer.byteBuffer();
        int counterOffset = CountersManager.counterOffset(counterId);
        buffer.boundsCheck(counterOffset, 8);
        this.addressOffset = buffer.addressOffset() + (long)counterOffset;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int id() {
        return this.counterId;
    }

    @Override
    public long get() {
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset);
    }

    @Override
    public long getVolatile() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset);
    }

    @Override
    public void set(long value) {
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset, value);
    }

    @Override
    public void setOrdered(long value) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, value);
    }

    @Override
    public void setVolatile(long value) {
        UnsafeAccess.UNSAFE.putLongVolatile(this.byteArray, this.addressOffset, value);
    }

    @Override
    public boolean proposeMax(long proposedValue) {
        boolean updated = false;
        if (UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset) < proposedValue) {
            UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset, proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean proposeMaxOrdered(long proposedValue) {
        boolean updated = false;
        if (UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset) < proposedValue) {
            UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (null != this.countersManager) {
                this.countersManager.free(this.counterId);
            }
        }
    }

    public String toString() {
        return "UnsafeBufferPosition{isClosed=" + this.isClosed() + ", counterId=" + this.counterId + ", value=" + (this.isClosed() ? -1L : this.getVolatile()) + '}';
    }
}

