/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.CIDRPermissions;
import org.apache.cassandra.auth.DCPermissions;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleOptions;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.PasswordObfuscator;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CreateRoleStatement
extends AuthenticationStatement {
    private final RoleResource role;
    private final RoleOptions opts;
    final DCPermissions dcPermissions;
    final CIDRPermissions cidrPermissions;
    private final boolean ifNotExists;

    public CreateRoleStatement(RoleName name, RoleOptions options, DCPermissions dcPermissions, CIDRPermissions cidrPermissions, boolean ifNotExists) {
        this.role = RoleResource.role(name.getName());
        this.opts = options;
        this.dcPermissions = dcPermissions;
        this.cidrPermissions = cidrPermissions;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void authorize(ClientState state) throws UnauthorizedException {
        super.checkPermission(state, Permission.CREATE, RoleResource.root());
        if (this.opts.getSuperuser().isPresent() && this.opts.getSuperuser().get().booleanValue() && !state.getUser().isSuper()) {
            throw new UnauthorizedException("Only superusers can create a role with superuser status");
        }
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        this.opts.validate();
        if (this.role.getRoleName().isEmpty()) {
            throw new InvalidRequestException("Role name can't be an empty string");
        }
        if (this.dcPermissions != null) {
            this.dcPermissions.validate();
        }
        if (this.cidrPermissions != null) {
            this.cidrPermissions.validate();
        }
        state.ensureNotAnonymous();
        if (!this.ifNotExists && DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            throw new InvalidRequestException(String.format("%s already exists", this.role.getRoleName()));
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestExecutionException, RequestValidationException {
        if (this.ifNotExists && DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            return null;
        }
        DatabaseDescriptor.getRoleManager().createRole(state.getUser(), this.role, this.opts);
        if (DatabaseDescriptor.getNetworkAuthorizer().requireAuthorization()) {
            DatabaseDescriptor.getNetworkAuthorizer().setRoleDatacenters(this.role, this.dcPermissions);
        }
        if (this.cidrPermissions != null) {
            DatabaseDescriptor.getCIDRAuthorizer().setCidrGroupsForRole(this.role, this.cidrPermissions);
        }
        this.grantPermissionsToCreator(state);
        return null;
    }

    private void grantPermissionsToCreator(ClientState state) {
        if (!state.getUser().isAnonymous()) {
            try {
                DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, this.role.applicablePermissions(), this.role, RoleResource.role(state.getUser().getName()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_ROLE);
    }

    @Override
    public String obfuscatePassword(String query) {
        return PasswordObfuscator.obfuscate(query, this.opts);
    }
}

