/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// IntegrationLister helps list Integrations.
// All objects returned here must be treated as read-only.
type IntegrationLister interface {
	// List lists all Integrations in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*camelv1.Integration, err error)
	// Integrations returns an object that can list and get Integrations.
	Integrations(namespace string) IntegrationNamespaceLister
	IntegrationListerExpansion
}

// integrationLister implements the IntegrationLister interface.
type integrationLister struct {
	listers.ResourceIndexer[*camelv1.Integration]
}

// NewIntegrationLister returns a new IntegrationLister.
func NewIntegrationLister(indexer cache.Indexer) IntegrationLister {
	return &integrationLister{listers.New[*camelv1.Integration](indexer, camelv1.Resource("integration"))}
}

// Integrations returns an object that can list and get Integrations.
func (s *integrationLister) Integrations(namespace string) IntegrationNamespaceLister {
	return integrationNamespaceLister{listers.NewNamespaced[*camelv1.Integration](s.ResourceIndexer, namespace)}
}

// IntegrationNamespaceLister helps list and get Integrations.
// All objects returned here must be treated as read-only.
type IntegrationNamespaceLister interface {
	// List lists all Integrations in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*camelv1.Integration, err error)
	// Get retrieves the Integration from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*camelv1.Integration, error)
	IntegrationNamespaceListerExpansion
}

// integrationNamespaceLister implements the IntegrationNamespaceLister
// interface.
type integrationNamespaceLister struct {
	listers.ResourceIndexer[*camelv1.Integration]
}
