/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	trait "github.com/apache/camel-k/v2/pkg/apis/camel/v1/trait"
)

// IntegrationKitTraitsApplyConfiguration represents a declarative configuration of the IntegrationKitTraits type for use
// with apply.
type IntegrationKitTraitsApplyConfiguration struct {
	Builder  *trait.BuilderTrait                     `json:"builder,omitempty"`
	Camel    *trait.CamelTrait                       `json:"camel,omitempty"`
	Quarkus  *trait.QuarkusTrait                     `json:"quarkus,omitempty"`
	Registry *trait.RegistryTrait                    `json:"registry,omitempty"`
	Addons   map[string]AddonTraitApplyConfiguration `json:"addons,omitempty"`
}

// IntegrationKitTraitsApplyConfiguration constructs a declarative configuration of the IntegrationKitTraits type for use with
// apply.
func IntegrationKitTraits() *IntegrationKitTraitsApplyConfiguration {
	return &IntegrationKitTraitsApplyConfiguration{}
}

// WithBuilder sets the Builder field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Builder field is set to the value of the last call.
func (b *IntegrationKitTraitsApplyConfiguration) WithBuilder(value trait.BuilderTrait) *IntegrationKitTraitsApplyConfiguration {
	b.Builder = &value
	return b
}

// WithCamel sets the Camel field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Camel field is set to the value of the last call.
func (b *IntegrationKitTraitsApplyConfiguration) WithCamel(value trait.CamelTrait) *IntegrationKitTraitsApplyConfiguration {
	b.Camel = &value
	return b
}

// WithQuarkus sets the Quarkus field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Quarkus field is set to the value of the last call.
func (b *IntegrationKitTraitsApplyConfiguration) WithQuarkus(value trait.QuarkusTrait) *IntegrationKitTraitsApplyConfiguration {
	b.Quarkus = &value
	return b
}

// WithRegistry sets the Registry field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Registry field is set to the value of the last call.
func (b *IntegrationKitTraitsApplyConfiguration) WithRegistry(value trait.RegistryTrait) *IntegrationKitTraitsApplyConfiguration {
	b.Registry = &value
	return b
}

// WithAddons puts the entries into the Addons field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Addons field,
// overwriting an existing map entries in Addons field with the same key.
func (b *IntegrationKitTraitsApplyConfiguration) WithAddons(entries map[string]AddonTraitApplyConfiguration) *IntegrationKitTraitsApplyConfiguration {
	if b.Addons == nil && len(entries) > 0 {
		b.Addons = make(map[string]AddonTraitApplyConfiguration, len(entries))
	}
	for k, v := range entries {
		b.Addons[k] = v
	}
	return b
}
