/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ImportantHeaderUtils {

    private static final Set<String> IMPORTANT_HEADER_KEYS = Collections.unmodifiableSet(new HashSet<>(
            Arrays.asList(
                    // Generated by camel build tools - do NOT edit this list!
                    // IMPORTANT-HEADER-KEYS: START
                    "CamelAggregatedCorrelationKey",
                    "CamelAggregatedSize",
                    "CamelAsteriskEventName",
                    "CamelExecExitValue",
                    "CamelFileLength",
                    "CamelFileName",
                    "CamelFtpReplyCode",
                    "CamelFtpReplyString",
                    "CamelHttpResponseCode",
                    "CamelHttpResponseText",
                    "CamelMqttTopic",
                    "CamelNatsSID",
                    "CamelNatsStatusCode",
                    "CamelNatsStatusError",
                    "CamelNettyRemoteAddress",
                    "CamelRockerMQKey",
                    "CamelSplitIndex",
                    "CamelSplitSize",
                    "CamelSqlRowCount",
                    "CamelSqlStoredUpdateCount",
                    "CamelSqlUpdateCount",
                    "CamelSshExitValue",
                    "Content-Type",
                    "kafka.KEY",
                    "kafka.OFFSET",
                    "kafka.PARTITION",
                    "kafka.TOPIC",
                    "websocket.eventType"
            // IMPORTANT-HEADER-KEYS: END
            )));

    private ImportantHeaderUtils() {
    }

    /**
     * All the important header keys (unmodifiable)
     */
    public static Set<String> getImportantHeaderKeys() {
        return IMPORTANT_HEADER_KEYS;
    }

    /**
     * Whether the given header or exchange properties is marked as important.
     *
     * @param  key the header key
     * @return     true if important, false otherwise
     */
    public static boolean isImportantHeader(String key) {
        return IMPORTANT_HEADER_KEYS.contains(key);
    }

}
