/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayOutputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.StringUtils;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.LoggerTestTool;
import org.apache.zookeeper.test.QuorumBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyModeTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyModeTest.class);
    private static int CONNECTION_TIMEOUT = QuorumBase.CONNECTION_TIMEOUT;
    private QuorumUtil qu = new QuorumUtil(1);

    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("readonlymode.enabled", "true");
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.setProperty("readonlymode.enabled", "false");
        this.qu.tearDown();
    }

    @Test
    @Timeout(value=90L)
    public void testMultiTransaction() throws Exception {
        this.qu.enableLocalSession(true);
        this.qu.startQuorum();
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        String data = "Data to be read in RO mode";
        String node1 = "/tnode1";
        String node2 = "/tnode2";
        zk.create("/tnode1", "Data to be read in RO mode".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        watcher.waitForDisconnected(CONNECTION_TIMEOUT);
        watcher.reset();
        this.qu.shutdown(2);
        zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        Assertions.assertEquals((Object)ZooKeeper.States.CONNECTEDREADONLY, (Object)zk.getState(), (String)"Should be in r-o mode");
        String remoteData = new String(zk.getData("/tnode1", false, null));
        Assertions.assertEquals((Object)"Data to be read in RO mode", (Object)remoteData, (String)"Failed to read data in r-o mode");
        try {
            Transaction transaction = zk.transaction();
            transaction.setData("/tnode1", "no way".getBytes(), -1);
            transaction.create("/tnode2", "Data to be read in RO mode".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            transaction.commit();
            Assertions.fail((String)"Write operation using multi-transaction api has succeeded during RO mode");
        }
        catch (KeeperException.NotReadOnlyException notReadOnlyException) {
            // empty catch block
        }
        Assertions.assertNull((Object)zk.exists("/tnode2", false), (String)"Should have created the znode:/tnode2");
    }

    @Test
    @Timeout(value=90L)
    public void testReadOnlyClient() throws Exception {
        this.qu.enableLocalSession(true);
        this.qu.startQuorum();
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        String data = "Data to be read in RO mode";
        String node = "/tnode";
        zk.create("/tnode", "Data to be read in RO mode".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        watcher.reset();
        this.qu.shutdown(2);
        zk.close();
        zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        String remoteData = new String(zk.getData("/tnode", false, null));
        Assertions.assertEquals((Object)"Data to be read in RO mode", (Object)remoteData);
        try {
            zk.setData("/tnode", "no way".getBytes(), -1);
            Assertions.fail((String)"Write operation has succeeded during RO mode");
        }
        catch (KeeperException.NotReadOnlyException notReadOnlyException) {
            // empty catch block
        }
        watcher.reset();
        this.qu.start(2);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.qu.getPeer((int)2).clientPort, CONNECTION_TIMEOUT), (String)"waiting for server up");
        zk.close();
        watcher.reset();
        zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        zk.setData("/tnode", "We're in the quorum now".getBytes(), -1);
        zk.close();
    }

    @Test
    @Timeout(value=90L)
    public void testConnectionEvents() throws Exception {
        this.qu.enableLocalSession(true);
        this.qu.startQuorum();
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        boolean success = false;
        for (int i = 0; i < 30; ++i) {
            try {
                zk.create("/test", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                success = true;
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                Thread.sleep(1000L);
                continue;
            }
        }
        Assertions.assertTrue((boolean)success, (String)"Did not succeed in connecting in 30s");
        Assertions.assertFalse((boolean)watcher.readOnlyConnected, (String)"The connection should not be read-only yet");
        this.qu.shutdown(2);
        watcher = new ClientBase.CountdownWatcher();
        zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        long start = Time.currentElapsedTime();
        while (zk.getState() != ZooKeeper.States.CONNECTEDREADONLY) {
            Thread.sleep(200L);
            Assertions.assertTrue((Time.currentElapsedTime() - start < 30000L ? 1 : 0) != 0, (String)"Can't connect to the server");
        }
        watcher.waitForReadOnlyConnected(5000L);
        zk.close();
    }

    @Test
    @Timeout(value=90L)
    public void testSessionEstablishment() throws Exception {
        this.qu.enableLocalSession(true);
        this.qu.startQuorum();
        this.qu.shutdown(2);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        Assertions.assertSame((Object)ZooKeeper.States.CONNECTEDREADONLY, (Object)zk.getState(), (String)"should be in r/o mode");
        long fakeId = zk.getSessionId();
        LOG.info("Connected as r/o mode with state {} and session id {}", (Object)zk.getState(), (Object)fakeId);
        watcher.reset();
        this.qu.start(2);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.qu.getPeer((int)2).clientPort, CONNECTION_TIMEOUT), (String)"waiting for server up");
        LOG.info("Server 127.0.0.1:{} is up", (Object)this.qu.getPeer((int)2).clientPort);
        watcher.waitForSyncConnected(CONNECTION_TIMEOUT);
        Assertions.assertEquals((Object)ZooKeeper.States.CONNECTED, (Object)zk.getState(), (String)"Should be in read-write mode");
        LOG.info("Connected as rw mode with state {} and session id {}", (Object)zk.getState(), (Object)zk.getSessionId());
        zk.create("/test", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertFalse((zk.getSessionId() == fakeId ? 1 : 0) != 0, (String)"fake session and real session have same id");
        zk.close();
    }

    @Test
    @Timeout(value=90L)
    public void testGlobalSessionInRO() throws Exception {
        this.qu.startQuorum();
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        LOG.info("global session created 0x{}", (Object)Long.toHexString(zk.getSessionId()));
        watcher.reset();
        this.qu.shutdown(2);
        try {
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            Assertions.fail((String)"Should not be able to renew a global session");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        zk.close();
        watcher.reset();
        zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        try {
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            Assertions.fail((String)"Should not be able to create a global session");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        zk.close();
        this.qu.getPeer((int)1).peer.enableLocalSessions(true);
        zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        try {
            watcher.waitForConnected(CONNECTION_TIMEOUT);
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"Should be able to create a local session");
        }
        zk.close();
    }

    @Test
    @Timeout(value=90L)
    public void testSeekForRwServer() throws Exception {
        this.qu.enableLocalSession(true);
        this.qu.startQuorum();
        try (LoggerTestTool loggerTestTool = new LoggerTestTool("org.apache.zookeeper");){
            String line;
            ByteArrayOutputStream os = loggerTestTool.getOutputStream();
            this.qu.shutdown(2);
            ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
            ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            this.qu.getPeer((int)1).peer.setSuspended(true);
            watcher.reset();
            this.qu.start(2);
            this.qu.start(3);
            ClientBase.waitForServerUp(this.qu.getConnString(), 2000L);
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            zk.create("/test", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.qu.getPeer((int)1).peer.setSuspended(false);
            String log = os.toString();
            Assertions.assertFalse((boolean)StringUtils.isEmpty((String)log), (String)"OutputStream doesn't have any log messages");
            LineNumberReader r = new LineNumberReader(new StringReader(log));
            Pattern p = Pattern.compile(".*Majority server found.*");
            boolean found = false;
            while ((line = r.readLine()) != null) {
                if (!p.matcher(line).matches()) continue;
                found = true;
                break;
            }
            Assertions.assertTrue((boolean)found, (String)"Majority server wasn't found while connected to r/o server");
        }
    }
}

