/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZxidRolloverTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ZxidRolloverTest.class);
    private QuorumUtil qu;
    private ZooKeeperServer zksLeader;
    private ZooKeeper[] zkClients = new ZooKeeper[3];
    private ClientBase.CountdownWatcher[] zkClientWatchers = new ClientBase.CountdownWatcher[3];
    private int idxLeader;
    private int idxFollower;

    private ZooKeeper getClient(int idx) {
        return this.zkClients[idx - 1];
    }

    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("zookeeper.admin.enableServer", "false");
        SyncRequestProcessor.setSnapCount((int)7);
        this.qu = new QuorumUtil(1);
        this.startAll();
        for (int i = 0; i < this.zkClients.length; ++i) {
            this.zkClientWatchers[i] = new ClientBase.CountdownWatcher();
            QuorumUtil.PeerStruct peer = this.qu.getPeer(i + 1);
            this.zkClients[i] = new ZooKeeper("127.0.0.1:" + peer.clientPort, ClientTest.CONNECTION_TIMEOUT, (Watcher)this.zkClientWatchers[i]);
        }
        this.waitForClientsConnected();
    }

    private void waitForClientsConnected() throws Exception {
        for (int i = 0; i < this.zkClients.length; ++i) {
            this.zkClientWatchers[i].waitForConnected(ClientTest.CONNECTION_TIMEOUT);
            this.zkClientWatchers[i].reset();
        }
    }

    private void checkClientsConnected() throws Exception {
        for (int i = 0; i < this.zkClients.length; ++i) {
            this.checkClientConnected(i + 1);
        }
    }

    private void checkClientConnected(int idx) throws Exception {
        ZooKeeper zk = this.getClient(idx);
        if (zk == null) {
            return;
        }
        try {
            Assertions.assertNull((Object)zk.exists("/foofoofoo-connected", false));
        }
        catch (KeeperException.ConnectionLossException e) {
            QuorumUtil.PeerStruct peer = this.qu.getPeer(idx);
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + peer.clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server down");
            Assertions.assertNull((Object)zk.exists("/foofoofoo-connected", false));
        }
    }

    private void checkClientsDisconnected() throws Exception {
        for (int i = 0; i < this.zkClients.length; ++i) {
            this.checkClientDisconnected(i + 1);
        }
    }

    private void checkClientDisconnected(int idx) throws Exception {
        ZooKeeper zk = this.getClient(idx);
        if (zk == null) {
            return;
        }
        try {
            Assertions.assertNull((Object)zk.exists("/foofoofoo-disconnected", false));
            Assertions.fail((String)"expected client to be disconnected");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
    }

    private void startAll() throws Exception {
        this.qu.startAll();
        this.checkLeader();
        this.checkClientsConnected();
    }

    private void start(int idx) throws Exception {
        this.qu.start(idx);
        for (String hp : this.qu.getConnString().split(",")) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(hp, ClientTest.CONNECTION_TIMEOUT), (String)"waiting for server up");
        }
        this.checkLeader();
        this.checkClientsConnected();
    }

    private void checkLeader() {
        this.idxLeader = 1;
        while (this.qu.getPeer((int)this.idxLeader).peer.leader == null) {
            ++this.idxLeader;
        }
        this.idxFollower = this.idxLeader == 1 ? 2 : 1;
        this.zksLeader = this.qu.getPeer((int)this.idxLeader).peer.getActiveServer();
    }

    private void shutdownAll() throws Exception {
        this.qu.shutdownAll();
        this.checkClientsDisconnected();
    }

    private void shutdown(int idx) throws Exception {
        this.qu.shutdown(idx);
        QuorumUtil.PeerStruct peer = this.qu.getPeer(idx);
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + peer.clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server down");
        if (idx == this.idxLeader) {
            this.checkClientDisconnected(idx);
            try {
                this.checkClientsDisconnected();
            }
            catch (AssertionError assertionError) {}
        } else {
            this.checkClientDisconnected(idx);
        }
    }

    private void adjustEpochNearEnd() {
        this.zksLeader.setZxid(this.zksLeader.getZxid() & 0xFFFFFFFF00000000L | 0xFFFFFFFCL);
    }

    @AfterEach
    public void tearDown() throws Exception {
        LOG.info("tearDown starting");
        for (int i = 0; i < this.zkClients.length; ++i) {
            this.zkClients[i].close();
        }
        this.qu.shutdownAll();
    }

    private int createNodes(ZooKeeper zk, int start, int count) throws Exception {
        LOG.info("Creating nodes {} thru {}", (Object)start, (Object)(start + count));
        int j = 0;
        try {
            for (int i = start; i < start + count; ++i) {
                zk.create("/foo" + i, new byte[0], (List)ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.EPHEMERAL);
                ++j;
            }
        }
        catch (KeeperException.ConnectionLossException e) {
            this.waitForClientsConnected();
        }
        return j;
    }

    private void checkNodes(ZooKeeper zk, int start, int count) throws Exception {
        LOG.info("Validating nodes {} thru {}", (Object)start, (Object)(start + count));
        for (int i = start; i < start + count; ++i) {
            Assertions.assertNotNull((Object)zk.exists("/foo" + i, false));
            LOG.error("Exists zxid:{}", (Object)Long.toHexString(zk.exists("/foo" + i, false).getCzxid()));
        }
        Assertions.assertNull((Object)zk.exists("/foo" + (start + count), false));
    }

    @Test
    public void testSimpleRolloverFollower() throws Exception {
        this.adjustEpochNearEnd();
        ZooKeeper zk = this.getClient(this.idxLeader == 1 ? 2 : 1);
        int countCreated = this.createNodes(zk, 0, 10);
        this.checkNodes(zk, 0, countCreated);
    }

    @Test
    public void testRolloverThenRestart() throws Exception {
        ZooKeeper zk = this.getClient(this.idxFollower);
        int countCreated = this.createNodes(zk, 0, 10);
        this.adjustEpochNearEnd();
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdownAll();
        this.startAll();
        zk = this.getClient(this.idxLeader);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.adjustEpochNearEnd();
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdownAll();
        this.startAll();
        zk = this.getClient(this.idxFollower);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdownAll();
        this.startAll();
        zk = this.getClient(this.idxLeader);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        Assertions.assertTrue((countCreated > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((countCreated < 60 ? 1 : 0) != 0);
    }

    @Test
    public void testRolloverThenFollowerRestart() throws Exception {
        ZooKeeper zk = this.getClient(this.idxFollower);
        int countCreated = this.createNodes(zk, 0, 10);
        this.adjustEpochNearEnd();
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdown(this.idxFollower);
        this.start(this.idxFollower);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.adjustEpochNearEnd();
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdown(this.idxFollower);
        this.start(this.idxFollower);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdown(this.idxFollower);
        this.start(this.idxFollower);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        Assertions.assertTrue((countCreated > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((countCreated < 60 ? 1 : 0) != 0);
    }

    @Test
    public void testRolloverThenLeaderRestart() throws Exception {
        ZooKeeper zk = this.getClient(this.idxLeader);
        int countCreated = this.createNodes(zk, 0, 10);
        this.adjustEpochNearEnd();
        this.checkNodes(zk, 0, countCreated);
        this.shutdown(this.idxLeader);
        this.start(this.idxLeader);
        zk = this.getClient(this.idxLeader);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.adjustEpochNearEnd();
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdown(this.idxLeader);
        this.start(this.idxLeader);
        zk = this.getClient(this.idxLeader);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdown(this.idxLeader);
        this.start(this.idxLeader);
        zk = this.getClient(this.idxFollower);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        Assertions.assertTrue((countCreated > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((countCreated < 50 ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleRollover() throws Exception {
        ZooKeeper zk = this.getClient(this.idxFollower);
        int countCreated = this.createNodes(zk, 0, 10);
        this.adjustEpochNearEnd();
        countCreated += this.createNodes(zk, countCreated, 10);
        this.adjustEpochNearEnd();
        countCreated += this.createNodes(zk, countCreated, 10);
        this.adjustEpochNearEnd();
        countCreated += this.createNodes(zk, countCreated, 10);
        this.adjustEpochNearEnd();
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdownAll();
        this.startAll();
        zk = this.getClient(this.idxFollower);
        this.adjustEpochNearEnd();
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        this.shutdown(this.idxLeader);
        this.start(this.idxLeader);
        zk = this.getClient(this.idxFollower);
        this.checkNodes(zk, 0, countCreated);
        countCreated += this.createNodes(zk, countCreated, 10);
        Assertions.assertTrue((countCreated > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((countCreated < 70 ? 1 : 0) != 0);
    }
}

