/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.server.EphemeralType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EphemeralTypeTest {
    @BeforeEach
    public void setUp() {
        System.setProperty("zookeeper.extendedTypesEnabled", "true");
    }

    @AfterEach
    public void tearDown() {
        System.clearProperty("zookeeper.extendedTypesEnabled");
    }

    @Test
    public void testTtls() {
        long[] ttls;
        for (long ttl : ttls = new long[]{100L, 1L, EphemeralType.TTL.maxValue()}) {
            long ephemeralOwner = EphemeralType.TTL.toEphemeralOwner(ttl);
            Assertions.assertEquals((Object)EphemeralType.TTL, (Object)EphemeralType.get((long)ephemeralOwner));
            Assertions.assertEquals((long)ttl, (long)EphemeralType.TTL.getValue(ephemeralOwner));
        }
        EphemeralType.validateTTL((CreateMode)CreateMode.PERSISTENT_WITH_TTL, (long)100L);
        EphemeralType.validateTTL((CreateMode)CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL, (long)100L);
        try {
            EphemeralType.validateTTL((CreateMode)CreateMode.EPHEMERAL, (long)100L);
            Assertions.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testContainerValue() {
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)Long.MIN_VALUE);
        Assertions.assertEquals((Object)EphemeralType.CONTAINER, (Object)EphemeralType.get((long)Long.MIN_VALUE));
    }

    @Test
    public void testNonSpecial() {
        Assertions.assertEquals((Object)EphemeralType.VOID, (Object)EphemeralType.get((long)0L));
        Assertions.assertEquals((Object)EphemeralType.NORMAL, (Object)EphemeralType.get((long)1L));
        Assertions.assertEquals((Object)EphemeralType.NORMAL, (Object)EphemeralType.get((long)Long.MAX_VALUE));
    }

    @Test
    public void testServerIds() {
        int i = 0;
        while ((long)i <= 254L) {
            EphemeralType.validateServerId((long)i);
            ++i;
        }
        try {
            EphemeralType.validateServerId((long)255L);
            Assertions.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testEphemeralOwner_extendedFeature_TTL() {
        MatcherAssert.assertThat((Object)EphemeralType.get((long)-72057594037927936L), (Matcher)CoreMatchers.equalTo((Object)EphemeralType.TTL));
    }

    @Test
    public void testEphemeralOwner_extendedFeature_extendedTypeUnsupported() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EphemeralType.get((long)-72056494526300160L));
    }
}

