/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.spel;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.language.spel.RootObject;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.RegistryBeanResolver;
import org.apache.camel.support.ExpressionSupport;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;
    private final BeanResolver beanResolver;
    private final SpelExpressionParser expressionParser;
    private volatile org.springframework.expression.Expression expression;

    public SpelExpression(String expressionString, Class<?> type) {
        this(expressionString, type, null);
    }

    public SpelExpression(String expressionString, Class<?> type, BeanResolver beanResolver) {
        this.expressionString = expressionString;
        this.type = type;
        this.beanResolver = beanResolver;
        this.expressionParser = new SpelExpressionParser();
    }

    public static SpelExpression spel(String expression) {
        return new SpelExpression(expression, Object.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> tClass) {
        if (this.expression == null) {
            this.init(exchange.getContext());
        }
        try {
            EvaluationContext evaluationContext = this.createEvaluationContext(exchange);
            Object value = this.expression.getValue(evaluationContext);
            return (T)exchange.getContext().getTypeConverter().convertTo(tClass, value);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    private EvaluationContext createEvaluationContext(Exchange exchange) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext((Object)new RootObject(exchange));
        evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        if (this.beanResolver != null) {
            evaluationContext.setBeanResolver(this.beanResolver);
        } else if (exchange.getContext() instanceof SpringCamelContext) {
            ApplicationContext applicationContext = ((SpringCamelContext)exchange.getContext()).getApplicationContext();
            evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        } else {
            evaluationContext.setBeanResolver((BeanResolver)new RegistryBeanResolver(exchange.getContext().getRegistry()));
        }
        return evaluationContext;
    }

    private org.springframework.expression.Expression parseExpression() {
        TemplateParserContext parserContext = new TemplateParserContext();
        return this.expressionParser.parseExpression(this.expressionString, (ParserContext)parserContext);
    }

    public Class<?> getType() {
        return this.type;
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }

    public void init(CamelContext context) {
        this.expression = this.parseExpression();
    }

    public String toString() {
        return "SpelExpression[" + this.expressionString + "]";
    }
}

