/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.MessageAvailableConsumer;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClient
implements HttpSessionActivationListener,
HttpSessionBindingListener,
Externalizable {
    public static final String WEB_CLIENT_ATTRIBUTE = "org.apache.activemq.webclient";
    public static final String CONNECTION_FACTORY_ATTRIBUTE = "org.apache.activemq.connectionFactory";
    public static final String CONNECTION_FACTORY_PREFETCH_PARAM = "org.apache.activemq.connectionFactory.prefetch";
    public static final String CONNECTION_FACTORY_OPTIMIZE_ACK_PARAM = "org.apache.activemq.connectionFactory.optimizeAck";
    public static final String BROKER_URL_INIT_PARAM = "org.apache.activemq.brokerURL";
    public static final String USERNAME_INIT_PARAM = "org.apache.activemq.username";
    public static final String PASSWORD_INIT_PARAM = "org.apache.activemq.password";
    public static final String SELECTOR_NAME = "org.apache.activemq.selectorName";
    private static final Logger LOG = LoggerFactory.getLogger(WebClient.class);
    private static transient ActiveMQConnectionFactory factory;
    private transient Map<Destination, MessageConsumer> consumers = new HashMap<Destination, MessageConsumer>();
    private transient Connection connection;
    private transient Session session;
    private transient MessageProducer producer;
    private int deliveryMode = 1;
    public static String selectorName;
    private final Semaphore semaphore = new Semaphore(1);
    private String username;
    private String password;

    public WebClient() {
        if (factory == null) {
            throw new IllegalStateException("initContext(ServletContext) not called");
        }
    }

    public static WebClient getWebClient(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        WebClient client = WebClient.getWebClient(session);
        if (client == null || client.isClosed()) {
            client = WebClient.createWebClient(request);
            session.setAttribute(WEB_CLIENT_ATTRIBUTE, (Object)client);
        }
        return client;
    }

    public static WebClient getWebClient(HttpSession session) {
        return (WebClient)session.getAttribute(WEB_CLIENT_ATTRIBUTE);
    }

    public static void initContext(ServletContext context) {
        WebClient.initConnectionFactory(context);
        context.setAttribute("webClients", new HashMap());
        if (selectorName == null) {
            selectorName = context.getInitParameter(SELECTOR_NAME);
        }
        if (selectorName == null) {
            selectorName = "selector";
        }
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public synchronized void closeConsumers() {
        Iterator<MessageConsumer> it = this.consumers.values().iterator();
        while (it.hasNext()) {
            MessageConsumer consumer = it.next();
            it.remove();
            try {
                consumer.setMessageListener(null);
                if (consumer instanceof MessageAvailableConsumer) {
                    ((MessageAvailableConsumer)consumer).setAvailableListener(null);
                }
                consumer.close();
            }
            catch (JMSException e) {
                LOG.debug("caught exception closing consumer", (Throwable)e);
            }
        }
    }

    public synchronized void close() {
        try {
            if (this.consumers != null) {
                this.closeConsumers();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            LOG.debug("caught exception closing consumer", (Throwable)e);
        }
        finally {
            this.producer = null;
            this.session = null;
            this.connection = null;
            if (this.consumers != null) {
                this.consumers.clear();
            }
            this.consumers = null;
        }
    }

    public boolean isClosed() {
        return this.consumers == null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.consumers != null) {
            out.write(this.consumers.size());
            Iterator<Destination> i = this.consumers.keySet().iterator();
            while (i.hasNext()) {
                out.writeObject(i.next().toString());
            }
        } else {
            out.write(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size >= 0) {
            this.consumers = new HashMap<Destination, MessageConsumer>();
            for (int i = 0; i < size; ++i) {
                String destinationName = in.readObject().toString();
                try {
                    Topic destination = destinationName.startsWith("topic://") ? this.getSession().createTopic(destinationName) : this.getSession().createQueue(destinationName);
                    this.consumers.put((Destination)destination, this.getConsumer((Destination)destination, null, true));
                    continue;
                }
                catch (JMSException e) {
                    LOG.debug("Caought Exception ", (Throwable)e);
                    IOException ex = new IOException(e.getMessage());
                    ex.initCause(e.getCause() != null ? e.getCause() : e);
                    throw ex;
                }
            }
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.getProducer().send(destination, message);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sent! to destination: " + String.valueOf(destination) + " message: " + String.valueOf(message));
        }
    }

    public void send(Destination destination, Message message, boolean persistent, int priority, long timeToLive) throws JMSException {
        int deliveryMode = persistent ? 2 : 1;
        this.getProducer().send(destination, message, deliveryMode, priority, timeToLive);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sent! to destination: " + String.valueOf(destination) + " message: " + String.valueOf(message));
        }
    }

    public Session getSession() throws JMSException {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public Connection getConnection() throws JMSException {
        if (this.connection == null) {
            this.connection = this.username != null && this.password != null ? factory.createConnection(this.username, this.password) : factory.createConnection();
            this.connection.start();
        }
        return this.connection;
    }

    protected static synchronized void initConnectionFactory(ServletContext servletContext) {
        if (factory == null) {
            factory = (ActiveMQConnectionFactory)servletContext.getAttribute(CONNECTION_FACTORY_ATTRIBUTE);
        }
        if (factory == null) {
            Object brokerURL = WebClient.getInitParameter(servletContext, BROKER_URL_INIT_PARAM);
            if (brokerURL == null) {
                LOG.debug("Couldn't find org.apache.activemq.brokerURL param, trying to find a broker embedded in a local VM");
                BrokerService broker = BrokerRegistry.getInstance().findFirst();
                if (broker == null) {
                    throw new IllegalStateException("missing brokerURL (specified via org.apache.activemq.brokerURL init-Param) or embedded broker");
                }
                brokerURL = "vm://" + broker.getBrokerName();
            }
            LOG.debug("Using broker URL: " + (String)brokerURL);
            String username = WebClient.getInitParameter(servletContext, USERNAME_INIT_PARAM);
            String password = WebClient.getInitParameter(servletContext, PASSWORD_INIT_PARAM);
            ActiveMQConnectionFactory amqfactory = new ActiveMQConnectionFactory(username, password, (String)brokerURL);
            if (servletContext.getInitParameter(CONNECTION_FACTORY_PREFETCH_PARAM) != null) {
                int prefetch = Integer.valueOf(WebClient.getInitParameter(servletContext, CONNECTION_FACTORY_PREFETCH_PARAM));
                amqfactory.getPrefetchPolicy().setAll(prefetch);
            }
            if (servletContext.getInitParameter(CONNECTION_FACTORY_OPTIMIZE_ACK_PARAM) != null) {
                boolean optimizeAck = Boolean.valueOf(WebClient.getInitParameter(servletContext, CONNECTION_FACTORY_OPTIMIZE_ACK_PARAM));
                amqfactory.setOptimizeAcknowledge(optimizeAck);
            }
            factory = amqfactory;
            servletContext.setAttribute(CONNECTION_FACTORY_ATTRIBUTE, (Object)factory);
        }
    }

    private static String getInitParameter(ServletContext servletContext, String initParam) {
        String result = servletContext.getInitParameter(initParam);
        if (result != null && result.startsWith("${") && result.endsWith("}")) {
            result = System.getProperty(result.substring(2, result.length() - 1));
        }
        return result;
    }

    public synchronized MessageProducer getProducer() throws JMSException {
        if (this.producer == null) {
            this.producer = this.getSession().createProducer(null);
            this.producer.setDeliveryMode(this.deliveryMode);
        }
        return this.producer;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public synchronized MessageConsumer getConsumer(Destination destination, String selector) throws JMSException {
        return this.getConsumer(destination, selector, true);
    }

    public synchronized MessageConsumer getConsumer(Destination destination, String selector, boolean create) throws JMSException {
        MessageConsumer consumer = this.consumers.get(destination);
        if (create && consumer == null) {
            consumer = this.getSession().createConsumer(destination, selector);
            this.consumers.put(destination, consumer);
        }
        return consumer;
    }

    public synchronized void closeConsumer(Destination destination) throws JMSException {
        MessageConsumer consumer = this.consumers.get(destination);
        if (consumer != null) {
            this.consumers.remove(destination);
            consumer.setMessageListener(null);
            if (consumer instanceof MessageAvailableConsumer) {
                ((MessageAvailableConsumer)consumer).setAvailableListener(null);
            }
            consumer.close();
        }
    }

    public synchronized List<MessageConsumer> getConsumers() {
        return new ArrayList<MessageConsumer>(this.consumers.values());
    }

    protected Session createSession() throws JMSException {
        return this.getConnection().createSession(false, 1);
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        this.close();
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.close();
    }

    protected static WebClient createWebClient(HttpServletRequest request) {
        String[] tokens;
        WebClient client = new WebClient();
        String auth = request.getHeader("Authorization");
        if (factory.getUserName() == null && factory.getPassword() == null && auth != null && (tokens = auth.split(" ")).length == 2) {
            String encoded = tokens[1].trim();
            String credentials = new String(Base64.getDecoder().decode(encoded));
            String[] creds = credentials.split(":");
            if (creds.length == 2) {
                client.setUsername(creds[0]);
                client.setPassword(creds[1]);
            }
        }
        return client;
    }
}

