/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOSupplier;

public abstract class AcceptDocs {
    public abstract Bits bits() throws IOException;

    public abstract DocIdSetIterator iterator() throws IOException;

    public abstract int cost() throws IOException;

    public static AcceptDocs fromLiveDocs(Bits bits, int maxDoc) {
        return new BitsAcceptDocs(bits, maxDoc);
    }

    public static AcceptDocs fromIteratorSupplier(IOSupplier<DocIdSetIterator> iteratorSupplier, Bits liveDocs, int maxDoc) {
        return new DocIdSetIteratorAcceptDocs(iteratorSupplier, liveDocs, maxDoc);
    }

    private static BitSet createBitSet(DocIdSetIterator iterator, Bits liveDocs, int maxDoc) throws IOException {
        if (liveDocs == null && iterator instanceof BitSetIterator) {
            BitSetIterator bitSetIterator = (BitSetIterator)iterator;
            return bitSetIterator.getBitSet();
        }
        int threshold = maxDoc >> 7;
        if (iterator.cost() >= (long)threshold) {
            FixedBitSet bitSet = new FixedBitSet(maxDoc);
            bitSet.or(iterator);
            if (liveDocs != null) {
                liveDocs.applyMask(bitSet, 0);
            }
            return bitSet;
        }
        return BitSet.of(AcceptDocs.getFilteredDocIdSetIterator(iterator, liveDocs), maxDoc);
    }

    private static DocIdSetIterator getFilteredDocIdSetIterator(DocIdSetIterator iterator, final Bits liveDocs) {
        if (liveDocs != null) {
            iterator = new FilteredDocIdSetIterator(iterator){

                @Override
                protected boolean match(int doc) {
                    return liveDocs.get(doc);
                }
            };
        }
        return iterator;
    }

    private static class BitsAcceptDocs
    extends AcceptDocs {
        private final Bits bits;
        private final int maxDoc;

        BitsAcceptDocs(Bits bits, int maxDoc) {
            if (bits != null && bits.length() != maxDoc) {
                throw new IllegalArgumentException("Bits length = " + bits.length() + " != maxDoc = " + maxDoc);
            }
            this.bits = bits;
            if (bits instanceof BitSet) {
                BitSet bitSet = (BitSet)bits;
                this.maxDoc = Objects.requireNonNull(bitSet).cardinality();
            } else {
                this.maxDoc = maxDoc;
            }
        }

        @Override
        public Bits bits() {
            return this.bits;
        }

        @Override
        public DocIdSetIterator iterator() {
            Bits bits = this.bits;
            if (bits instanceof BitSet) {
                BitSet bitSet = (BitSet)bits;
                return new BitSetIterator(bitSet, this.maxDoc);
            }
            return AcceptDocs.getFilteredDocIdSetIterator(DocIdSetIterator.all(this.maxDoc), this.bits);
        }

        @Override
        public int cost() {
            return this.maxDoc;
        }
    }

    private static class DocIdSetIteratorAcceptDocs
    extends AcceptDocs {
        private final IOSupplier<DocIdSetIterator> iteratorSupplier;
        private final Bits liveDocs;
        private final int maxDoc;
        private BitSet acceptBitSet;
        private int cardinality;

        DocIdSetIteratorAcceptDocs(IOSupplier<DocIdSetIterator> iteratorSupplier, Bits liveDocs, int maxDoc) {
            this.iteratorSupplier = Objects.requireNonNull(iteratorSupplier);
            this.liveDocs = liveDocs;
            this.maxDoc = maxDoc;
        }

        private void createBitSetAcceptDocsIfNecessary() throws IOException {
            if (this.acceptBitSet == null) {
                this.acceptBitSet = Objects.requireNonNull(AcceptDocs.createBitSet(this.iterator(), this.liveDocs, this.maxDoc));
                this.cardinality = this.acceptBitSet.cardinality();
            }
        }

        @Override
        public Bits bits() throws IOException {
            this.createBitSetAcceptDocsIfNecessary();
            return this.acceptBitSet;
        }

        @Override
        public int cost() throws IOException {
            this.createBitSetAcceptDocsIfNecessary();
            return this.acceptBitSet.cardinality();
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            if (this.acceptBitSet != null) {
                return new BitSetIterator(this.acceptBitSet, this.cardinality);
            }
            DocIdSetIterator iterator = Objects.requireNonNull(this.iteratorSupplier.get());
            return AcceptDocs.getFilteredDocIdSetIterator(iterator, this.liveDocs);
        }
    }
}

