/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.PGNotification;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.Logger;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.Utils;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.jdbc2.AbstractJdbc2Statement;
import org.postgresql.jdbc2.TimestampUtils;
import org.postgresql.jdbc2.TypeInfoCache;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Connection
implements BaseConnection {
    private static int nextConnectionID = 1;
    private final Logger logger;
    private final String creatingURL;
    private Throwable openStackTrace;
    private final ProtocolConnection protoConnection;
    private final String compatible;
    private final String dbVersionNumber;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private TypeInfoCache _typeCache;
    protected int prepareThreshold;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public final boolean bindStringAsVarchar;
    public SQLWarning firstWarning = null;
    private final TimestampUtils timestampUtils;
    protected Map typemap;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    protected DatabaseMetaData metadata;

    @Override
    public abstract DatabaseMetaData getMetaData() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractJdbc2Connection(String host, int port, String user, String database, Properties info, String url) throws SQLException {
        this.creatingURL = url;
        int logLevel = Driver.getLogLevel();
        String connectionLogLevel = info.getProperty("loglevel");
        if (connectionLogLevel != null) {
            try {
                logLevel = Integer.parseInt(connectionLogLevel);
            }
            catch (Exception l_e) {
                // empty catch block
            }
        }
        Class<AbstractJdbc2Connection> l_e = AbstractJdbc2Connection.class;
        synchronized (AbstractJdbc2Connection.class) {
            String stringType;
            this.logger = new Logger(nextConnectionID++);
            this.logger.setLogLevel(logLevel);
            // ** MonitorExit[l_e] (shouldn't be in output)
            if (logLevel > 0) {
                this.enableDriverManagerLogging();
            }
            this.prepareThreshold = 5;
            try {
                this.prepareThreshold = Integer.parseInt(info.getProperty("prepareThreshold", "5"));
                if (this.prepareThreshold < 0) {
                    this.prepareThreshold = 0;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.logger.logInfo()) {
                this.logger.info(Driver.getVersion());
            }
            this.protoConnection = ConnectionFactory.openConnection(host, port, user, database, info, this.logger);
            this.dbVersionNumber = this.protoConnection.getServerVersion();
            this.compatible = info.getProperty("compatible", "8.3");
            if (this.logger.logDebug()) {
                this.logger.debug("    compatible = " + this.compatible);
                this.logger.debug("    loglevel = " + logLevel);
                this.logger.debug("    prepare threshold = " + this.prepareThreshold);
            }
            if ((stringType = info.getProperty("stringtype")) != null) {
                if (stringType.equalsIgnoreCase("unspecified")) {
                    this.bindStringAsVarchar = false;
                } else {
                    if (!stringType.equalsIgnoreCase("varchar")) throw new PSQLException(GT.tr("Unsupported value for stringtype parameter: {0}", stringType), PSQLState.INVALID_PARAMETER_VALUE);
                    this.bindStringAsVarchar = true;
                }
            } else {
                this.bindStringAsVarchar = this.haveMinimumCompatibleVersion("8.0");
            }
            this.timestampUtils = new TimestampUtils(this.haveMinimumServerVersion("7.4"), this.haveMinimumServerVersion("8.2"));
            this.commitQuery = this.getQueryExecutor().createSimpleQuery("COMMIT");
            this.rollbackQuery = this.getQueryExecutor().createSimpleQuery("ROLLBACK");
            this._typeCache = new TypeInfoCache(this);
            this.initObjectTypes(info);
            if (!Boolean.valueOf(info.getProperty("logUnclosedConnections")).booleanValue()) return;
            this.openStackTrace = new Throwable("Connection was created at this point:");
            this.enableDriverManagerLogging();
            return;
        }
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    public Map getTypeMap() throws SQLException {
        return this.typemap;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.protoConnection.getQueryExecutor();
    }

    public void addWarning(SQLWarning warn) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(warn);
        } else {
            this.firstWarning = warn;
        }
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        return this.execSQLQuery(s, 1003, 1007);
    }

    @Override
    public ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseStatement stat = (BaseStatement)this.createStatement(resultSetType, resultSetConcurrency);
        boolean hasResultSet = stat.executeWithFlags(s, 16);
        while (!hasResultSet && stat.getUpdateCount() != -1) {
            hasResultSet = stat.getMoreResults();
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        SQLWarning warnings = stat.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        return stat.getResultSet();
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        BaseStatement stmt = (BaseStatement)this.createStatement();
        if (stmt.executeWithFlags(s, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        stmt.close();
    }

    public void setCursorName(String cursor) throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.protoConnection.getUser();
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    @Override
    public Object getObject(String type, String value) throws SQLException {
        Class c;
        if (this.typemap != null && (c = (Class)this.typemap.get(type)) != null) {
            throw new PSQLException(GT.tr("Custom type maps are not supported."), PSQLState.NOT_IMPLEMENTED);
        }
        PGobject obj = null;
        if (this.logger.logDebug()) {
            this.logger.debug("Constructing object from type=" + type + " value=<" + value + ">");
        }
        try {
            Class klass = this._typeCache.getPGobject(type);
            if (klass != null) {
                obj = (PGobject)klass.newInstance();
                obj.setType(type);
                obj.setValue(value);
            } else {
                obj = new PGobject();
                obj.setType(type);
                obj.setValue(value);
            }
            return obj;
        }
        catch (SQLException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Failed to create object for: {0}.", type), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    @Override
    public void addDataType(String type, String name) {
        try {
            this.addDataType(type, Class.forName(name));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register new type: " + e);
        }
    }

    @Override
    public void addDataType(String type, Class klass) throws SQLException {
        this._typeCache.addDataType(type, klass);
    }

    private void initObjectTypes(Properties info) throws SQLException {
        this.addDataType("box", PGbox.class);
        this.addDataType("circle", PGcircle.class);
        this.addDataType("line", PGline.class);
        this.addDataType("lseg", PGlseg.class);
        this.addDataType("path", PGpath.class);
        this.addDataType("point", PGpoint.class);
        this.addDataType("polygon", PGpolygon.class);
        this.addDataType("money", PGmoney.class);
        this.addDataType("interval", PGInterval.class);
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            Class<?> klass;
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith("datatype.")) continue;
            String typeName = propertyName.substring(9);
            String className = info.getProperty(propertyName);
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PSQLException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", new Object[]{className, typeName}), PSQLState.SYSTEM_ERROR, (Throwable)cnfe);
            }
            this.addDataType(typeName, klass);
        }
    }

    @Override
    public void close() {
        this.protoConnection.close();
        this.openStackTrace = null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        StringBuffer buf = new StringBuffer(sql.length());
        AbstractJdbc2Statement.parseSql(sql, 0, buf, false, this.getStandardConformingStrings());
        return buf.toString();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        SQLWarning newWarnings = this.protoConnection.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = newWarnings;
        } else {
            this.firstWarning.setNextWarning(newWarnings);
        }
        return this.firstWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.protoConnection.getWarnings();
        this.firstWarning = null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (this.haveMinimumServerVersion("7.4") && readOnly != this.readOnly) {
            String readOnlySql = "SET SESSION CHARACTERISTICS AS TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE");
            this.execSQLUpdate(readOnlySql);
        }
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        this.getQueryExecutor().execute(query, null, (ResultHandler)new TransactionCommandHandler(), 0, 0, 22);
    }

    @Override
    public void commit() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.rollbackQuery);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        String level = null;
        if (this.haveMinimumServerVersion("7.3")) {
            ResultSet rs = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
            if (rs.next()) {
                level = rs.getString(1);
            }
            rs.close();
        } else {
            SQLWarning saveWarnings = this.getWarnings();
            this.clearWarnings();
            this.execSQLUpdate("SHOW TRANSACTION ISOLATION LEVEL");
            SQLWarning warning = this.getWarnings();
            if (warning != null) {
                level = warning.getMessage();
            }
            this.clearWarnings();
            if (saveWarnings != null) {
                this.addWarning(saveWarnings);
            }
        }
        if (level == null) {
            return 2;
        }
        if ((level = level.toUpperCase()).indexOf("READ COMMITTED") != -1) {
            return 2;
        }
        if (level.indexOf("READ UNCOMMITTED") != -1) {
            return 1;
        }
        if (level.indexOf("REPEATABLE READ") != -1) {
            return 4;
        }
        if (level.indexOf("SERIALIZABLE") != -1) {
            return 8;
        }
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String isolationLevelName = this.getIsolationLevelName(level);
        if (isolationLevelName == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", new Integer(level)), PSQLState.NOT_IMPLEMENTED);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
    }

    protected String getIsolationLevelName(int level) {
        boolean pg80 = this.haveMinimumServerVersion("8.0");
        if (level == 2) {
            return "READ COMMITTED";
        }
        if (level == 8) {
            return "SERIALIZABLE";
        }
        if (pg80 && level == 1) {
            return "READ UNCOMMITTED";
        }
        if (pg80 && level == 4) {
            return "REPEATABLE READ";
        }
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.protoConnection.getDatabase();
    }

    protected void finalize() throws Throwable {
        if (this.openStackTrace != null) {
            this.logger.log(GT.tr("Finalizing a Connection that was never closed:"), this.openStackTrace);
        }
        this.close();
    }

    public String getDBVersionNumber() {
        return this.dbVersionNumber;
    }

    private static int integerPart(String dirtyString) {
        int end;
        int start;
        for (start = 0; start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start)); ++start) {
        }
        for (end = start; end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end)); ++end) {
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            versionTokens.nextToken();
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    @Override
    public boolean haveMinimumServerVersion(String ver) {
        return this.dbVersionNumber.compareTo(ver) >= 0;
    }

    @Override
    public boolean haveMinimumCompatibleVersion(String ver) {
        return this.compatible.compareTo(ver) >= 0;
    }

    @Override
    public Encoding getEncoding() {
        return this.protoConnection.getEncoding();
    }

    @Override
    public byte[] encodeString(String str) throws SQLException {
        try {
            return this.getEncoding().encode(str);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding."), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return Utils.appendEscapedLiteral(null, str, this.protoConnection.getStandardConformingStrings()).toString();
    }

    @Override
    public boolean getStandardConformingStrings() {
        return this.protoConnection.getStandardConformingStrings();
    }

    @Override
    public int getSQLType(int oid) throws SQLException {
        return this._typeCache.getSQLType(oid);
    }

    public Iterator getPGTypeNamesWithSQLTypes() {
        return this._typeCache.getPGTypeNamesWithSQLTypes();
    }

    @Override
    public int getPGType(String typeName) throws SQLException {
        return this._typeCache.getPGType(typeName);
    }

    public int getPGArrayType(String elementTypeName) throws SQLException {
        elementTypeName = TypeInfoCache.getTypeForAlias(elementTypeName);
        return this.getPGType("_" + elementTypeName);
    }

    @Override
    public String getJavaClass(int oid) throws SQLException {
        return this._typeCache.getJavaClass(oid);
    }

    @Override
    public String getPGType(int oid) throws SQLException {
        return this._typeCache.getPGType(oid);
    }

    @Override
    public int getPGArrayElement(int oid) throws SQLException {
        return this._typeCache.getPGArrayElement(oid);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.protoConnection.isClosed();
    }

    @Override
    public void cancelQuery() throws SQLException {
        this.protoConnection.sendQueryCancel();
    }

    @Override
    public PGNotification[] getNotifications() throws SQLException {
        PGNotification[] notifications = this.protoConnection.getNotifications();
        return notifications.length == 0 ? null : notifications;
    }

    @Override
    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    @Override
    public void setPrepareThreshold(int newThreshold) {
        this.prepareThreshold = newThreshold <= 0 ? 0 : newThreshold;
    }

    public void setTypeMapImpl(Map map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogWriter() == null) {
            DriverManager.setLogWriter(new PrintWriter(System.out, true));
        }
    }

    @Override
    public int getSQLType(String pgTypeName) throws SQLException {
        return this._typeCache.getSQLType(pgTypeName);
    }

    public int getProtocolVersion() {
        return this.protoConnection.getProtocolVersion();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    private class TransactionCommandHandler
    implements ResultHandler {
        private SQLException error;

        private TransactionCommandHandler() {
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Connection.this.addWarning(warning);
        }

        @Override
        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        @Override
        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

