/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes
#include <functional>
#include <unordered_map>


/////////////////////// Qt includes
#include <QMap>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMassCore includes


/////////////////////// libXpertMassGUI includes
#include "MsXpS/libXpertMassGui/JavaScriptQObjectExposureRecord.hpp"


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

namespace MsXpS
{
namespace libXpertMassGui
{


class DECLSPEC JavaScriptQObjectExposureRegistry: public QObject
{
  Q_OBJECT

  public:
  JavaScriptQObjectExposureRegistry(QObject *parent = nullptr);
  virtual ~JavaScriptQObjectExposureRegistry();

  int registerQObject(QObject *object_p,
                      QObject *object_parent_p,
                      const QString &object_name,
                      const QString &object_alias,
                      const QString &object_decription);

  int unregisterQObject(QObject *object_p);

  JavaScriptQObjectExposureRecordQSPtr getRecordByObject(QObject *object_p);

  JavaScriptQObjectExposureRecordQSPtr
  getRecordByObjectParent(QObject *object_p);

  JavaScriptQObjectExposureRecordQSPtr
  getRecordByName(const QString object_name);

  JavaScriptQObjectExposureRecordQSPtr
  getRecordByAlias(const QString object_alias);

  protected:
  QList<JavaScriptQObjectExposureRecordQSPtr> m_records;
};

} // namespace libXpertMassGui
} // namespace MsXpS
