/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SW_INC_SHELLID_HXX
#define INCLUDED_SW_INC_SHELLID_HXX

#include <sfx2/shell.hxx>

// Mapping for UI-parameters

#define SW_BASESHELL            (SFX_INTERFACE_SW_START + SfxInterfaceId(1))
#define SW_TEXTSHELL            (SFX_INTERFACE_SW_START + SfxInterfaceId(2))
#define SW_LISTSHELL            (SFX_INTERFACE_SW_START + SfxInterfaceId(3))
#define SW_TABSHELL             (SFX_INTERFACE_SW_START + SfxInterfaceId(4))
#define SW_FRAMESHELL           (SFX_INTERFACE_SW_START + SfxInterfaceId(5))
#define SW_GRFSHELL             (SFX_INTERFACE_SW_START + SfxInterfaceId(6))
#define SW_OLESHELL             (SFX_INTERFACE_SW_START + SfxInterfaceId(7))
#define SW_DRAWSHELL            (SFX_INTERFACE_SW_START + SfxInterfaceId(8))
#define SW_DRWTXTSHELL          (SFX_INTERFACE_SW_START + SfxInterfaceId(9))

#define SW_INTERFACE_MODULE     (SFX_INTERFACE_SW_START + SfxInterfaceId(10))
#define SW_DOCSHELL             (SFX_INTERFACE_SW_START + SfxInterfaceId(11))
#define SW_VIEWSHELL            (SFX_INTERFACE_SW_START + SfxInterfaceId(12))
#define SW_PAGEPREVIEW          (SFX_INTERFACE_SW_START + SfxInterfaceId(13))
#define SW_GLOSDOCSHELL         (SFX_INTERFACE_SW_START + SfxInterfaceId(14))
#define SW_SRC_VIEWSHELL        (SFX_INTERFACE_SW_START + SfxInterfaceId(15))

#define SW_BEZIERSHELL          (SFX_INTERFACE_SW_START + SfxInterfaceId(16))
#define SW_DRAWBASESHELL        (SFX_INTERFACE_SW_START + SfxInterfaceId(17))
#define SW_DRAWFORMSHELL        (SFX_INTERFACE_SW_START + SfxInterfaceId(18))

#define SW_WEBDOCSHELL          (SFX_INTERFACE_SW_START + SfxInterfaceId(19))
#define SW_WEBVIEWSHELL         (SFX_INTERFACE_SW_START + SfxInterfaceId(20))
#define SW_WEBBASESHELL         (SFX_INTERFACE_SW_START + SfxInterfaceId(21))
#define SW_WEBTEXTSHELL         (SFX_INTERFACE_SW_START + SfxInterfaceId(22))
#define SW_WEBFRAMESHELL        (SFX_INTERFACE_SW_START + SfxInterfaceId(23))
#define SW_WEBGLOSDOCSHELL      (SFX_INTERFACE_SW_START + SfxInterfaceId(24))
#define SW_WEBLISTSHELL         (SFX_INTERFACE_SW_START + SfxInterfaceId(25))
#define SW_WEBTABSHELL          (SFX_INTERFACE_SW_START + SfxInterfaceId(26))
#define SW_WEBGRFSHELL          (SFX_INTERFACE_SW_START + SfxInterfaceId(27))
#define SW_WEBOLESHELL          (SFX_INTERFACE_SW_START + SfxInterfaceId(28))
#define SW_WEBDRAWBASESHELL     (SFX_INTERFACE_SW_START + SfxInterfaceId(29))
#define SW_WEBDRAWFORMSHELL     (SFX_INTERFACE_SW_START + SfxInterfaceId(30))

#define SW_MEDIASHELL           (SFX_INTERFACE_SW_START + SfxInterfaceId(31))
#define SW_ANNOTATIONSHELL      (SFX_INTERFACE_SW_START + SfxInterfaceId(32))

#define SW_NAVIGATIONSHELL      (SFX_INTERFACE_SW_START + SfxInterfaceId(33))
#endif // _UIPARAM_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
