/*
 * SPDX-FileCopyrightText: 2020 Mikhail Zolotukhin <zomial@protonmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
 */

#include "standarddecorationpainter.h"

StandardDecorationPainter::StandardDecorationPainter(const QString &pluginName)
    : DecorationPainter()
    , m_bridge(new KDecoration3::DummyDecorationBridge(pluginName))
{
}

void StandardDecorationPainter::paintButton(QPainter &painter, const QString &buttonType, const QString &buttonState) const
{
    m_bridge->paintButton(painter, buttonType, buttonState);
}
