# ClamAV

ClamAV® is an open source antivirus engine for detecting trojans, viruses,
malware & other malicious threats.

## Documentation & FAQ

Official documentation can be found online at
[ClamAV.net](https://docs.clamav.net/).
Our source code release tarballs also includes a copy of the documentation for
[offline](docs/html/UserManual.html) reading.

## ClamAV Signatures

Anyone can learn to read and write ClamAV signatures. To get started, see our
[signature writing documentation](https://docs.clamav.net/manual/Signatures.html).

## Installation Instructions

### UNIX

#### Build from Source on Linux/Unix/Mac

For basic compile and install instructions on Linux/Unix platforms, check out
the [install instructions](INSTALL.autotools.md).

For detailed instructions specific to building ClamAV please investigate
our the
[Linux/Unix/Mac Install instructions in the User Manual](https://docs.clamav.net/manual/Installing/Installing-from-source-Unix.html).

For instructions on how to build ClamAV using our new *experimental* CMake
build tooling, see [INSTALL.cmake.md](INSTALL.cmake.md)

#### Install from a binary package

For binary package distribution installation instructions, head over to
[our website](https://docs.clamav.net/manual/Installing/Packages.html).

### Windows

#### Build from Source on Windows

The instructions for building ClamAV from source on Windows is located in the
[Win32 README](win32/README.md).

#### Using an Install Package

We provide an installer to install ClamAV on Windows to "C:\\Program Files".
This install method will require you to have Adminstrator priveleges.

We also provide a "Portable Install Package" (i.e. a zip of the required files)
for users that may wish to run ClamAV without installing it to a system-owned
directory.

For details on how to use either option, head over to the
[Windows Install instructions in the User Manual](https://docs.clamav.net/manual/Installing.html).

For instructions on how to build ClamAV using our new *experimental* CMake
build tooling, see [INSTALL.cmake.md](INSTALL.cmake.md)

### Upgrading from a previous version

Some tips on [how to upgrade](https://docs.clamav.net/faq/faq-upgrade.html)
 from a previous version of ClamAV.

## ClamAV News

For information about the features in this and prior releases, read
[the news](NEWS.md).

Catch up on the latest about ClamAV by reading our
[blog](http://blog.clamav.net) and follow us on Twitter @clamav.

## Join the ClamAV Community

The best way to get in touch with the ClamAV community is to join our
[our mailing lists](https://docs.clamav.net/faq/faq-ml.html), and
tune to #clamav on [IRC](irc.freenode.net).

## Want to make a contribution?

The ClamAV development team welcomes
[code contributions](https://github.com/Cisco-Talos/clamav-devel),
improvements to [our documentation](https://github.com/Cisco-Talos/clamav-faq),
and also [bug reports](https://github.com/Cisco-Talos/clamav/issues). Thanks for joining us!

## Credits

[The ClamAV Team](https://www.clamav.net/about.html#credits)
