/* defines.h
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef DEFINES_H
#define DEFINES_H

/* remove this to eliminate the requirement that the user */
/* supply a "-z" to the program to run it.  Make's 'em read */
/* the instructions... */
#define USEZFLAG

/* #define to LOG_LOCAL0 (see /usr/include/syslog.h ) or whatever */
/* FACILITY to get logging other than log_DAEMON (djs) */
#define LOGFAC LOG_DAEMON

/* define to whatever makes sense to you for your system setup */
#define LOGTYPE LOG_WARNING
#define INFOTYPE LOG_INFO

/* don't mess with these, unless you know what you're doing */
#define SWAP(A, B)	((A) ^= (B) ^= (A) ^= (B))
#define ARP_REQUEST  1
#define ARP_REPLY    2
#define MAXARPTIME   60
#define CULLTIME     2400    /* 40 minutes */
#define RANDSIZE1     100
#define RANDSIZE2    12
#define IP_HARDCAPTURED 3
#define IP_HARDEXCLUDE  2
#define IP_EXCLUDE      1
#define IP_NOTHING      0


#ifndef FALSE
#define FALSE   0
#endif

#ifndef TRUE
#define TRUE    1
#endif

#define MYFREE(x) free(x); x = NULL;

#ifdef WIN32
#define CKSUM_CARRY(x) \
    (x = (x >> 16) + (x & 0xffff), (~(x + (x >> 16)) & 0xffff))
#endif

#endif /* DEFINES_H */
