# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test;
BEGIN { plan tests => 1 };
use NCAR;
ok(1); # If we made it this far, we're ok.;

#########################

# Insert your test code below, the Test module is use()ed here so read
# its man page ( perldoc Test ) for help writing this test script.
unlink( 'gmeta' );

use PDL;
use NCAR::Test qw( bndary gendat drawcl );
use strict;
   
#
#	$Id: tconan.f,v 1.4 1995/06/14 14:04:43 haley Exp $
#
#
# Define error file, Fortran unit number, and workstation type,
# and workstation ID.
#
my ( $IERRF, $LUNIT, $IWTYPE, $IWKID ) = ( 6, 2, 1, 1 );
#
# OPEN GKS, OPEN WORKSTATION OF TYPE 1, ACTIVATE WORKSTATION
#
&NCAR::gopks ($IERRF, my $ISZDM);
&NCAR::gopwk ($IWKID, $LUNIT, $IWTYPE);
&NCAR::gacwk ($IWKID);
#
# INVOKE DEMO DRIVER
#
&TCONAN(my $IERR);
#
# DEACTIVATE AND CLOSE WORKSTATION, CLOSE GKS.
#
&NCAR::gdawk ($IWKID);
&NCAR::gclwk ($IWKID);
&NCAR::gclks();
#
#
sub TCONAN {
  my ($IERROR) = @_;
#
# PURPOSE                To provide a simple demonstration of
#                        standard contouring of irregularly spaced
#                        data using the CONRAN package.
#
# USAGE                  CALL TCONAN (IERROR)
#
# ARGUMENTS
#
# ON OUTPUT              IERROR
#                          An integer variable
#                          = 0, if the test was successful,
#                          > 0, the test was not successful,
#                               and the error number corresponds
#                               to the number in the CONRAN listing.
#
# I/O                    If the test is successful, the message
#
#              CONRAN TEST EXECUTED--SEE PLOTS TO CERTIFY
#
#                        is printed on unit 6.  In addition, 2
#                        frames are produced on the machine graphics
#                        device.  The first plot is the contour plot.
#                        The second plot shows the triangulation of the
#                        data.  In order to determine if the test
#                        was successful, it is necessary to examine
#                        the plots.
#
# PRECISION              Single
#
# LANGUAGE               FORTRAN 77
#
# REQUIRED ROUTINES      CONRAN, CONTERP, CONCOM, DASHCHAR
#
# REQUIRED GKS LEVEL     0A
#
# ALGORITHM              A sparse dataset is defined in DATA statements.
#                        Options are selected to produce a plot title
#                        and display the triangulation generated by the
#                        interpolation routines.  Default options
#                        include a message at the bottom of the plot
#                        and a plot perimter.
#
#                        This is the standard version of the CONRAN
#                        family of utilities.
#
#                        The version of the package which produces
#                        smoothed contours is created by simply
#                        loading this package with DASHSMTH rather
#                        than DASHCHAR.
#
#
# Set up the scratch arrays needed by CONRAN.
#
  my $WK = zeroes float, 221;
  my $IWK = zeroes long, 744;
  my $SCR = zeroes float, 1600;
#
# Define the dataset.
#
  my $XD = float [
         3.,3.,10.,18.,18.,10.,10.,5.,1.,15.,20.,
         5.,15.,10.,7.,13.,16. ];
#
  my $YD = float [
         3.,18.,18.,3.,18.,10.,1.,5.,10.,5.,10.,
         15.,15.,15.,20.,20.,8. ];
#
  my $ZD = float [
         25.,25.,25.,25.,25.,-5.,1.,1.,1.,1.,1.,
         1.,1.,1.,1.,1.,25. ];
#
# Define the number of points in the dataset.
#
  my $NDP = 17;
#
# Set the PORT error handling routine to the recover mode.
#
  &NCAR::entsr(my $IROLD,1);
#
# Define the plot title.
#
  &NCAR::conop4('TLE=ON','DEMONSTRATION PLOT FOR CONRAN',29,0);
#
# Test for an error condition.
#
  if( &NCAR::nerro( $IERROR ) != 0 ) { goto L100; }
#
# No error encountered.
#
#
# Set the option to generate the triangulation display.
#
  &NCAR::conop1('TRI=ON');
#
# Again, test for an error condition.
#
  if( &NCAR::nerro( $IERROR ) != 0 ) { goto L100; }
#
# No error encountered.
#
# Call CONRAN to contour the data.
#
  &NCAR::conran($XD,$YD,$ZD,$NDP,$WK,$IWK,$SCR);
#
# Again, test for an error condition.
#
  if( &NCAR::nerro( $IERROR ) != 0 ) { goto L100; }
#
# No error encountered.
#
#
# Advance the frame.  CONRAN does not do so internally.
#
  &NCAR::frame();
#
# Print the successful completion message.
#
  print STDERR "\n CONRAN TEST EXECUTED--SEE PLOTS TO CERTIFY \n";
  return;
#
# If an error was encountered call the PORT error print routine.
# This is only necessary if you are in recover mode, else the message
# is printed automatically.
#
L100:
  &NCAR::eprin();
 
}

rename 'gmeta', 'ncgm/tconan.ncgm';
