/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.wikibrowser;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.TGUIManager;
import com.touchgraph.graphlayout.interaction.ZoomScroll;
import com.touchgraph.wikibrowser.SFSInputStream;
import com.touchgraph.wikibrowser.WikiEdge;
import com.touchgraph.wikibrowser.WikiNavigateUI;
import com.touchgraph.wikibrowser.WikiNode;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ToolTipManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class TGWikiBrowser
extends JPanel {
    TGPanel tgPanel;
    TGLensSet tgLensSet;
    TGUIManager tgUIManager;
    public HVScroll hvScroll;
    public ZoomScroll zoomScroll;
    public JPopupMenu wikiPopup;
    private JTextField tfSearch;
    private JComboBox maxAddCombo;
    private JComboBox maxExpandCombo;
    private JComboBox localityRadiusCombo;
    private JCheckBox showBackLinksCheckBox;
    public JTextPane tpWikiText;
    public String textPaneURL = null;
    protected JButton statusButton;
    private WikiNode nodeMOHL;
    GraphEltSet completeEltSet;
    private Stack browseHistory = new Stack();
    public static String WIKI_URL;
    public static String WIKI_FILE;
    public static String INITIAL_NODE;
    public static int INITIAL_RADIUS;
    public static boolean INITIAL_SHOW_BACKLINKS;

    public TGWikiBrowser() {
        WikiNode wikiNode;
        this.completeEltSet = new GraphEltSet();
        this.tgPanel = new TGPanel();
        this.tgPanel.setGraphEltSet(this.completeEltSet);
        this.tgLensSet = new TGLensSet();
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel);
        this.buildPanel();
        this.buildLens();
        this.tgPanel.setLensSet(this.tgLensSet);
        this.addUIs();
        this.setVisible(true);
        Node.setNodeBackDefaultColor(Color.decode("#A03000"));
        this.zoomScroll.setZoomValue(4);
        try {
            this.getWikiGraph();
        }
        catch (TGException tGException) {
            tGException.printStackTrace();
        }
        if (INITIAL_RADIUS >= 0 && INITIAL_RADIUS <= 6) {
            this.localityRadiusCombo.setSelectedIndex(INITIAL_RADIUS);
        }
        if (INITIAL_SHOW_BACKLINKS) {
            this.showBackLinksCheckBox.setSelected(INITIAL_SHOW_BACKLINKS);
        }
        if ((wikiNode = INITIAL_NODE == null ? (WikiNode)this.completeEltSet.getFirstNode() : (WikiNode)this.completeEltSet.findNodeLabelContaining(INITIAL_NODE)) == null) {
            wikiNode = (WikiNode)this.completeEltSet.getFirstNode();
        }
        this.tgPanel.setSelect(wikiNode);
        this.setLocale(wikiNode);
        this.tgPanel.fastFinishAnimation();
        this.setWikiTextPane(wikiNode);
        this.tgPanel.resetDamper();
    }

    private String generateNodeLabel(String string) {
        if (!string.startsWith("http://")) {
            return string;
        }
        String string2 = string;
        if (string2.length() < 25 && !string.startsWith(WIKI_URL)) {
            String string3 = string2.substring(string2.indexOf("//") + 2);
            if (string3.length() > 40) {
                string3 = string3.substring(0, 40);
            }
            return string3;
        }
        if (string2.indexOf("?") > -1) {
            return string2.substring(string2.indexOf("?") + 1);
        }
        if (string2.lastIndexOf("/") != string2.length() - 1) {
            return string2.substring(string2.lastIndexOf("/") + 1);
        }
        return string2.substring(string2.lastIndexOf("/", string2.length() - 2) + 1, string2.length() - 1);
    }

    private WikiNode addWikiNode(String string) {
        WikiNode wikiNode = new WikiNode(this.generateNodeLabel(string));
        if (!string.startsWith("http://")) {
            wikiNode.setURL(WIKI_URL + string);
        } else {
            wikiNode.setURL(string);
            wikiNode.setBackColor(Color.decode("#802080"));
        }
        try {
            this.completeEltSet.addNode(wikiNode);
        }
        catch (TGException tGException) {
            tGException.printStackTrace();
        }
        return wikiNode;
    }

    public void getWikiGraph() throws TGException {
        Object object;
        String string = "";
        try {
            Object object2;
            if (WIKI_FILE.startsWith("http://")) {
                URLConnection uRLConnection = new URL(WIKI_FILE).openConnection();
                object2 = new SFSInputStream(uRLConnection.getInputStream(), uRLConnection.getContentLength());
                object = new BufferedReader(new InputStreamReader((InputStream)object2));
            } else {
                object = new BufferedReader(new FileReader(WIKI_FILE));
            }
            int n = 0;
            while (string != null) {
                Object object3;
                if (++n % 100 == 0) {
                    System.out.println(n);
                }
                if ((string = ((BufferedReader)object).readLine()) == null || string.trim().length() == 0) continue;
                object2 = new StringTokenizer(string);
                String string2 = ((StringTokenizer)object2).nextToken();
                WikiNode wikiNode = (WikiNode)this.completeEltSet.findNode(this.generateNodeLabel(string2));
                if (wikiNode == null) {
                    wikiNode = this.addWikiNode(string2);
                }
                WikiNode wikiNode2 = null;
                int n2 = 2;
                if (string.indexOf("|") > -1) {
                    wikiNode2 = new WikiNode("1");
                    this.completeEltSet.addNode(wikiNode2);
                    object3 = new WikiEdge(wikiNode, wikiNode2, 20);
                    this.completeEltSet.addEdge((Edge)object3);
                }
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    Edge edge;
                    Object object4;
                    object3 = "";
                    try {
                        object3 = ((StringTokenizer)object2).nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        noSuchElementException.printStackTrace();
                        continue;
                    }
                    if (((String)object3).equals("|")) {
                        wikiNode2 = new WikiNode("" + n2);
                        this.completeEltSet.addNode(wikiNode2);
                        ++n2;
                        object4 = new WikiEdge(wikiNode, wikiNode2, 20);
                        this.completeEltSet.addEdge((Edge)object4);
                        continue;
                    }
                    object4 = (WikiNode)this.completeEltSet.findNode(this.generateNodeLabel((String)object3));
                    if (object4 == null) {
                        object4 = this.addWikiNode((String)object3);
                    }
                    if (wikiNode2 != null) {
                        edge = this.completeEltSet.findEdge(wikiNode2, (Node)object4);
                        if (edge != null) continue;
                        edge = new WikiEdge(wikiNode2, (WikiNode)object4, 40);
                        this.completeEltSet.addEdge(edge);
                        continue;
                    }
                    edge = this.completeEltSet.findEdge(wikiNode, (Node)object4);
                    if (edge != null) continue;
                    edge = new WikiEdge(wikiNode, (WikiNode)object4, 40);
                    this.completeEltSet.addEdge(edge);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = this.completeEltSet.getEdges();
        while (object != null && object.hasNext()) {
            WikiEdge wikiEdge = (WikiEdge)object.next();
            wikiEdge.setLength(10 + (wikiEdge.from.edgeCount() + wikiEdge.to.edgeCount()) + wikiEdge.from.edgeCount() * wikiEdge.to.edgeCount() / 5);
        }
        System.out.println("Nodes: " + this.completeEltSet.nodeCount());
        System.out.println("Edges: " + this.completeEltSet.edgeCount());
    }

    TGWikiBrowser(JFrame jFrame) {
        this();
    }

    public TGPanel getTGPanel() {
        return this.tgPanel;
    }

    public URL getDocumentBase() {
        return null;
    }

    private void buildLens() {
        this.tgLensSet.addLens(this.hvScroll.getLens());
        this.tgLensSet.addLens(this.zoomScroll.getLens());
        this.tgLensSet.addLens(new HorizontalStretchLens());
        this.tgLensSet.addLens(this.tgPanel.getAdjustOriginLens());
    }

    private void buildPanel() {
        final JScrollBar jScrollBar = this.hvScroll.getHorizontalSB();
        final JScrollBar jScrollBar2 = this.hvScroll.getVerticalSB();
        JScrollBar jScrollBar3 = this.zoomScroll.getZoomSB();
        this.setLayout(new BorderLayout());
        ToolTipManager.sharedInstance().setInitialDelay(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        final JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        BackButton backButton = new BackButton();
        backButton.setToolTipText("Go back to previous page / previously selected node");
        backButton.setBackground(Color.decode("#C0C0D8"));
        jPanel2.add((Component)backButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)new Label("Search", 2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.tfSearch = new JTextField();
        this.tfSearch.setToolTipText("Press enter to find node label containing substring");
        jPanel2.add((Component)this.tfSearch, gridBagConstraints);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                WikiNode wikiNode;
                String string = TGWikiBrowser.this.tfSearch.getText();
                if (!string.trim().equals("") && (wikiNode = (WikiNode)TGWikiBrowser.this.tgPanel.findNodeLabelContaining(string)) != null) {
                    TGWikiBrowser.this.setLocale(wikiNode);
                    TGWikiBrowser.this.tgPanel.setSelect(wikiNode);
                    TGWikiBrowser.this.setWikiTextPane(wikiNode);
                }
            }
        };
        this.tfSearch.addActionListener(abstractAction);
        this.maxAddCombo = new JComboBox<String>(new String[]{"25", "30", "35", "40", "50", "60", "100", "200"});
        this.maxExpandCombo = new JComboBox<String>(new String[]{"10", "15", "20", "25", "30", "40", "50", "70", "100"});
        this.localityRadiusCombo = new JComboBox<String>(new String[]{"0", "1", "2", "3", "4", "5", "6"});
        this.maxAddCombo.setSelectedIndex(3);
        this.maxExpandCombo.setSelectedIndex(3);
        this.localityRadiusCombo.setSelectedIndex(2);
        this.maxAddCombo.setToolTipText("Don't show nodes with more E# of edges");
        this.maxExpandCombo.setToolTipText("Don't expand nodes with more then E# of edges");
        this.localityRadiusCombo.setToolTipText("Show nodes reachable by following Radius# edges");
        this.showBackLinksCheckBox = new JCheckBox(" Show BackLinks", false);
        this.showBackLinksCheckBox.setHorizontalTextPosition(2);
        this.showBackLinksCheckBox.setHorizontalAlignment(0);
        this.showBackLinksCheckBox.setToolTipText("BackLinks are hyperlinks on pages linking To the selected page");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TGWikiBrowser.this.setLocale(TGWikiBrowser.this.tgPanel.getSelect());
            }
        };
        this.maxAddCombo.addActionListener(actionListener);
        this.maxExpandCombo.addActionListener(actionListener);
        this.localityRadiusCombo.addActionListener(actionListener);
        this.showBackLinksCheckBox.addActionListener(actionListener);
        this.maxAddCombo.setPreferredSize(new Dimension(50, 20));
        this.maxExpandCombo.setPreferredSize(new Dimension(50, 20));
        this.localityRadiusCombo.setPreferredSize(new Dimension(50, 20));
        this.showBackLinksCheckBox.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new Label("Show E#", 2), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.maxAddCombo, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new Label("Expand E#", 2), gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.maxExpandCombo, gridBagConstraints);
        gridBagConstraints.gridx = 8;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new Label("Radius", 2), gridBagConstraints);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.localityRadiusCombo, gridBagConstraints);
        gridBagConstraints.gridx = 10;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.showBackLinksCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 11;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new Label("Zoom", 2), gridBagConstraints);
        gridBagConstraints.gridx = 12;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)jScrollBar3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        JButton jButton = new JButton("Stop");
        jButton.setToolTipText("Stop graph motion, click twice to stop all motion");
        jButton.setBackground(Color.decode("#D8C0C0"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TGWikiBrowser.this.tgPanel.stopMotion();
                TGWikiBrowser.this.tgPanel.fastFinishAnimation();
            }
        });
        jButton.setPreferredSize(new Dimension(60, 20));
        jButton.setMargin(new Insets(2, 0, 2, 0));
        gridBagConstraints.gridx = 13;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 17);
        JButton jButton2 = new JButton("?");
        jButton2.setToolTipText("Help");
        jButton2.setBackground(Color.decode("#F0F0C0"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TGWikiBrowser.this.tpWikiText.setPage(new File("Quick Instructions.html").toURL());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jButton2.setPreferredSize(new Dimension(20, 20));
        jButton2.setMargin(new Insets(2, 0, 2, 0));
        gridBagConstraints.gridx = 14;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel2, "North");
        JSplitPane jSplitPane = new JSplitPane(1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.tgPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jScrollBar2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jScrollBar, gridBagConstraints);
        jSplitPane.setRightComponent(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.tpWikiText = new JTextPane();
        this.tpWikiText.setEditable(false);
        this.tpWikiText.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                TGWikiBrowser.this.processHyperlinkEvent(hyperlinkEvent);
            }
        });
        this.tpWikiText.setEditorKit(new HTMLEditorKit());
        JScrollPane jScrollPane = new JScrollPane(this.tpWikiText);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.statusButton = new JButton(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BrowserLauncher.openURL((String)TGWikiBrowser.this.textPaneURL);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.statusButton.setToolTipText("Click to show page in external browser");
        this.statusButton.setHorizontalAlignment(2);
        this.statusButton.setMargin(new Insets(2, 0, 2, 0));
        this.statusButton.setCursor(new Cursor(12));
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)this.statusButton, "South");
        jPanel3.setPreferredSize(new Dimension(400, 100));
        jSplitPane.setLeftComponent(jPanel3);
        jSplitPane.setDividerLocation(350);
        jSplitPane.setOneTouchExpandable(true);
        this.add((Component)jSplitPane, "Center");
        this.wikiPopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Toggle Controls");
        ActionListener actionListener2 = new ActionListener(){
            boolean controlsVisible = true;

            public void actionPerformed(ActionEvent actionEvent) {
                this.controlsVisible = !this.controlsVisible;
                jScrollBar.setVisible(this.controlsVisible);
                jScrollBar2.setVisible(this.controlsVisible);
                jPanel2.setVisible(this.controlsVisible);
            }
        };
        jMenuItem.addActionListener(actionListener2);
        this.wikiPopup.add(jMenuItem);
    }

    private void addUIs() {
        this.tgUIManager = new TGUIManager();
        WikiNavigateUI wikiNavigateUI = new WikiNavigateUI(this);
        this.tgUIManager.addUI(wikiNavigateUI, "Navigate");
        this.tgUIManager.activate("Navigate");
    }

    public void setLocale(Node node) {
        try {
            if (this.maxAddCombo != null && this.maxExpandCombo != null) {
                int n = Integer.parseInt((String)this.localityRadiusCombo.getSelectedItem());
                int n2 = Integer.parseInt((String)this.maxAddCombo.getSelectedItem());
                int n3 = Integer.parseInt((String)this.maxExpandCombo.getSelectedItem());
                boolean bl = !this.showBackLinksCheckBox.isSelected();
                this.tgPanel.setLocale(node, n, n2, n3, bl);
            }
        }
        catch (TGException tGException) {
            tGException.printStackTrace();
        }
    }

    public void setWikiTextPane(String string) {
        this.textPaneURL = string;
        new Thread(){

            public void run() {
                try {
                    TGWikiBrowser.this.tpWikiText.setPage(new URL(TGWikiBrowser.this.textPaneURL));
                    TGWikiBrowser.this.statusButton.setText(TGWikiBrowser.this.textPaneURL);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    public void setWikiTextPane(WikiNode wikiNode) {
        if (wikiNode.getURL() == null || wikiNode.getURL().trim().equals("")) {
            return;
        }
        this.browseHistory.push(wikiNode.getID());
        this.setWikiTextPane(wikiNode.getURL());
    }

    WikiNode findNodeByLabel(String string) {
        WikiNode wikiNode = null;
        Collection collection = this.tgPanel.findNodesByLabel(string);
        if (collection != null && !collection.isEmpty()) {
            wikiNode = (WikiNode)collection.iterator().next();
        }
        return wikiNode;
    }

    public void processURL(URL uRL) {
        String string = uRL.toString();
        String string2 = this.generateNodeLabel(string);
        System.out.println(string2);
        WikiNode wikiNode = this.findNodeByLabel(string2);
        if (wikiNode != null) {
            if (!wikiNode.isVisible()) {
                if (wikiNode.edgeCount() < 100) {
                    this.setLocale(wikiNode);
                } else {
                    try {
                        this.tgPanel.setLocale(wikiNode, 0);
                    }
                    catch (TGException tGException) {
                        // empty catch block
                    }
                }
            }
            this.tgPanel.setSelect(wikiNode);
            this.setWikiTextPane(wikiNode);
        } else {
            this.setWikiTextPane(string);
        }
    }

    public void processHyperlinkEvent(HyperlinkEvent hyperlinkEvent) {
        URL uRL = hyperlinkEvent.getURL();
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.processURL(uRL);
            return;
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            String string = uRL.toString();
            String string2 = this.generateNodeLabel(string);
            WikiNode wikiNode = this.findNodeByLabel(string2);
            if (wikiNode != null) {
                if (wikiNode.isVisible()) {
                    wikiNode.setMouseOverHyperlink(true);
                    this.nodeMOHL = wikiNode;
                    this.tgPanel.repaint();
                }
                this.statusButton.setText("IN GRAPH: " + string2 + " (" + wikiNode.edgeCount() + ")");
                if (wikiNode.edgeCount() > 50) {
                    this.statusButton.setForeground(Color.red);
                } else {
                    this.statusButton.setForeground(Color.black);
                }
            } else {
                this.statusButton.setText(string);
            }
        } else {
            this.statusButton.setText(this.textPaneURL);
            this.statusButton.setForeground(Color.black);
            if (this.nodeMOHL != null) {
                this.nodeMOHL.setMouseOverHyperlink(false);
                this.nodeMOHL = null;
                this.tgPanel.repaint();
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("USAGE:");
            System.out.println("TGWikiBrowser DATA_FILE(str)|DATA_URL(str) WIKI_URL(str) [INITAL_NODE(str) [LOCALITY_RADIUS(int) [SHOW_BACKLINKS(true/false)]]]");
            System.out.println("EXAMPLES:");
            System.out.println("TGWikiBrowser meatball.txt http://www.usemod.com/cgi-bin/mb.pl? hypermedium 2 false");
            System.out.println("TGWikiBrowser http://www.touchgraph.com/meatball.txt http://www.usemod.com/cgi-bin/mb.pl? hypermedium 2 false");
            System.exit(0);
        }
        WIKI_FILE = stringArray[0];
        WIKI_URL = stringArray[1];
        if (stringArray.length > 2) {
            INITIAL_NODE = stringArray[2];
        }
        if (stringArray.length > 3) {
            INITIAL_RADIUS = Integer.parseInt(stringArray[3]);
        }
        if (stringArray.length > 4) {
            INITIAL_SHOW_BACKLINKS = new Boolean(stringArray[4]);
        }
        JFrame jFrame = new JFrame("TouchGraph WikiBrowser V1.02");
        TGWikiBrowser tGWikiBrowser = new TGWikiBrowser(jFrame);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("Center", tGWikiBrowser);
        ((Component)jFrame).setSize(1024, 768);
        ((Component)jFrame).setVisible(true);
    }

    static /* synthetic */ Stack access$200(TGWikiBrowser tGWikiBrowser) {
        return tGWikiBrowser.browseHistory;
    }

    static {
        INITIAL_NODE = null;
        INITIAL_RADIUS = -1;
        INITIAL_SHOW_BACKLINKS = false;
    }

    private class BackButton
    extends JButton {
        BackButton() {
            super("< Back");
            this.setPreferredSize(new Dimension(80, 20));
            this.setMargin(new Insets(2, 0, 2, 0));
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ BackButton this$1;
                {
                    this.this$1 = backButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (TGWikiBrowser.access$200(BackButton.access$100(this.this$1)).size() > 1) {
                        try {
                            TGWikiBrowser.access$200(BackButton.access$100(this.this$1)).pop();
                            String string = (String)TGWikiBrowser.access$200(BackButton.access$100(this.this$1)).peek();
                            WikiNode wikiNode = (WikiNode)BackButton.access$100((BackButton)this.this$1).tgPanel.findNode(string);
                            BackButton.access$100(this.this$1).processURL(new URL(wikiNode.getURL()));
                            TGWikiBrowser.access$200(BackButton.access$100(this.this$1)).pop();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        static /* synthetic */ TGWikiBrowser access$100(BackButton backButton) {
            return backButton.TGWikiBrowser.this;
        }
    }

    class HorizontalStretchLens
    extends TGAbstractLens {
        HorizontalStretchLens() {
        }

        protected void applyLens(TGPoint2D tGPoint2D) {
            tGPoint2D.x *= 1.5;
        }

        protected void undoLens(TGPoint2D tGPoint2D) {
            tGPoint2D.x /= 1.5;
        }
    }
}

