/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.util.Format;
import ucar.unidata.util.SpecialMathFunction;

public class TransverseMercator
extends ProjectionImpl {
    private double lat0;
    private double lon0;
    private double scale;
    private LatLonPointImpl origin;
    private double falseEasting = 0.0;
    private double falseNorthing = 0.0;

    @Override
    public ProjectionImpl constructCopy() {
        return new TransverseMercator(this.getOriginLat(), this.getTangentLon(), this.getScale(), this.getFalseEasting(), this.getFalseNorthing());
    }

    public TransverseMercator() {
        this(40.0, -105.0, 0.9996);
    }

    public TransverseMercator(double lat0, double tangentLon, double scale) {
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(tangentLon);
        this.scale = scale * EARTH_RADIUS;
        this.origin = new LatLonPointImpl(lat0, tangentLon);
        this.addParameter("grid_mapping_name", "transverse_mercator");
        this.addParameter("longitude_of_central_meridian", tangentLon);
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("scale_factor_at_central_meridian", scale);
    }

    public TransverseMercator(double lat0, double tangentLon, double scale, double east, double north) {
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(tangentLon);
        this.scale = scale * EARTH_RADIUS;
        if (!Double.isNaN(east)) {
            this.falseEasting = east;
        }
        if (!Double.isNaN(north)) {
            this.falseNorthing = north;
        }
        this.origin = new LatLonPointImpl(lat0, tangentLon);
        this.addParameter("grid_mapping_name", "transverse_mercator");
        this.addParameter("longitude_of_central_meridian", tangentLon);
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("scale_factor_at_central_meridian", scale);
        if (this.falseEasting != 0.0 || this.falseNorthing != 0.0) {
            this.addParameter("false_easting", this.falseEasting);
            this.addParameter("false_northing", this.falseNorthing);
            this.addParameter("units", "km");
        }
    }

    public double getScale() {
        return this.scale / EARTH_RADIUS;
    }

    public void setScale(double scale) {
        this.scale = EARTH_RADIUS * scale;
    }

    public double getTangentLon() {
        return this.origin.getLongitude();
    }

    public void setTangentLon(double lon) {
        this.origin.setLongitude(lon);
        this.lon0 = Math.toRadians(lon);
    }

    public double getOriginLat() {
        return this.origin.getLatitude();
    }

    public void setOriginLat(double lat) {
        this.origin.setLatitude(lat);
        this.lat0 = Math.toRadians(lat);
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Transverse mercator";
    }

    @Override
    public String paramsToString() {
        return " origin " + this.origin.toString() + " scale: " + Format.d(this.getScale(), 6);
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        double y2;
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        double y1 = pt1.getY() - this.falseNorthing;
        return y1 * (y2 = pt2.getY() - this.falseNorthing) < 0.0 && Math.abs(y1 - y2) > 2.0 * EARTH_RADIUS;
    }

    @Override
    public Object clone() {
        TransverseMercator cl = (TransverseMercator)super.clone();
        cl.origin = new LatLonPointImpl(this.getOriginLat(), this.getTangentLon());
        cl.falseEasting = this.falseEasting;
        cl.falseNorthing = this.falseNorthing;
        return cl;
    }

    @Override
    public boolean equals(Object proj) {
        if (!(proj instanceof TransverseMercator)) {
            return false;
        }
        TransverseMercator oo = (TransverseMercator)proj;
        return this.getScale() == oo.getScale() && this.getOriginLat() == oo.getOriginLat() && this.getTangentLon() == oo.getTangentLon() && this.falseEasting == this.falseEasting && this.falseNorthing == this.falseNorthing && this.defaultMapArea.equals(oo.defaultMapArea);
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double toY;
        double toX;
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double lon = Math.toRadians(fromLon);
        double lat = Math.toRadians(fromLat);
        double dlon = lon - this.lon0;
        double b = Math.cos(lat) * Math.sin(dlon);
        if (Math.abs(Math.abs(b) - 1.0) < 1.0E-6) {
            toX = 0.0;
            toY = 0.0;
        } else {
            toX = this.scale * SpecialMathFunction.atanh(b);
            toY = this.scale * (Math.atan2(Math.tan(lat), Math.cos(dlon)) - this.lat0);
        }
        result.setLocation(toX + this.falseEasting, toY + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX();
        double fromY = world.getY();
        double x = (fromX - this.falseEasting) / this.scale;
        double d = (fromY - this.falseNorthing) / this.scale + this.lat0;
        double toLon = Math.toDegrees(this.lon0 + Math.atan2(SpecialMathFunction.sinh(x), Math.cos(d)));
        double toLat = Math.toDegrees(Math.asin(Math.sin(d) / SpecialMathFunction.cosh(x)));
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toY;
            double toX;
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lon = Math.toRadians(fromLon);
            double lat = Math.toRadians(fromLat);
            double dlon = lon - this.lon0;
            double b = Math.cos(lat) * Math.sin(dlon);
            if (Math.abs(Math.abs(b) - 1.0) < 1.0E-6) {
                toX = 0.0;
                toY = 0.0;
            } else {
                toX = this.scale * SpecialMathFunction.atanh(b) + this.falseEasting;
                toY = this.scale * (Math.atan2(Math.tan(lat), Math.cos(dlon)) - this.lat0) + this.falseNorthing;
            }
            resultXA[i] = (float)toX;
            resultYA[i] = (float)toY;
        }
        return to;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double x = (fromX - this.falseEasting) / this.scale;
            double d = (fromY - this.falseNorthing) / this.scale + this.lat0;
            double toLon = Math.toDegrees(this.lon0 + Math.atan2(SpecialMathFunction.sinh(x), Math.cos(d)));
            double toLat = Math.toDegrees(Math.asin(Math.sin(d) / SpecialMathFunction.cosh(x)));
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toY;
            double toX;
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lon = Math.toRadians(fromLon);
            double lat = Math.toRadians(fromLat);
            double dlon = lon - this.lon0;
            double b = Math.cos(lat) * Math.sin(dlon);
            if (Math.abs(Math.abs(b) - 1.0) < 1.0E-6) {
                toX = 0.0;
                toY = 0.0;
            } else {
                toX = this.scale * SpecialMathFunction.atanh(b) + this.falseEasting;
                toY = this.scale * (Math.atan2(Math.tan(lat), Math.cos(dlon)) - this.lat0) + this.falseNorthing;
            }
            resultXA[i] = toX;
            resultYA[i] = toY;
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toLat;
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double x = (fromX - this.falseEasting) / this.scale;
            double d = (fromY - this.falseNorthing) / this.scale + this.lat0;
            double toLon = Math.toDegrees(this.lon0 + Math.atan2(SpecialMathFunction.sinh(x), Math.cos(d)));
            toLatA[i] = toLat = Math.toDegrees(Math.asin(Math.sin(d) / SpecialMathFunction.cosh(x)));
            toLonA[i] = toLon;
        }
        return to;
    }
}

