/* libwmf ("stream.h"): library for wmf conversion
   Copyright (C) 2001 Francis James Franklin

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifndef WMFAPI_STREAM_H
#define WMFAPI_STREAM_H

#ifdef _MSC_VER
# ifndef vsnprintf
#       define vsnprintf  _vsnprintf
# endif
#endif

typedef struct _wmfDefaultZtream wmfDefaultZtream;
typedef struct _wmfDefaultStream wmfDefaultStream;

struct _wmfDefaultZtream
{	wmfAPI* API;

	gzFile out;

	z_off_t offset;

	unsigned long max;
	unsigned long len;

	char* buf;
	char* ptr;
};

struct _wmfDefaultStream
{	wmfAPI* API;

	FILE* out;

	long offset;

	unsigned long max;
	unsigned long len;

	char* buf;
	char* ptr;
};

#endif /* ! WMFAPI_STREAM_H */
