#!/bin/sh
#
#  This file is part of the KDE project
#  Copyright (C) 2016 Jarosław Staniek <staniek@kde.org>
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this library; see the file COPYING.LIB.  If not, write to
#  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA 02110-1301, USA.
#
# Updates list of icon files in icons/$1/ and outputs to $2.
# Used by kreport_add_icons_rcc_file() cmake macro.
#
set -e

theme=$1
output=$2
if [ -z "$theme" ] ; then echo "Theme name required as first argument"; exit 1; fi
if [ -z "$output" ] ; then echo "Output .cmake file required as second argument"; exit 1; fi
script=$(basename $0)

function content()
{
    echo "# List of project's own icon files"
    echo "# This file is generated by $script"
    echo "# WARNING! All changes made in this file will be lost!"
    echo
    echo "set(_PNG_FILES"
    find icons/$theme/ -name \*png | sed "s/\.\///g" | sort
    echo ")"
    echo

    echo "set(_SVG_FILES"
    find icons/$theme/ -name \*svg | sed "s/\.\///g" | sort
    echo ")"
    echo

    echo "set(_FILES \${_PNG_FILES} \${_SVG_FILES})"
}

content > $output
