/***************************************************************************
                              kstviewlegend.h
                             ----------------
    begin                : Apr 10 2004
    copyright            : (C) 2000 by cbn
                           (C) 2004 by The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTVIEWLEGEND_H
#define KSTVIEWLEGEND_H

#include "kstbackbuffer.h"
#include "kstborderedviewobject.h"
#include "kstscalar.h"
#include "labelparser.h"
#include "kstbasecurve.h"

#include <qguardedptr.h>

class KstViewLegendDialogI;
class Kst2DPlot;

class KstViewLegend : public KstBorderedViewObject {
  Q_OBJECT
  Q_PROPERTY(QString font READ fontName WRITE setFontName)
  Q_PROPERTY(int fontSize READ fontSize WRITE setFontSize)
  Q_PROPERTY(bool transparent READ transparent WRITE setTransparent)
  Q_PROPERTY(bool vertical READ vertical WRITE setVertical)
  public:
    KstViewLegend();
    KstViewLegend(const QDomElement& e);
    virtual ~KstViewLegend();

    int ascent() const;

    void setFontName(const QString& fontName);
    const QString& fontName() const;

    void setFontSize(int size);
    int fontSize() const;

    virtual void save(QTextStream& ts, const QString& indent = QString::null);

    void setDoScalarReplacement(bool in_do);
    bool doScalarReplacement() const;

    void setTransparent(bool transparent);
    bool transparent() const;

    virtual void paint(KstPaintType type, QPainter& p, const QRegion& bounds);
    virtual void resize(const QSize&);
    virtual QRegion clipRegion();
    
    virtual QMap<QString, QVariant> widgetHints(const QString& propertyName) const;

    KstBaseCurveList Curves;

    void addCurve(KstBaseCurvePtr curve);
    void removeCurve(KstBaseCurvePtr curve);

    void setCurveList(Kst2DPlot *plot);
    
    bool vertical() const {return _vertical;}
    void setVertical(bool vertical) {_vertical = vertical;}
    
  public slots:
    void adjustSizeForText(QRect w);

  protected:
    virtual KstViewObjectFactoryMethod factory() const;
    virtual bool layoutPopupMenu(KPopupMenu *menu, const QPoint& pos, KstViewObjectPtr topLevelParent);
    virtual void readBinary(QDataStream& str);
    virtual void writeBinary(QDataStream& str);

  private:
    void drawToBuffer();
    void drawToPainter(QPainter& p);
    void tmpDrawToPainter(QPainter& p);
    void computeTextSize();

    double _rotation;
    QString _fontName;
    KstScalarList _scalarsUsed;

    bool _replace : 1;
    bool _vertical;
    int _absFontSize; // points
    int _fontSize; // size relative to reference size.....
    int _textWidth, _textHeight, _ascent;
    KstBackBuffer _backBuffer;
};

typedef KstSharedPtr<KstViewLegend> KstViewLegendPtr;

#endif
// vim: ts=2 sw=2 et
