#include <qmetaobject.h>
#include <private/qucom_p.h>

#include <qpen.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qvariant.h>
#include <qdatetime.h>

#include <kjs/interpreter.h>
#include <kjs/ustring.h>
#include <kjs/types.h>
#include <kjs/value.h>

#include "global.h"
#include "jsbinding.h"
#include "jsobjectproxy.h"
#include "jsfactory.h"
#include "jsvalueproxy.h"
#include "jsopaqueproxy.h"
#include "kjsembedpart.h"

#ifndef QT_ONLY
#include "bindings/pen_imp.h"
#include "bindings/image_imp.h"
#include "bindings/pixmap_imp.h"
#include "bindings/painter_imp.h"
#include "bindings/brush_imp.h"
#endif // QT_ONLY

namespace KJSEmbed {

//
//
// Supported
// =========
//
// Bool, Double, CString, String, StringList, Int, UInt, Date, Time, DateTime,
// Rect, Size, Point, Pixmap, Image, Brush, Pen
//
// Opqaue
// ======
//
// Invalid, Map, List, Palette, ColorGroup,
// IconSet, PointArray, Region, Bitmap, Cursor, SizePolicy,
// ByteArray, BitArray 
//

KJS::Value convertToValue( KJS::ExecState *exec, const QVariant &val )
{
    if ( !val.isValid() )
	return KJS::Undefined();

    KJS::List items;
    uint type = val.type();

    if ( type == QVariant::String || type == QVariant::CString )
	return KJS::String( val.toString() );
    else if ( type == QVariant::Int )
	return KJS::Number( val.toInt() );
    else if ( type == QVariant::UInt )
	return KJS::Number( val.toUInt() );
    else if ( type == QVariant::Double )
	return KJS::Number( val.toDouble() );
    else if ( type == QVariant::Bool )
	return KJS::Boolean( val.toBool() );
    else if ( type == QVariant::Color || type == QVariant::KeySequence || type == QVariant::Font )
	return KJS::String( val.toString() );
    else if ( type == QVariant::Rect ) {
	QRect r( val.toRect() );
	items.append( KJS::Number( r.x() ) );
	items.append( KJS::Number( r.y() ) );
	items.append( KJS::Number( r.width() ) );
	items.append( KJS::Number( r.height() ) );
	return KJS::Object( exec->interpreter()->builtinArray().construct( exec, items ) );
    }
    else if ( type == QVariant::Date || type == QVariant::DateTime || type == QVariant::Time )
    {
        QDateTime dt = QDateTime::currentDateTime();
	if ( type == QVariant::Date )
	    dt.setDate( val.toDate() );
	else if ( type == QVariant::Time )
	    dt.setTime( val.toTime() );
	else
	    dt = val.toDateTime();

	items.append( KJS::Number( dt.date().year() ));
	items.append( KJS::Number( dt.date().month() - 1 ));
	items.append( KJS::Number( dt.date().day() ));
	items.append( KJS::Number( dt.time().hour() ));
	items.append( KJS::Number( dt.time().minute() ));
	items.append( KJS::Number( dt.time().second() ));
	items.append( KJS::Number( dt.time().msec() ));
	return KJS::Object( exec->interpreter()->builtinDate().construct( exec, items ) );
    }
    else if ( type == QVariant::Point ) {
	QPoint p( val.toPoint() );
	items.append( KJS::Number( p.x() ) );
	items.append( KJS::Number( p.y() ) );
	return KJS::Object( exec->interpreter()->builtinArray().construct( exec, items ) );
    }
    else if ( type == QVariant::StringList ) {
    	QStringList lst = val.toStringList();
	for( uint idx = 0; idx < lst.count(); ++idx )
	    items.append( KJS::String( lst[idx] ) );
	return KJS::Object( exec->interpreter()->builtinArray().construct( exec, items ) );
    }
   /* else if ( type == QVariant::Size ) {
	QSize sz( val.toSize() );
	items.append( KJS::Number( sz.width() ) );
	items.append( KJS::Number( sz.height() ) );
	return KJS::Object( exec->interpreter()->builtinArray().construct( exec, items ) );
    }*/
    else if ( type == QVariant::Pixmap ) {
    	JSValueProxy *prx = new JSValueProxy( );
	prx->setValue(val);
	KJS::Object proxyObj(prx);
#ifndef QT_ONLY
    	Bindings::Pixmap::addBindings( exec, proxyObj);
#endif // QT_ONLY
	return proxyObj;
    }
    else if ( type == QVariant::Brush ) {
    	JSValueProxy *prx = new JSValueProxy( );
	prx->setValue(val);
	KJS::Object proxyObj(prx);
#ifndef QT_ONLY
    	Bindings::BrushImp::addBindings( exec, proxyObj);
#endif // QT_ONLY
	return proxyObj;
    }
    else if ( type == QVariant::Image ) {
    	JSValueProxy *prx = new JSValueProxy( );
	prx->setValue(val);
	KJS::Object proxyObj(prx);
#ifndef QT_ONLY
    	Bindings::ImageImp::addBindings( exec, proxyObj);
#endif // QT_ONLY
	return proxyObj;
    }
    else if ( type == QVariant::Pen ) {
    	JSValueProxy *prx = new JSValueProxy( );
	prx->setValue(val);
	KJS::Object proxyObj(prx);
#ifndef QT_ONLY
    	Bindings::Pen::addBindings( exec, proxyObj);
#endif // QT_ONLY
	return proxyObj;
    }
    else {
	kdDebug(80001) << "convertToValue() Creating value, type = " << val.typeName() << endl;
	
	JSValueProxy *valproxy = new JSValueProxy();
	KJS::Object obj = KJS::Object( valproxy );
	valproxy->addBindings( exec, obj );
	valproxy->setValue( val );
	
	return obj;
    }

    return KJS::Undefined();
}

QVariant convertToVariant( KJS::ExecState *exec, const KJS::Value &v )
{
    QVariant val;
    if ( v.isA( KJS::StringType ) )
	val = v.toString(exec).qstring();
    else if ( v.isA( KJS::NumberType ) )
	val = v.toInteger(exec);
    else if ( v.isA( KJS::BooleanType ) )
	val = v.toBoolean(exec);
    else if ( v.isA( KJS::ObjectType ) ) {
	KJS::Object obj = v.toObject(exec);
	kdDebug(80001) << "convertToVariant() got an " << obj.className().qstring() << endl;
	if( obj.className().qstring() == "Array" )
		val = convertArrayToStringList( exec, v );
	else if(obj.className().qstring() == "Date")
		val = convertDateToDateTime(exec, v);
	else
	{
		JSObjectProxy *prx = JSProxy::toObjectProxy( obj.imp() );
		JSValueProxy *vprx = dynamic_cast<JSValueProxy *>( obj.imp() );
		JSOpaqueProxy *oprx = dynamic_cast<JSOpaqueProxy *>( obj.imp() );
	
		if ( prx ) {
		QObject *o = prx->object();
		QCString cs( o ? o->className() : "" );
		//kdDebug(80001) << "Converting JSObjectProxy, class " << cs << endl;
	
		//if ( o && (cs == "KJSEmbed::Bindings::Pixmap") )
			//val = o->property( "pixmap" );
		//if ( o && (cs == "KJSEmbed::Bindings::Pen") )
			//val = o->property( "pen" );
	
		if ( obj.implementsConstruct() )
			val = QString("new %1();").arg( obj.className().qstring() );
		else if ( obj.implementsCall() )
			val = QString("%1(...);").arg( obj.className().qstring() );
		}
		else if ( vprx ) {
		kdDebug(80001) << "convertToVariant() got a variant JSValueProxy" << endl;
		return vprx->toVariant();
		} else if ( oprx ) {
		kdDebug(80001) << "convertToVariant() got a JSOpaqueProxy" << endl;
		}
	}
    }
    else {
	QString s( "Unsupported KJS::Value, type %1" );
	val = s.arg( (int) v.type() );
    }

    return val;
}

QStringList dumpCompletion( KJS::ExecState *exec, KJS::Object &obj)
{
	QStringList returnList;
	if ( !obj.isValid() )
	{
		return returnList;
	}

	KJS::ReferenceList l = obj.propList( exec );
	KJS::ReferenceListIterator propIt = l.begin();
	while ( propIt != l.end() ) {

		KJS::Identifier name = propIt->getPropertyName( exec );
		if ( obj.hasProperty( exec, name ) ) {
			KJS::Value v = obj.get( exec, name );
			KJS::Object vobj = v.toObject( exec );
			QString nm( name.ustring().qstring() );
			QString vl;

			if ( vobj.implementsConstruct() ) {
				if( vobj.prototype().toString(exec).qstring() == "[function]" )
					returnList << QString( "%1(...)" ).arg(nm);
			}
			else if ( vobj.implementsCall() ) {
				returnList << QString( "%1(...)" ).arg(nm);
			}
			else {
				QVariant val = convertToVariant( exec, v );
				vl = val.toString();
				returnList << nm;
			}
		}

		propIt++;
	}

	JSObjectProxy *proxy = JSProxy::toObjectProxy( obj.imp() );
	QObject *qo = proxy ? proxy->object() : 0;
	QMetaObject *mo = qo ? qo->metaObject() : 0;

	// QObject
	if ( proxy ) {

		// QProperties
		QStrList propList( mo->propertyNames(true) );
		for ( QStrListIterator iter1(propList); iter1.current(); ++iter1 ) {

			QCString name = iter1.current();
			int propid = mo->findProperty( name.data(), true );
			if ( propid == -1 )
				continue;
			returnList << name;
		}

		// Slots
		KJS::List items;
		QStrList slotList( mo->slotNames( true ) );

		for ( QStrListIterator iter2(slotList); iter2.current(); ++iter2 ) {
			QCString name = iter2.current();
			QString nm( name );

			int slotid = mo->findSlot( name.data(), true );
			if ( slotid != -1 ) {
				returnList << nm;
			}
		}
	}
    return returnList;
}

QString dumpObject( KJS::ExecState *exec, KJS::Object &obj )
{
    if ( !obj.isValid() )
	return QString( "Invalid object\n" );

    QStringList properties;
    QStringList methods;

    KJS::ReferenceList l = obj.propList( exec, true );
    KJS::ReferenceListIterator propIt = l.begin();

    while ( propIt != l.end() ) {

	KJS::Identifier name = propIt->getPropertyName( exec );

	if ( obj.hasProperty( exec, name ) ) {

	    KJS::Value v = obj.get( exec, name );
	    KJS::Object vobj = v.toObject( exec );
	    QString nm( name.ustring().qstring() );

	    kdDebug( 80001 ) << "Getting: " << name.ustring().qstring() << " " 
			     << vobj.prototype().toString(exec).qstring() << endl;
		 
	    if ( vobj.implementsConstruct()) {
		// Do nothing
		kdDebug( 80001 ) << "implementsConstruct: " << nm << endl;
		if ( vobj.prototype().toString(exec).qstring() == "[function]" )
		    methods += nm;
	    } else if ( vobj.implementsCall() ) {
		kdDebug( 80001 ) << "implementsCall: " << nm << endl;
		methods += nm;
	    }
	    else {
		properties += nm;
	    }
	}

	propIt++;
    }

    QString s;

    // JS properties
    s += QString("<h2>Properties</h2>\n");

    if ( !properties.isEmpty() ) {
	s += "<table width=\"90%\">\n";
	s += "<tr><th>Type</th><th>Name</th><th>Value</th></tr>\n";

	properties.sort();
	for ( QStringList::Iterator iter = properties.begin(); iter != properties.end(); ++iter ) {

	    KJS::Value v = obj.get( exec, KJS::Identifier( KJS::UString(*iter) ) );
	    QVariant val = convertToVariant( exec, v );

	    s += QString("<tr><td align=\"center\">%1</td><td><b>%2</b></td><td align=\"center\">%3</td></tr>\n")
		.arg( val.typeName() ).arg( *iter ).arg( val.toString() );
	}

	s += "</table>\n";
    }
    else
	s += "<i>None</i>\n";

    // Methods
    s += QString("<h2>Methods</h2>\n");

    if ( !methods.isEmpty() ) {
	s += "<table width=\"90%\">";
	methods.sort();
	for ( QStringList::Iterator iter = methods.begin(); iter != methods.end(); ++iter ) {
	    s += "<tr><td><b>";
	    s += *iter;
	    s += "(...)</b></td></tr>";
	}
	s += "</table>";
    }
    else
	s += "<i>None</i>\n";

    s += dumpQObject( exec, obj );
    return s;
}

QString dumpQObject( KJS::ExecState * /*exec*/, KJS::Object &obj )
{
    if ( !obj.isValid() )
	return QString( "Invalid object\n" );

    QString s("");
    JSObjectProxy *proxy = JSProxy::toObjectProxy( obj.imp() );
    QObject *qo = proxy ? proxy->object() : 0;
    QMetaObject *mo = qo ? qo->metaObject() : 0;

    // QObject
    if ( proxy ) {

	// QProperties
	s += QString("<h2>Qt Properties</h2>\n");

	QStrList propList( mo->propertyNames(true) );

	if ( !propList.isEmpty() ) {

	    s += "<table width=\"90%\">\n";
	    s += "<tr><th>Type</th><th>Name</th><th>Value</th></tr>\n";

	    propList.sort();
	    for ( QStrListIterator iter(propList); iter.current(); ++iter ) {

		QCString name = iter.current();
		int propid = mo->findProperty( name.data(), true );
		if ( propid == -1 )
		    continue;

		QVariant vl = qo->property( name.data() );
		s += QString( "<tr><td align=\"center\">%1</td><td><b>%2</b></td><td align=\"center\">%3</td></tr>\n" )
		    .arg( mo->property(propid, true)->type() ).arg(name).arg(vl.toString());
	    }

	    s += "</table>\n";
	}
	else {
	    s += "<i>None</i>";
	}

	// Signals
	s += QString("<h2>Qt Signals</h2>\n");
	s += "<table width=\"90%\">";

	QStrList signalList( mo->signalNames( true ) );
	signalList.sort();

	for ( QStrListIterator iter1(signalList); iter1.current(); ++iter1 ) {

	    QCString name = iter1.current();
	    QString nm( name );

	    int signalid = mo->findSignal( name.data(), true );
	    if ( signalid != -1 )
		s += QString("<tr><td><b>%1</b></td></tr>\n").arg(nm);
	}

	s += "</table>";
	if ( signalList.isEmpty() )
	    s += "<i>None</i>";

	// Slots
	s += QString("<h2>Qt Slots</h2>\n");
	s += "<table width=\"90%\">";

	KJS::List items;
	QStrList slotList( mo->slotNames( true ) );
	slotList.sort();

	for ( QStrListIterator iter2(slotList); iter2.current(); ++iter2 ) {

	    QCString name = iter2.current();
	    QString nm( name );

	    int slotid = mo->findSlot( name.data(), true );
	    if ( slotid != -1 ) {
		const QMetaData *md = mo->slot( slotid, true );
		const QUMethod *method = md->method;
		if ( method->count && (method->parameters->inOut == QUParameter::Out) ) {
		    QCString typenm( method->parameters->type->desc() );
		    if ( typenm == "ptr" ) {
			s += QString("<tr><td>%1</td><td><b>%2</b></td></tr>\n")
			    .arg((const char *) method->parameters->typeExtra).arg(nm);
		    }
		    else {
			s += QString("<tr><td>%1</td><td><b>%2</b></td></tr>\n")
			       .arg(typenm.data()).arg(nm);
		    }
		}
		else
		    s += QString("<tr><td>void</td><td><b>%1</b></td></tr>\n").arg(nm);
	    }
	}

	s += "</table>";
	if ( slotList.isEmpty() )
	    s += "<i>None</i>";
    }

    return s;
}



QPen extractQPen(KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? convertToVariant(exec, args[idx]).toPen() : QPen();
}

QBrush extractQBrush(KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? convertToVariant(exec, args[idx]).toBrush() : QBrush();
}

QFont extractQFont(KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? convertToVariant(exec, args[idx]).toFont() : QFont();
}

QPixmap extractQPixmap( KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? convertToVariant(exec, args[idx]).toPixmap() : QPixmap();
}

QImage extractQImage( KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? convertToVariant(exec, args[idx]).toImage() : QImage();
}

QPalette extractQPalette(KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? convertToVariant(exec, args[idx]).toPalette() : QPalette();
}

QString extractQString( KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? args[idx].toString(exec).qstring() : QString::null;
}

int extractInt( KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? args[idx].toInteger(exec) : 0;
}

QColor extractQColor(KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? convertToVariant(exec, args[idx]).toColor() : QColor();
}

QSize extractQSize(KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? convertToVariant(exec, args[idx]).toSize() : QSize();
}

bool extractBool(KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? args[idx].toBoolean(exec) : false;
}

double extractDouble(KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? args[idx].toNumber(exec) : 0.0;
}

uint extractUInt(KJS::ExecState *exec, const KJS::List &args, int idx)
{
     return (args.size() > idx) ? args[idx].toUInt32(exec) : 0;
}

QStringList extractQStringList(KJS::ExecState *exec, const KJS::List &args, int idx)
{
    return (args.size() > idx) ? convertArrayToStringList( exec, args[idx] ) : QStringList();
}

QStringList convertArrayToStringList( KJS::ExecState *exec, const KJS::Value &value)
{
    QStringList returnList;
    KJS::Object obj = value.toObject(exec);

    if( obj.className().qstring() == "Array" ) {
	int length = obj.get(exec, KJS::Identifier("length")).toInteger(exec);
	for( int index = 0; index < length; ++index ) {
	    returnList << obj.get(exec, KJS::Identifier( KJS::UString::from(index) ) ).toString(exec).qstring();
	}
    }

    return returnList;
}

QDateTime convertDateToDateTime(KJS::ExecState *exec, const KJS::Value &value)
{
    KJS::List args;
    QDateTime returnDateTime;
    KJS::Object obj = value.toObject( exec );

    if ( obj.className().qstring() == "Date" ) {
	int seconds = obj.get(exec, KJS::Identifier("getSeconds")).toObject( exec ).call(exec, obj, args).toInteger(exec);
	int minutes = obj.get(exec, KJS::Identifier("getMinutes")).toObject( exec ).call(exec, obj, args).toInteger(exec);
	int hours = obj.get(exec, KJS::Identifier("getHours")).toObject( exec ).call(exec, obj, args).toInteger(exec);
	int month = obj.get(exec, KJS::Identifier("getMonth")).toObject( exec ).call(exec, obj, args).toInteger(exec);
	int day = obj.get(exec, KJS::Identifier("getDate")).toObject( exec ).call(exec, obj, args).toInteger(exec);
	int year = obj.get(exec, KJS::Identifier("getFullYear")).toObject( exec ).call(exec, obj, args).toInteger(exec);

	returnDateTime.setDate( QDate( year, month+1, day ) );
	returnDateTime.setTime( QTime( hours, minutes, seconds ) );
    }
    else {
	kdWarning() << "convertDateToDateTime() received a " << obj.className().qstring() << " instead of a Date" << endl;
    }

    return returnDateTime;
}

QDateTime extractQDateTime( KJS::ExecState * exec, const KJS::List & args, int idx )
{
    return (args.size() > idx) ? convertDateToDateTime( exec, args[idx] ) : QDateTime();
}

QDate extractQDate( KJS::ExecState * exec, const KJS::List & args, int idx )
{
    return (args.size() > idx) ? convertDateToDateTime( exec, args[idx] ).date() : QDate();
}

QTime extractQTime( KJS::ExecState * exec, const KJS::List & args, int idx )
{
    return (args.size() > idx) ? convertDateToDateTime( exec, args[idx] ).time() : QTime();
}
 
QRect extractQRect( KJS::ExecState * exec, const KJS::List & args, int idx )
{
    return (args.size() > idx) ? convertToVariant(exec, args[idx]).toRect() : QRect();
}

QPoint extractQPoint( KJS::ExecState * exec, const KJS::List & args, int idx )
{
    return (args.size() > idx) ? convertToVariant(exec, args[idx]).toPoint() : QPoint();
}

QStrList extractQStrList(KJS::ExecState *exec, const KJS::List &args, int idx)
{
    return (args.size() > idx) ? convertArrayToStrList( exec, args[idx] ) : QStrList();
}

QStrList convertArrayToStrList( KJS::ExecState *exec, const KJS::Value &value)
{
    QStrList returnList;
    KJS::Object obj = value.toObject(exec);

    if( obj.className().qstring() == "Array" ) {
	int length = obj.get(exec, KJS::Identifier("length")).toInteger(exec);
	for( int index = 0; index < length; ++index) {
	    returnList.append( obj.get(exec, KJS::Identifier( KJS::UString::from(index) ) ).toString(exec).qstring().latin1() );
	}
    }

    return returnList;
}

QObject *extractQObject( KJS::ExecState *exec, const KJS::List &args, int idx )
{
	KJS::Object obj = args[idx].toObject(exec);
	JSObjectProxy *proxy = JSProxy::toObjectProxy( obj.imp() );
	if ( !proxy ) return 0L;
	return proxy->object();
	
}

QWidget *extractQWidget( KJS::ExecState *exec, const KJS::List &args, int idx )
{
	KJS::Object obj = args[idx].toObject(exec);
	JSObjectProxy *proxy = JSProxy::toObjectProxy( obj.imp() );
	if ( !proxy ) return 0L;
	return proxy->widget();
}

}// namespace KJSEmbed

