/***************************************************************************
                            bind_pluginmodule.cpp
                             -------------------
    begin                : Apr 12 2005
    copyright            : (C) 2005 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "bind_pluginmodule.h"

#include <kdebug.h>

using namespace KJSEmbed;

KstBindPluginModule::KstBindPluginModule(KJS::ExecState *exec, const Plugin::Data& d)
: KstBinding("PluginModule", false), _d(d) {
  KJS::Object o(this);
  addBindings(exec, o);
}


KstBindPluginModule::KstBindPluginModule(int id)
: KstBinding("PluginModule Method", id) {
}


KstBindPluginModule::~KstBindPluginModule() {
}


struct PluginModuleBindings {
  const char *name;
  KJS::Value (KstBindPluginModule::*method)(KJS::ExecState*, const KJS::List&);
};


struct PluginModuleProperties {
  const char *name;
  void (KstBindPluginModule::*set)(KJS::ExecState*, const KJS::Value&);
  KJS::Value (KstBindPluginModule::*get)(KJS::ExecState*) const;
};


static PluginModuleBindings pluginModuleBindings[] = {
  { 0L, 0L }
};


static PluginModuleProperties pluginModuleProperties[] = {
  { 0L, 0L, 0L }
};


KJS::ReferenceList KstBindPluginModule::propList(KJS::ExecState *exec, bool recursive) {
  KJS::ReferenceList rc = KstBinding::propList(exec, recursive);

  for (int i = 0; pluginModuleProperties[i].name; ++i) {
    rc.append(KJS::Reference(this, KJS::Identifier(pluginModuleProperties[i].name)));
  }

  return rc;
}


bool KstBindPluginModule::hasProperty(KJS::ExecState *exec, const KJS::Identifier& propertyName) const {
  QString prop = propertyName.qstring();
  for (int i = 0; pluginModuleProperties[i].name; ++i) {
    if (prop == pluginModuleProperties[i].name) {
      return true;
    }
  }

  return KstBinding::hasProperty(exec, propertyName);
}


void KstBindPluginModule::put(KJS::ExecState *exec, const KJS::Identifier& propertyName, const KJS::Value& value, int attr) {
  QString prop = propertyName.qstring();
  for (int i = 0; pluginModuleProperties[i].name; ++i) {
    if (prop == pluginModuleProperties[i].name) {
      if (!pluginModuleProperties[i].set) {
        break;
      }
      (this->*pluginModuleProperties[i].set)(exec, value);
      return;
    }
  }

  KstBinding::put(exec, propertyName, value, attr);
}


KJS::Value KstBindPluginModule::get(KJS::ExecState *exec, const KJS::Identifier& propertyName) const {
  QString prop = propertyName.qstring();
  for (int i = 0; pluginModuleProperties[i].name; ++i) {
    if (prop == pluginModuleProperties[i].name) {
      if (!pluginModuleProperties[i].get) {
        break;
      }
      return (this->*pluginModuleProperties[i].get)(exec);
    }
  }
  
  return KstBinding::get(exec, propertyName);
}


KJS::Value KstBindPluginModule::call(KJS::ExecState *exec, KJS::Object& self, const KJS::List& args) {
  int id = this->id();
  if (id <= 0) {
    KJS::Object eobj = KJS::Error::create(exec, KJS::GeneralError);
    exec->setException(eobj);
    return KJS::Undefined();
  }

  KstBindPluginModule *imp = dynamic_cast<KstBindPluginModule*>(self.imp());
  if (!imp) {
    KJS::Object eobj = KJS::Error::create(exec, KJS::GeneralError);
    exec->setException(eobj);
    return KJS::Undefined();
  }

  return (imp->*pluginModuleBindings[id - 1].method)(exec, args);
}


void KstBindPluginModule::addBindings(KJS::ExecState *exec, KJS::Object& obj) {
  for (int i = 0; pluginModuleBindings[i].name != 0L; ++i) {
    KJS::Object o = KJS::Object(new KstBindPluginModule(i + 1));
    obj.put(exec, pluginModuleBindings[i].name, o, KJS::Function);
  }
}


// vim: ts=2 sw=2 et
