/***************************************************************************
                          optionsDialog.cpp  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "optionsDialog.h"
//#include "ftpsitedlg.h"
//#include "browserDialog.h"
//#define Inherited  QDialog

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/*
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
optionsDialog::optionsDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
        : QDialog( parent, name, modal, fl )
{
    if ( !name )
        setName( "optionsDialog" );
    resize( 748, 494 );
    styleChanged=FALSE;
 b_qExit=TRUE;
 setProperty( "caption", tr( "Gutenbrowser Options" ) );
    setProperty( "sizeGripEnabled", QVariant( TRUE, 0 ) );
    initDialog();

    doOptions();
    ftpSiteDlg();
    BrowserDlg();
}

/*
 *  Destroys the object and frees any allocated resources
 */
optionsDialog::~optionsDialog()
{
      // no need to delete child widgets, Qt does it all for us
}


void optionsDialog::OnExit()
{
    writeConfig();
//    accept();
    exit(0);
}


/// optionsDialog
void optionsDialog::doOptions() {

    config->read();
    getConfig();
}

void optionsDialog::getConfig()
{
    config->setGroup( "FTPsite" );  // ftp server config
    ftp_host=config->readEntry("SiteName", "sailor.gutenberg.org");
    ftp_base_dir= config->readEntry("base",  "/pub/gutenberg");

    TextLabel3->setText( "Current ftp server: "+ftp_host + ftp_base_dir );

    config->setGroup( "Proxy" ); // use ftp/http config
    if( config->readEntry("IsChecked", "FALSE") == "TRUE") {
        Ftp_CheckBox->setChecked( FALSE);
    } else {
        Ftp_CheckBox->setChecked( TRUE);
    }

    config->setGroup( "HttpServer" );
    QString s_http = config->readEntry("Preferred", "http://sailor.gutenbook.org");
    if( s_http == "http://sailor.gutenbook.org")
        ComboBox1->setCurrentItem(0);
    else
        ComboBox1->setCurrentItem(1);

    config->setGroup( "Browser" );
    brow = config->readEntry("Preferred", "Opera");
    browserName=brow;

    TextLabel3_3->setText( "Current http browser: "+brow );

    config->setGroup( "Geometry" );

    QString str;
    str = config->readEntry("Icons", "TRUE");
    if(str == "TRUE") {
        IconsCheckBox->setChecked(TRUE);
        useIcon=TRUE;
    } else {
        IconsCheckBox->setChecked(FALSE);
        useIcon=FALSE;
    }

    bool ok2;
    QString temp;
    config->setGroup( "StyleIze" );
    temp = config->readEntry( "Style", "0");
    int i_style=temp.toInt( &ok2,10);

    if( i_style==0) { styleInt=0; ComboBoxStyle->setCurrentItem(0);}//"stylePlatinum"));
    if( i_style==1) { styleInt=1; ComboBoxStyle->setCurrentItem(1);}//"styleWindows") );
    if( i_style==2){ styleInt=2; ComboBoxStyle->setCurrentItem(2);}//"styleCDE") );
    if( i_style==3) { styleInt=3; ComboBoxStyle->setCurrentItem(3);}//"styleMotif") );
    if( i_style==4) { styleInt=4; ComboBoxStyle->setCurrentItem(4);}//"styleMotifPlus"));
    if( i_style==5) { styleInt=5; ComboBoxStyle->setCurrentItem(5);}//"styleWood") );
    if( i_style==6) { styleInt=6; ComboBoxStyle->setCurrentItem(6);}//"styleSgi") );
    if( i_style==7) { styleInt=7; ComboBoxStyle->setCurrentItem(7);}//"stylePlatinumPlus") );
    if( i_style==8){ styleInt=8; ComboBoxStyle->setCurrentItem(8);}//"styleMetal"));
    if( i_style==9){ styleInt=9; ComboBoxStyle->setCurrentItem(9);}//"styleLace"));
    if( i_style==10){ styleInt=10; ComboBoxStyle->setCurrentItem(10);}//"styleLacePlus"));

    config->setGroup("General");
    QString qExit=config->readEntry("queryEntry","TRUE");
    if(qExit.find("TRUE",0,TRUE) !=-1) {
        cb_queryExit->setChecked(TRUE);
        qDebug("Config Setting    b_qExit=TRUE;");
        b_qExit=TRUE;
    } else {
        cb_queryExit->setChecked(FALSE);
        qDebug("ConfigSetting    b_qExit=FALSE;");
        b_qExit=FALSE;
    }
} // end getConfig

/*
writes to config*/
void optionsDialog::writeConfig()
{
      //   config->read();
    config->setGroup( "Geometry" );
    if( IconsCheckBox->isChecked() ) {
        config->writeEntry("Icons", "TRUE");
    } else {
        config->writeEntry("Icons", "FALSE");
    }
    config->setGroup( "Proxy" );
    if( Http_CheckBox->isChecked()) {
        config->writeEntry("IsChecked", "TRUE");
    } else {
        config->writeEntry("IsChecked", "FALSE");
    }

    config->setGroup( "HttpServer" );
    if( ComboBox1->currentItem()== 0) {
        config->writeEntry("Preferred", "http://sailor.gutenberg.org");
    } else {
        config->writeEntry("Preferred", "http://www.prairienet.org/pg");
    }

    config->setGroup( "FTPsite" );  // ftp server config
    config->writeEntry("SiteName", ftp_host);
    config->writeEntry("base", ftp_base_dir);

    config->setGroup( "Browser" );
    qDebug("Brow is: %s",browserName.latin1());
    if(browserName.find("Preferred",0,false) != -1)
        browserName="Opera";
    config->writeEntry("Preferred", browserName);


   config->setGroup("General");
    if(cb_queryExit->isChecked()) {
        b_qExit=TRUE;
        config->writeEntry("queryEntry","TRUE");
        qDebug("WritingConfig queryEntry=TRUE");
        } else {
        b_qExit=FALSE;
        config->writeEntry("queryEntry","FALSE");
        qDebug("WritingConfig queryEntry=FALSE");
        }

    config->write();
}

void optionsDialog::OptionsFtpClicked()
{
}

/*
Use icons on buttons */
void optionsDialog:: iconCheckB() {

    config->setGroup( "Geometry" );
    if( IconsCheckBox->isChecked() ) {
        useIcon = TRUE;
        config->writeEntry("Icons", "TRUE");
    } else {
        useIcon=FALSE;
        config->writeEntry("Icons", "FALSE");
    }
//    writeConfig();
    config->write();
}


/*
pgwhole or gutindex.all */
void optionsDialog::httpCheckB()
{
//if( Http_CheckBox->isChecked() )
//      useIcon = TRUE;
//  else
//      useIcon=FALSE;
    config->setGroup( "Geometry" );
//
//  if(useIcon) {
//      config->writeEntry("Icons", "FALSE");
//  } else {
//      config->writeEntry("Icons", "TRUE");
//  }
// config->write();

      //  if( Http_CheckBox->isChecked() )  {
//    Http_CheckBox->setChecked( TRUE);
//    Ftp_CheckBox->setChecked( FALSE);
//    }
//    else  {
//    Http_CheckBox->setChecked( FALSE);
//    Ftp_CheckBox->setChecked( TRUE);
//    }
}

void optionsDialog::FtpCheckB()
{
//    if( Ftp_CheckBox->isChecked() ) {
//        Http_CheckBox->setChecked( FALSE);
//        Ftp_CheckBox->setChecked( TRUE);
//    }
//    else  {
//        Http_CheckBox->setChecked( TRUE);
//        Ftp_CheckBox->setChecked( FALSE);
//    }
}

void optionsDialog::onTab( int index)
{
    qDebug("%d",index);
    QMessageBox::message("Note","");
    int curPage=tabWidget->currentPageIndex();
    if(curPage==0 ) {
          // main page
        listBox ->setSelected(0,TRUE);
          // doOptions();
    } else if (curPage==1) {
          // ftpsite
        listBox ->setSelected(1,TRUE);
        ftpSiteDlg();
    }
    else if(curPage==2) {
          // http server
        listBox ->setSelected(2,TRUE);
        BrowserDlg( );
    }
}


void optionsDialog::setStyle( int index) {
qDebug("%d",index);
styleChanged=TRUE;
    if( ComboBoxStyle->currentItem()==0) styleInt=0;//"stylePlatinum"));
    if( ComboBoxStyle->currentItem()==1) styleInt=1;//"styleWindows") );
    if( ComboBoxStyle->currentItem()==2) styleInt=2;//"styleCDE") );
    if( ComboBoxStyle->currentItem()==3) styleInt=3;//"styleMotif") );
    if( ComboBoxStyle->currentItem()==4) styleInt=4;//"styleMotifPlus"));
    if( ComboBoxStyle->currentItem()==5) styleInt=5;//"styleWood") );
    if( ComboBoxStyle->currentItem()==6) styleInt=6;//"styleSgi") );
    if( ComboBoxStyle->currentItem()==7) styleInt=7;//"stylePlatinumPlus") );
    if( ComboBoxStyle->currentItem()==8) styleInt=8;//"styleMetal"));
    if( ComboBoxStyle->currentItem()==9) styleInt=9;//"styleLace"));
    if( ComboBoxStyle->currentItem()==10) styleInt=10;//"styleLacePlus"));
    QString temp;
    temp.setNum(styleInt, 10);
    config->setGroup( "StyleIze" );
    config->writeEntry( "Style", temp);
    config->write();
}

void optionsDialog::slotQueryExit() {
   config->setGroup("General");
    if(cb_queryExit->isChecked()) {
        b_qExit=TRUE;
        config->writeEntry("queryEntry","TRUE");
        qDebug("WritingConfig queryEntry=TRUE");
        } else {
        b_qExit=FALSE;
        config->writeEntry("queryEntry","FALSE");
        qDebug("WritingConfig queryEntry=FALSE");
        }

    config->write();
}

