/***************************************************************************
                          NetworkDialog.h  -  description
                             -------------------
    begin                : Sun Aug 27 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/****************************************************************************
** Created: Sun Aug 27 15:24:16 2000
****************************************************************************/
#ifndef NETWORKDIALOG_H
#define NETWORKDIALOG_H

#include <qdialog.h>
#include <qurloperator.h>
#include <qcstring.h>
#include <qfile.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QLabel;
class QProgressBar;
class QPushButton;

class NetworkDialog : public QDialog
{ 
    Q_OBJECT

public:
    NetworkDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0,  const QString & UrlStr = 0, const QString & fileStr=0, const QString & psrtialFile=0);
    ~NetworkDialog();
    
    QFile fiole;
    QString s_partialFileName;
    QString s_finally;
    bool foundIt;
    QLabel* TextLabel1;
    QLabel * warnLabel;
    QLabel *TextLabel2;
    QLabel* TextLabel3;
    QPushButton* buttonHelp;
//    QPushButton* buttonApply;
    bool ok;

    QPushButton* buttonOk;
    QPushButton* buttonCancel;
    QProgressBar* ProgressBar1;

    QString strUrl;
    QString localFileName;
    bool fileFound;
    int i, totalBytesDownloaded;
    QString networkUrl;
    void initDialog();
    void ListDir( QString Url); 
    bool findFileName( const QString & filename);
  protected:
    QHBoxLayout* hbox;
private slots:
    bool downloadFile(  QString strUrl);
    void fileFinished();
    void transfering(  int bytesDone, int bytesTotal,  QNetworkOperation * op);
    void newData( const QByteArray &ba );
    void slotStart( QNetworkOperation *);
    void slotFinished( QNetworkOperation *);
    void slotDirectoryList(const QValueList<QUrlInfo> &, QNetworkOperation *);
    
    
  private:

    QString getOpenFileName();
    QUrlOperator op;
};

#endif // NETWORKDIALOG_H
