#include <qpushbutton.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qwidget.h>

#include <kapp.h>
#include <kmessagebox.h>
#include <kglobal.h>
#include <klocale.h>
#include <kcolorbtn.h>

#include "providerpref.h"


/**************** \/ providerPref \/ *****************/


providerPref::providerPref(QWidget *parent=0,const QString &p=0)
	:QWidget(parent),providerName(p),device(0),comCon(0),comDiscon(0)
{
	grid=new QGridLayout(this,6,2,10,5);
	grid->setResizeMode(QLayout::Minimum);

	buttonRemove=new QPushButton(i18n("&Remove Provider"),this);
	QObject::connect( buttonRemove, SIGNAL(clicked()), this, SLOT(removeClicked()) );

#ifdef INFO_LABEL
	info=new QLabel("#?",this);
#endif

	lineDev=new QLineEdit(device,this);
	lineComCon=new QLineEdit(comCon,this);
	lineComDiscon=new QLineEdit(comDiscon,this);
	QObject::connect( lineDev, SIGNAL(textChanged(const QString &)), this, SLOT(setDevice(const QString &)) );
	QObject::connect( lineComCon, SIGNAL(textChanged(const QString &)), this, SLOT(setComCon(const QString &)) );
	QObject::connect( lineComDiscon, SIGNAL(textChanged(const QString &)), this, SLOT(setComDiscon(const QString &)) );

	inButton =new KColorButton(QColor(  0,  0,  0),this);
	outButton=new KColorButton(QColor(255,255,255),this);
	inColor = inButton->color();
	outColor=outButton->color();
	QObject::connect( inButton, SIGNAL(changed(const QColor&)), this, SLOT( setInColor(const QColor&)) );
	QObject::connect(outButton, SIGNAL(changed(const QColor&)), this, SLOT(setOutColor(const QColor&)) );


	grid->addWidget(l1=new QLabel(i18n("Device:"),this),0,0,AlignRight);
	grid->addWidget(lineDev,0,1);
	grid->addWidget(l2=new QLabel(i18n("Connect command:"),this),1,0,AlignRight);
	grid->addWidget(lineComCon,1,1);
	grid->addWidget(l3=new QLabel(i18n("Disconnect command:"),this),2,0,AlignRight);
	grid->addWidget(lineComDiscon,2,1);
	grid->addWidget(l4=new QLabel(i18n("Incoming Transfer:"),this),3,0,AlignRight);
	grid->addWidget(inButton,3,1);
	grid->addWidget(l5=new QLabel(i18n("Outgoing Transfer:"),this),4,0,AlignRight);
	grid->addWidget(outButton,4,1);
#ifdef INFO_LABEL
	grid->addWidget(info,5,0);
#endif
	grid->addWidget(buttonRemove,5,1,AlignRight);

}

providerPref::~providerPref()
{
	delete l5;
	delete l4;
	delete l3;
	delete l2;
	delete l1;
	delete outButton;
	delete inButton;
	delete lineComDiscon;
	delete lineComCon;
	delete lineDev;
#ifdef INFO_LABEL
	delete info;
#endif
	delete buttonRemove;
	delete grid;
}


void providerPref::removeClicked(void)
{
	emit remove(ID);
}


void providerPref::setNumber(int n)
{
	ID=n;
#ifdef INFO_LABEL
	info->setText(QString::number(ID));
#endif
}

void providerPref::setInColor(const QColor &c)
{
	inColor=c;
	inButton->setColor(c);
}

void providerPref::setOutColor(const QColor &c)
{
	outColor=c;
	outButton->setColor(c);
}

void providerPref::writeLineEdits(void)
{
	lineDev->setText(device);
	lineComCon->setText(comCon);
	lineComDiscon->setText(comDiscon);
}
